/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.opensaml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLConfigurator;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.BasicSecurityConfiguration;
import org.opensaml.xml.security.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xml.security.SecurityConfiguration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Activator
implements BundleActivator {
    private static TraceComponent tc = Tr.register(Activator.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private static String[] providerConfigs = new String[]{"/default-config.xml", "/schema-config.xml", "/signature-config.xml", "/signature-validation-config.xml", "/encryption-config.xml", "/encryption-validation-config.xml", "/soap11-config.xml", "/wsfed11-protocol-config.xml", "/saml1-assertion-config.xml", "/saml1-protocol-config.xml", "/saml1-core-validation-config.xml", "/saml2-assertion-config.xml", "/saml2-protocol-config.xml", "/saml2-core-validation-config.xml", "/saml1-metadata-config.xml", "/saml2-metadata-config.xml", "/saml2-metadata-validation-config.xml", "/saml2-metadata-idp-discovery-config.xml", "/saml2-protocol-thirdparty-config.xml", "/saml2-metadata-query-config.xml", "/saml2-assertion-delegation-restriction-config.xml", "/saml2-ecp-config.xml", "/xacml10-saml2-profile-config.xml", "/xacml11-saml2-profile-config.xml", "/xacml20-context-config.xml", "/xacml20-policy-config.xml", "/xacml2-saml2-profile-config.xml", "/xacml3-saml2-profile-config.xml", "/wsaddressing-config.xml", "/wssecurity-config.xml"};
    static boolean bInit = false;
    static final long serialVersionUID = 8186194918106431793L;

    /*
     * WARNING - void declaration
     */
    public void start(BundleContext ctx) throws Exception {
        if (!bInit) {
            block11: {
                try {
                    Class<Configuration> clazz = Configuration.class;
                    XMLConfigurator configurator = new XMLConfigurator();
                    for (String config : providerConfigs) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("handling config :" + config), (Object[])new Object[0]);
                            }
                            configurator.load(clazz.getResourceAsStream(config));
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.impl.Activator", (String)"96", (Object)this, (Object[])new Object[]{ctx});
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("ERR handling config :" + config), (Object[])new Object[0]);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Initializing SAML20 Artifact builder when we have SAML output", (Object[])new Object[0]);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"initialize Parser pool", (Object[])new Object[0]);
                    }
                    StaticBasicParserPool sbpp = new StaticBasicParserPool();
                    sbpp.setNamespaceAware(true);
                    sbpp.setMaxPoolSize(50);
                    try {
                        sbpp.initialize();
                    }
                    catch (XMLParserException xMLParserException) {
                        void e;
                        FFDCFilter.processException((Throwable)xMLParserException, (String)"com.ibm.ws.security.saml.impl.Activator", (String)"120", (Object)this, (Object[])new Object[]{ctx});
                        throw new ConfigurationException("Error initializing parser pool", (Exception)e);
                    }
                    Configuration.setParserPool((ParserPool)sbpp);
                    Activator.initializeGlobalSecurityConfiguration();
                }
                catch (Exception clazz) {
                    void e;
                    FFDCFilter.processException((Throwable)clazz, (String)"com.ibm.ws.security.saml.impl.Activator", (String)"127", (Object)this, (Object[])new Object[]{ctx});
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)("handling config Exception:" + e), (Object[])new Object[0]);
                }
            }
            bInit = true;
        }
    }

    public void stop(BundleContext ctx) throws Exception {
    }

    protected static void initializeGlobalSecurityConfiguration() {
        BasicSecurityConfiguration basicSecurityConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultConfig();
        basicSecurityConfiguration.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        Configuration.setGlobalSecurityConfiguration((SecurityConfiguration)basicSecurityConfiguration);
    }
}

