/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class PkixTrustEngineConfig {
    public TraceComponent tcCommon = Tr.register(PkixTrustEngineConfig.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private static final String UTF8 = "UTF-8";
    public static final Object KEY_PROVIDER_ID = "id";
    protected String commonProviderId = null;
    private ConfigurationAdmin commonConfigAdmin = null;
    public static final String KEY_trustedIssuers = "trustedIssuers";
    public static final String KEY_pkixTrustEngine = "pkixTrustEngine";
    public static final String KEY_trustEngine_x509cert = "x509Certificate";
    public static final String KEY_trustEngine_crl = "crl";
    public static final String KEY_trustEngine_trustAnchor = "trustAnchor";
    public static final String KEY_trustEngine_path = "path";
    protected List<String> pkixX509List = Collections.synchronizedList(new ArrayList());
    protected List<String> pkixCrlList = Collections.synchronizedList(new ArrayList());
    protected String trustAnchorName = null;
    protected String[] trustedIssuers = null;
    protected boolean isPkixTrustEngineEnabled = false;
    private String bundleLocation;

    protected void processPkixTrustEngine(Map<String, Object> props, ConfigurationAdmin configAdmin, String bundleLocation) throws Exception {
        String pkixTrustEngine;
        this.commonProviderId = (String)props.get(KEY_PROVIDER_ID);
        this.commonConfigAdmin = configAdmin;
        this.bundleLocation = bundleLocation;
        this.pkixX509List = Collections.synchronizedList(new ArrayList());
        this.pkixCrlList = Collections.synchronizedList(new ArrayList());
        this.isPkixTrustEngineEnabled = false;
        String[] engines = (String[])props.get(KEY_pkixTrustEngine);
        String string = pkixTrustEngine = engines != null && engines.length > 0 ? engines[0] : null;
        if (TraceComponent.isAnyTracingEnabled() && this.tcCommon.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tcCommon, (String)("pkixTrustEngine pid:" + pkixTrustEngine + (engines != null ? "  size:" + engines.length : "  null")), (Object[])new Object[0]);
        }
        if (pkixTrustEngine == null || pkixTrustEngine.isEmpty()) {
            return;
        }
        this.isPkixTrustEngineEnabled = true;
        this.processPkixTrustEngineData(pkixTrustEngine);
    }

    public void processPkixTrustEngineData(String trustEngine) {
        String[] crls;
        String[] certs;
        Configuration config = null;
        try {
            config = this.commonConfigAdmin.getConfiguration(trustEngine, this.bundleLocation);
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && this.tcCommon.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tcCommon, (String)"Invalid saml websso trust engine configuration", (Object[])new Object[]{trustEngine});
            }
            return;
        }
        Dictionary trustEngineProps = config.getProperties();
        if (trustEngineProps == null) {
            return;
        }
        this.trustAnchorName = (String)trustEngineProps.get(KEY_trustEngine_trustAnchor);
        if (TraceComponent.isAnyTracingEnabled() && this.tcCommon.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tcCommon, (String)("trustAnchor = " + this.trustAnchorName), (Object[])new Object[0]);
        }
        if ((certs = (String[])trustEngineProps.get(KEY_trustEngine_x509cert)) == null || certs.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && this.tcCommon.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tcCommon, (String)"No X509Certificates were defined in the trust engine configuration. ", (Object[])new Object[0]);
            }
        } else {
            for (String certPid : certs) {
                Configuration certConfig = null;
                try {
                    certConfig = this.commonConfigAdmin.getConfiguration(certPid, this.bundleLocation);
                }
                catch (IOException ioe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)this.tcCommon, (String)"Invalid X509 Certificate configuration", (Object[])new Object[]{certPid});
                    continue;
                }
                if (certConfig == null || certConfig.getProperties() == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)this.tcCommon, (String)"NULL X509 Certificate configuration", (Object[])new Object[]{certPid});
                    continue;
                }
                String certPath = (String)certConfig.getProperties().get(KEY_trustEngine_path);
                this.pkixX509List.add(certPath);
                if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)this.tcCommon, (String)("Added x509 cert path: " + certPath), (Object[])new Object[0]);
            }
        }
        if ((crls = (String[])trustEngineProps.get(KEY_trustEngine_crl)) == null || crls.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && this.tcCommon.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tcCommon, (String)"No CRLs were defined in the trust engine configuration. ", (Object[])new Object[0]);
            }
        } else {
            for (String crlPid : crls) {
                Configuration crlConfig = null;
                try {
                    crlConfig = this.commonConfigAdmin.getConfiguration(crlPid, this.bundleLocation);
                }
                catch (IOException ioe) {
                    if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)this.tcCommon, (String)"Invalid CRL configuration", (Object[])new Object[]{crlPid});
                    continue;
                }
                if (crlConfig == null || crlConfig.getProperties() == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)this.tcCommon, (String)"NULL CRL configuration", (Object[])new Object[]{crlPid});
                    continue;
                }
                String crlPath = (String)crlConfig.getProperties().get(KEY_trustEngine_path);
                this.pkixCrlList.add(crlPath);
                if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)this.tcCommon, (String)("Added crl path: " + crlPath), (Object[])new Object[0]);
            }
        }
        this.trustedIssuers = this.trim((String[])trustEngineProps.get(KEY_trustedIssuers));
        if (this.trustedIssuers != null) {
            for (int iI = 0; iI < this.trustedIssuers.length; ++iI) {
                try {
                    this.trustedIssuers[iI] = URLDecoder.decode(this.trustedIssuers[iI], UTF8);
                    if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)this.tcCommon, (String)("trustedIssuer[" + iI + "] = " + this.trustedIssuers[iI]), (Object[])new Object[0]);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !this.tcCommon.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)this.tcCommon, (String)("get an unexected Exception:" + e), (Object[])new Object[0]);
                }
            }
        }
    }

    public String toString() {
        String result = "\nproviderId:" + this.commonProviderId + "\ntrustedIssuers:" + (this.trustedIssuers == null ? "null" : Integer.valueOf(this.trustedIssuers.length)) + (!this.isPkixTrustEngineEnabled ? ";" : "\npkixTrustEngine enabled\nx509 cert list:" + this.pkixX509List.toString() + "\ncrl list:" + this.pkixCrlList.toString());
        if (this.tcCommon.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tcCommon, (String)result, (Object[])new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<X509CRL> getX509Crls() {
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        InputStream inStream = null;
        try {
            for (final String crlPath : this.pkixCrlList) {
                try {
                    inStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        static final long serialVersionUID = 4978656213092925295L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Object run() throws FileNotFoundException {
                            return new FileInputStream(crlPath);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, null, null);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    FileNotFoundException e = (FileNotFoundException)pae.getException();
                    throw e;
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509CRL crl = (X509CRL)cf.generateCRL(inStream);
                if (crl == null) continue;
                crls.add(crl);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CRLException cRLException) {
        }
        catch (CertificateException certificateException) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return crls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addX509Certs(Collection<X509Certificate> trustAnchors) {
        InputStream inStream = null;
        try {
            for (final String certPath : this.pkixX509List) {
                try {
                    inStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                        static final long serialVersionUID = 206417726253610234L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Object run() throws FileNotFoundException {
                            return new FileInputStream(certPath);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class, null, null);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    FileNotFoundException e = (FileNotFoundException)pae.getException();
                    throw e;
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
                if (cert == null) continue;
                trustAnchors.add(cert);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CertificateException certificateException) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public abstract Collection<X509Certificate> getPkixTrustAnchors();

    public String[] trim(String[] originals) {
        if (originals == null || originals.length == 0) {
            return null;
        }
        String[] tmpResults = new String[originals.length];
        int iCnt = 0;
        for (int iI = 0; iI < originals.length; ++iI) {
            String original = this.trim(originals[iI]);
            if (original == null) continue;
            tmpResults[iCnt++] = original;
        }
        if (iCnt == 0) {
            return null;
        }
        String[] results = new String[iCnt];
        System.arraycopy(tmpResults, 0, results, 0, iCnt);
        return results;
    }

    public String trim(String original) {
        if (original == null) {
            return null;
        }
        String result = original.trim();
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public String[] getPkixTrustedIssuers() {
        return this.trustedIssuers == null ? null : (String[])this.trustedIssuers.clone();
    }

    protected void unexpectedCall() {
        Exception exception = new Exception("unexpected call void");
        if (this.tcCommon.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tcCommon, (String)("\nThe method is not implemented but get Called\n" + SamlUtil.dumpStackTrace(exception, 8)), (Object[])new Object[0]);
        }
    }

    protected <T> T unexpectedCall(T value) {
        Exception exception = new Exception("unexpected call:" + value);
        if (this.tcCommon.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tcCommon, (String)("\nThe method is not implemented but get Called\n" + SamlUtil.dumpStackTrace(exception, 8)), (Object[])new Object[0]);
        }
        return value;
    }
}

