/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.DumpData;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.security.MetadataCredentialResolverFactory;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.InlineX509DataProvider;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.StaticPKIXValidationInformationResolver;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.opensaml.xml.signature.impl.PKIXSignatureTrustEngine;
import org.w3c.dom.Document;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MsgCtxUtil<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(MsgCtxUtil.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static MsgCtxUtil<?, ?, ?> instance = new MsgCtxUtil();
    static final long serialVersionUID = 8485671836707667367L;

    public static MsgCtxUtil<?, ?, ?> getInstance() {
        return instance;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={PrivilegedActionException.class, MetadataProviderException.class})
    public static AcsDOMMetadataProvider parseIdpMetadataProvider(SsoConfig samlConfig) throws SamlException {
        AcsDOMMetadataProvider acsIdpMetadataProvider = null;
        String strIdpMetadata = samlConfig.getIdpMetadata();
        if (strIdpMetadata != null && !strIdpMetadata.isEmpty()) {
            final File fileIdpMetadata = new File(strIdpMetadata);
            InputStream inputStream = null;
            try {
                StaticBasicParserPool ppMgr2333332 = (StaticBasicParserPool)Configuration.getParserPool();
                inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = -7645066519357773928L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() throws Exception {
                        if (fileIdpMetadata.exists()) {
                            return new FileInputStream(fileIdpMetadata);
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, null, null);
                    }
                });
                if (inputStream != null) {
                    Document doc = ppMgr2333332.parse(inputStream);
                    acsIdpMetadataProvider = new AcsDOMMetadataProvider(doc.getDocumentElement(), fileIdpMetadata);
                    acsIdpMetadataProvider.initialize();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("dumpData metadataProvider:" + DumpData.dumpMetadata(acsIdpMetadataProvider)), (Object[])new Object[0]);
                    }
                }
                if (inputStream == null) return acsIdpMetadataProvider;
            }
            catch (XMLParserException e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"112", null, (Object[])new Object[]{samlConfig});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Can not parse MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e});
                    }
                    throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", (Exception)((Object)e), new Object[]{strIdpMetadata, samlConfig.getProviderId(), e.getMessage()});
                    catch (MetadataProviderException e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Provider error MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e2});
                        }
                        throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", (Exception)((Object)e2), new Object[]{strIdpMetadata, samlConfig.getProviderId(), e2.getMessage()});
                    }
                    catch (PrivilegedActionException e3) {
                        Exception newe = e3.getException();
                        if (newe instanceof FileNotFoundException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Provider error MetadataFile:" + strIdpMetadata), (Object[])new Object[]{newe});
                            }
                            throw new SamlException("SAML20_NO_IDP_METADATA_ERROR", newe, new Object[]{strIdpMetadata, samlConfig.getProviderId(), newe.getMessage()});
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("unexpected Provider error MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e3, newe});
                        }
                        throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", newe, new Object[]{strIdpMetadata, samlConfig.getProviderId(), newe.getMessage()});
                    }
                    catch (NullPointerException e3) {
                        FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"165", null, (Object[])new Object[]{samlConfig});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Provider error MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e3});
                        }
                        throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", (Exception)e3, new Object[]{strIdpMetadata, samlConfig.getProviderId(), e3.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        void e4;
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"182", null, (Object[])new Object[]{samlConfig});
                        if (!tc.isDebugEnabled()) throw throwable;
                        Tr.debug((TraceComponent)tc, (String)("Can not close InputStream of MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e4});
                    }
                    throw throwable;
                }
            }
            try {
                inputStream.close();
                return acsIdpMetadataProvider;
            }
            catch (IOException ppMgr2333332) {
                void e;
                FFDCFilter.processException((Throwable)ppMgr2333332, (String)"com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil", (String)"182", null, (Object[])new Object[]{samlConfig});
                if (!tc.isDebugEnabled()) return acsIdpMetadataProvider;
                Tr.debug((TraceComponent)tc, (String)("Can not close InputStream of MetadataFile:" + strIdpMetadata), (Object[])new Object[]{e});
                return acsIdpMetadataProvider;
            }
        }
        if (!tc.isDebugEnabled()) return acsIdpMetadataProvider;
        Tr.debug((TraceComponent)tc, (String)("The idpMetadataFile in " + samlConfig.getProviderId() + " is null. This has to define the trustStore to verify the signature in SAML Response"), (Object[])new Object[0]);
        return acsIdpMetadataProvider;
    }

    public static TrustEngine<Signature> getTrustedEngine(BasicMessageContext<?, ?, ?> context) throws SamlException {
        SsoConfig ssoConfig = context.getSsoConfig();
        if (!ssoConfig.isPkixTrustEngineEnabled()) {
            return MsgCtxUtil.getTrustedEngineFromMetadata(context);
        }
        return MsgCtxUtil.getTrustedEngineFromPkix(context);
    }

    public static TrustEngine<Signature> getTrustedEngineFromMetadata(BasicMessageContext<?, ?, ?> context) {
        MetadataProvider metadataProvider = context.getMetadataProvider();
        MetadataCredentialResolverFactory factory = MetadataCredentialResolverFactory.getFactory();
        ExplicitKeySignatureTrustEngine engine = new ExplicitKeySignatureTrustEngine((CredentialResolver)factory.getInstance((Object)metadataProvider), MsgCtxUtil.getKeyInfoCredResolver());
        return engine;
    }

    public static TrustEngine<Signature> getTrustedEngineFromPkix(BasicMessageContext<?, ?, ?> context) throws SamlException {
        SsoConfig ssoConfig = context.getSsoConfig();
        Collection<X509Certificate> x509Certs = ssoConfig.getPkixTrustAnchors();
        Collection<X509CRL> x509CRLs = ssoConfig.getX509Crls();
        BasicPKIXValidationInformation pkixValidationInformation = new BasicPKIXValidationInformation(x509Certs, x509CRLs, Integer.valueOf(20));
        ArrayList<BasicPKIXValidationInformation> infos = new ArrayList<BasicPKIXValidationInformation>();
        HashSet names = new HashSet();
        infos.add(pkixValidationInformation);
        StaticPKIXValidationInformationResolver pkixValidationInfoResolver = new StaticPKIXValidationInformationResolver(infos, names);
        PKIXSignatureTrustEngine pkixSignatureTrustEngine = new PKIXSignatureTrustEngine((PKIXValidationInformationResolver)pkixValidationInfoResolver, MsgCtxUtil.getKeyInfoCredResolver());
        return pkixSignatureTrustEngine;
    }

    static KeyInfoCredentialResolver getKeyInfoCredResolver() {
        InlineX509DataProvider x509DataProvider = new InlineX509DataProvider();
        ArrayList<InlineX509DataProvider> providers = new ArrayList<InlineX509DataProvider>();
        providers.add(x509DataProvider);
        BasicProviderKeyInfoCredentialResolver keyInfoCredResolver = new BasicProviderKeyInfoCredentialResolver(providers);
        return keyInfoCredResolver;
    }

    public static boolean validateIssuer(Issuer samlIssuer, BasicMessageContext<?, ?, ?> context, boolean isRsSaml) throws SamlException {
        EntityDescriptor peerEntityMetadata;
        if (samlIssuer.getFormat() != null && !samlIssuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SamlException("SAML20_NO_ISSUER_ERR", null, new Object[]{"urn:oasis:names:tc:SAML:2.0:nameid-format:entity", samlIssuer.getFormat()});
        }
        EntityDescriptor entityDescriptor = peerEntityMetadata = isRsSaml ? null : context.getPeerEntityMetadata();
        if (peerEntityMetadata == null) {
            if (!MsgCtxUtil.tryTrustedIssuers(samlIssuer, context)) {
                throw new SamlException("SAML20_INCORRECT_ISSUER_ERR", null, new Object[]{samlIssuer.getValue()});
            }
            return true;
        }
        if (!peerEntityMetadata.getEntityID().equals(samlIssuer.getValue()) && !MsgCtxUtil.tryTrustedIssuers(samlIssuer, context)) {
            throw new SamlException("SAML20_INCORRECT_ISSUER_ERR", null, new Object[]{samlIssuer.getValue()});
        }
        return true;
    }

    static boolean tryTrustedIssuers(Issuer samlIssuer, BasicMessageContext<?, ?, ?> context) {
        String issuer = samlIssuer.getValue();
        SsoConfig ssoConfig = context.getSsoConfig();
        String[] trustedIssuers = ssoConfig.getPkixTrustedIssuers();
        if (trustedIssuers != null) {
            for (String trustedIssuer : trustedIssuers) {
                if ("ALL_ISSUERS".equals(trustedIssuer)) {
                    return true;
                }
                if (!trustedIssuer.equals(issuer)) continue;
                return true;
            }
        }
        return false;
    }
}

