/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UnsolicitedResponseCache {
    private static final TraceComponent tc = Tr.register(UnsolicitedResponseCache.class, null, null);
    private final Map<String, Object> primaryTable;
    private int entryLimit = 50000;
    private long timeoutInMilliSeconds = 900000L;
    private long clockSkewInMilliSeconds = 0L;
    private Timer timer;
    static final long serialVersionUID = -7086956588075815063L;

    public UnsolicitedResponseCache(int entryLimit, long timeoutInMilliSeconds, long clockSkew) {
        if (entryLimit > 0) {
            this.entryLimit = entryLimit;
        }
        if (timeoutInMilliSeconds > 0L) {
            this.timeoutInMilliSeconds = timeoutInMilliSeconds;
        }
        this.clockSkewInMilliSeconds = clockSkew;
        this.primaryTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        this.scheduleEvictionTask(this.timeoutInMilliSeconds);
    }

    public int size() {
        return this.entryLimit;
    }

    private void scheduleEvictionTask(long timeoutInMilliSeconds) {
        long period;
        EvictionTask evictionTask = new EvictionTask();
        this.timer = new Timer(true);
        long delay = period = timeoutInMilliSeconds;
        this.timer.schedule((TimerTask)evictionTask, delay, period);
    }

    public synchronized void remove(Object key) {
        this.primaryTable.remove(key);
    }

    public synchronized Object get(String key) {
        Object curEntry = this.primaryTable.get(key);
        return curEntry;
    }

    public synchronized void put(String key, Object value) {
        this.primaryTable.put(key, value);
    }

    public synchronized boolean isValid(String key) {
        Object curEntry = this.primaryTable.get(key);
        if (curEntry != null) {
            Date now = new Date();
            Long lEntry = (Long)curEntry;
            Date exp = new Date(lEntry + this.clockSkewInMilliSeconds);
            if (exp.after(now)) {
                return true;
            }
            this.primaryTable.remove(key);
        }
        return false;
    }

    protected synchronized void invalidate() {
        HashMap<String, Object> tmpTable = new HashMap<String, Object>();
        tmpTable.putAll(this.primaryTable);
        Set keys = tmpTable.keySet();
        HashSet<String> keysToRemove = new HashSet<String>();
        Date now = new Date();
        for (String key : keys) {
            Date cd;
            Object ce = tmpTable.get(key);
            if (ce == null || !(cd = new Date((Long)ce)).before(now)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.primaryTable.remove(key);
        }
    }

    protected synchronized void evictStaleEntries() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int size = this.primaryTable.size();
            Tr.debug((TraceComponent)tc, (String)("The current cache size is " + size), (Object[])new Object[0]);
        }
        this.invalidate();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    extends TimerTask {
        static final long serialVersionUID = 758384750662748256L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            UnsolicitedResponseCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EvictionTask.class, null, null);
        }
    }
}

