/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.slo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoHandler;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.WebSSOConsumer;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.slo.IdPInitiatedSLO;
import com.ibm.ws.security.saml.sso20.slo.SLOPostLogoutHandler;
import com.ibm.ws.security.saml.sso20.slo.SPInitiatedSLO;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SLOHandler
implements SsoHandler {
    private static TraceComponent tc = Tr.register(SLOHandler.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SPInitiatedSLO spSlo;
    static final long serialVersionUID = -7256373052801584250L;

    @Override
    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, Map<String, Object> parameters) throws SamlException {
        this.verifySsoRequestNotNull(samlRequest);
        SsoSamlService ssoService = this.getSsoSamlServiceParameter(parameters);
        this.debugRequestAndSsoServiceInfo(request, response, samlRequest, ssoService);
        try {
            if (this.isLogoutEndpointRequest(samlRequest)) {
                this.handleLogoutEndpointRequest(request, response, ssoService, parameters);
            } else if (this.isLogoutResponseFromIdP(request)) {
                this.handleLogoutResponseFromIdp(request, response, samlRequest, ssoService);
            } else if (this.isLogoutRequestFromIdp(request)) {
                this.handleLogoutRequestFromIdp(request, response, samlRequest, ssoService);
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.slo.SLOHandler", (String)"64", (Object)this, (Object[])new Object[]{request, response, samlRequest, parameters});
            String eMsg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_HANDLING_LOGOUT_REQUEST", (Object[])new Object[]{e.getLocalizedMessage()});
            throw new SamlException(eMsg, (Exception)e);
        }
        this.postLogoutRequestProcess();
    }

    void verifySsoRequestNotNull(SsoRequest ssoRequest) throws SamlException {
        if (ssoRequest == null) {
            throw new SamlException(Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_REQUEST_MISSING_SSO_REQUEST", (Object[])new Object[0]));
        }
    }

    SsoSamlService getSsoSamlServiceParameter(Map<String, Object> parameters) throws SamlException {
        if (parameters == null) {
            throw new SamlException(Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_CANNOT_FIND_SAML_SSO_SERVICE", (Object[])new Object[0]));
        }
        SsoSamlService ssoService = (SsoSamlService)parameters.get(Constants.KEY_SAML_SERVICE);
        if (ssoService == null) {
            throw new SamlException(Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_CANNOT_FIND_SAML_SSO_SERVICE", (Object[])new Object[0]));
        }
        return ssoService;
    }

    void debugRequestAndSsoServiceInfo(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, SsoSamlService ssoService) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleRequest(SLO):", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(" providerId:" + ssoService.getProviderId()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(" request:" + request), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(" response:" + response), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(" Request:" + samlRequest), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(" Service:" + ssoService), (Object[])new Object[0]);
        }
    }

    boolean isLogoutEndpointRequest(SsoRequest ssoRequest) {
        return Constants.EndpointType.LOGOUT.equals((Object)ssoRequest.getType());
    }

    void handleLogoutEndpointRequest(HttpServletRequest request, HttpServletResponse response, SsoSamlService ssoService, Map<String, Object> parameters) throws SamlException {
        this.spSlo = new SPInitiatedSLO(ssoService, this.getSubjectFromParameters(parameters));
        this.spSlo.buildandSendSLORequest(request, response);
    }

    private Subject getSubjectFromParameters(Map<String, Object> parameters) throws SamlException {
        if (parameters.get("KEY_SUBJECT") != null) {
            return (Subject)parameters.get("KEY_SUBJECT");
        }
        Tr.error((TraceComponent)tc, (String)"LOGOUT_CANNOT_FIND_SAMLTOKEN", (Object[])new Object[0]);
        throw new SamlException(Tr.formatMessage((TraceComponent)tc, (String)"LOGOUT_CANNOT_FIND_SAMLTOKEN", (Object[])new Object[0]));
    }

    boolean isLogoutResponseFromIdP(HttpServletRequest request) {
        return request.getParameter("SAMLResponse") != null;
    }

    void handleLogoutResponseFromIdp(HttpServletRequest request, HttpServletResponse response, SsoRequest ssoRequest, SsoSamlService ssoService) throws Exception {
        String rawLogoutResponse = request.getParameter("SAMLResponse");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logout response = ", (Object[])new Object[]{rawLogoutResponse});
        }
        int i = response.getStatus();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logout response status = ", (Object[])new Object[]{i});
        }
        String externalRelayState = request.getParameter("RelayState");
        String relayState = null;
        relayState = URLDecoder.decode(externalRelayState, "UTF-8");
        BasicMessageContext<?, ?, ?> msgCtx = WebSSOConsumer.getInstance().handleSAMLLogoutResponse(request, response, ssoService, relayState, ssoRequest);
        SLOPostLogoutHandler postLogoutHandler = new SLOPostLogoutHandler(request, ssoService.getConfig(), msgCtx);
        postLogoutHandler.sendToPostLogoutPage(response);
    }

    boolean isLogoutRequestFromIdp(HttpServletRequest request) {
        return request.getParameter("SAMLRequest") != null;
    }

    void handleLogoutRequestFromIdp(HttpServletRequest request, HttpServletResponse response, SsoRequest ssoRequest, SsoSamlService ssoService) throws SamlException {
        String rawLogoutRequest = request.getParameter("SAMLRequest");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logout request = ", (Object[])new Object[]{rawLogoutRequest});
        }
        BasicMessageContext<?, ?, ?> msgCtx = WebSSOConsumer.getInstance().handleSAMLLogoutRequest(request, response, ssoService, null, ssoRequest);
        IdPInitiatedSLO idpSlo = new IdPInitiatedSLO(ssoService, msgCtx);
        idpSlo.sendSLOResponseToIdp(request, response);
    }

    void postLogoutRequestProcess() {
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class MyHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private static final int BUFFER_SIZE = 2048;
        private final StringWriter sw = new StringWriter(2048);
        static final long serialVersionUID = -2164199744763013134L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MyHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.sw.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MyHttpServletResponseWrapper.class, null, null);
        }
    }
}

