/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.http.internal.EncodingUtilsImpl;
import com.ibm.ws.http.internal.HttpDateFormatImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.staticvalue.StaticValue;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.http.EncodingUtils;
import com.ibm.wsspi.http.HttpDateFormat;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.http.WorkClassifier;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.ee7.HttpTransportBehavior;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.timer.ApproximateTime;
import com.ibm.wsspi.timer.QuickApproxTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.http.dispatcher"}, service={HttpDispatcher.class}, property={"service.vendor=IBM"})
public class HttpDispatcher {
    private static final TraceComponent tc = Tr.register(HttpDispatcher.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.HttpDispatcher");
    private volatile EncodingUtils encodingSvc = null;
    private volatile EventEngine eventSvc = null;
    private volatile ExecutorService executorService = null;
    private volatile CHFWBundle chfw = null;
    public volatile WorkClassifier workClassifier = null;
    private volatile ServiceReference<HttpTransportBehavior> behaviorRef;
    private static volatile boolean useEE7Streams = false;
    private static volatile Boolean useIOExceptionBehavior = null;
    static final String CONFIG_ALIAS = "httpDispatcher";
    static final String PROP_VHOST_NOT_FOUND = "appOrContextRootMissingMessage";
    static final String PROP_ENABLE_WELCOME_PAGE = "enableWelcomePage";
    static final String PROP_PAD_VHOST_NOT_FOUND = "padAppOrContextRootMissingMessage";
    static final String PROP_TRUSTED_PRIVATE_HEADER_ORIGIN = "trustedHeaderOrigin";
    static final String PROP_WC_TRUSTED = "trusted";
    static final String PROP_TRUSTED_SENSITIVE_HEADER_ORIGIN = "trustedSensitiveHeaderOrigin";
    private static final StaticValue<AtomicReference<HttpDispatcher>> instance = StaticValue.createStaticValue((Callable)new Callable<AtomicReference<HttpDispatcher>>(){
        static final long serialVersionUID = -626088799904546164L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public AtomicReference<HttpDispatcher> call() throws Exception {
            return new AtomicReference<HttpDispatcher>();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.HttpDispatcher$1");
        }
    });
    private volatile String appOrContextRootNotFound = null;
    private boolean padAppOrContextRootNotFoundMessage = true;
    private volatile boolean enableWelcomePage = true;
    private volatile String[] origHeaderOrigin = null;
    private volatile boolean usePrivateHeaders = true;
    private volatile HashSet<String> restrictPrivateHeaderOrigin = null;
    private volatile boolean wcTrusted = true;
    private volatile String[] origSensitiveHeaderOrigin = null;
    private volatile boolean useSensitivePrivateHeaders = false;
    private volatile HashSet<String> restrictSensitiveHeaderOrigin = null;
    private static final HashSet<String> sensitiveHeaderList = new HashSet<String>(Arrays.asList("$WSCC", "$WSRA", "$WSRH", "$WSAT", "$WSRU"));
    private static final StaticValue<AtomicInteger> updateCount = StaticValue.createStaticValue((Callable)new Callable<AtomicInteger>(){
        static final long serialVersionUID = 7692591442583394238L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public AtomicInteger call() throws Exception {
            return new AtomicInteger();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.HttpDispatcher$2");
        }
    });
    static final long serialVersionUID = -2618361229569074081L;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
        ((AtomicReference)instance.get()).set(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("HttpDispatcher activated, id=" + properties.get("component.id")), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("HttpDispatcher deactivated, id=" + properties.get("component.id") + ",reason=" + reason), (Object[])new Object[0]);
        }
        ((AtomicReference)instance.get()).compareAndSet(this, null);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        if (null == config || config.isEmpty()) {
            return;
        }
        this.setContextRootNotFoundMessage((String)config.get(PROP_VHOST_NOT_FOUND));
        this.enableWelcomePage(MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)PROP_ENABLE_WELCOME_PAGE, (Object)config.get(PROP_ENABLE_WELCOME_PAGE), (boolean)true));
        this.setPadContextRootNotFoundMessage(MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)PROP_PAD_VHOST_NOT_FOUND, (Object)config.get(PROP_PAD_VHOST_NOT_FOUND), (boolean)false));
        this.origHeaderOrigin = MetatypeUtils.parseStringArray((Object)CONFIG_ALIAS, (String)PROP_TRUSTED_PRIVATE_HEADER_ORIGIN, (Object)config.get(PROP_TRUSTED_PRIVATE_HEADER_ORIGIN), (String[])new String[]{"*"});
        this.origSensitiveHeaderOrigin = MetatypeUtils.parseStringArray((Object)CONFIG_ALIAS, (String)PROP_TRUSTED_SENSITIVE_HEADER_ORIGIN, (Object)config.get(PROP_TRUSTED_SENSITIVE_HEADER_ORIGIN), (String[])new String[]{"none"});
        this.parseTrustedPrivateHeaderOrigin(this.origHeaderOrigin, this.origSensitiveHeaderOrigin);
    }

    public static Boolean isWelcomePageEnabled() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f != null) {
            return f.enableWelcomePage;
        }
        return false;
    }

    private void enableWelcomePage(boolean value) {
        this.enableWelcomePage = value;
    }

    public static String getContextRootNotFoundMessage() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f != null) {
            return f.appOrContextRootNotFound;
        }
        return null;
    }

    private void setContextRootNotFoundMessage(String value) {
        this.appOrContextRootNotFound = value;
    }

    private void setPadContextRootNotFoundMessage(boolean value) {
        this.padAppOrContextRootNotFoundMessage = value;
    }

    public static boolean padContextRootNotFoundMessage() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f != null) {
            return f.padAppOrContextRootNotFoundMessage;
        }
        return true;
    }

    private synchronized void parseTrustedPrivateHeaderOrigin(String[] trustedPrivateHeaderHosts, String[] trustedSensitiveHeaderHosts) {
        ((AtomicInteger)updateCount.get()).incrementAndGet();
        this.restrictPrivateHeaderOrigin = null;
        this.restrictSensitiveHeaderOrigin = null;
        this.usePrivateHeaders = true;
        this.useSensitivePrivateHeaders = false;
        if (!this.wcTrusted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"webcontainer trusted=false; private headers are not trusted from any host", (Object[])new Object[0]);
            }
            this.usePrivateHeaders = false;
            return;
        }
        ArrayList<Object> addrs = new ArrayList<Object>();
        if (trustedPrivateHeaderHosts != null && trustedPrivateHeaderHosts.length > 0) {
            for (String string : trustedPrivateHeaderHosts) {
                if ("none".equalsIgnoreCase(string)) {
                    this.usePrivateHeaders = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted private headers hosts: none", (Object[])new Object[0]);
                    }
                    break;
                }
                if ("*".equals(string)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted private headers hosts: *", (Object[])new Object[0]);
                    }
                    addrs.clear();
                    break;
                }
                addrs.add(string);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"trusted private headers hosts: *", (Object[])new Object[0]);
        }
        if (this.usePrivateHeaders && !addrs.isEmpty()) {
            this.restrictPrivateHeaderOrigin = new HashSet();
            for (String string : addrs) {
                if (string == null || string.isEmpty()) continue;
                this.restrictPrivateHeaderOrigin.add(string.toLowerCase());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("trusted private headers hosts: " + Arrays.toString(addrs.toArray())), (Object[])new Object[0]);
            }
        }
        addrs.clear();
        if (trustedSensitiveHeaderHosts != null && trustedSensitiveHeaderHosts.length > 0) {
            for (String string : trustedSensitiveHeaderHosts) {
                if ("none".equalsIgnoreCase(string)) {
                    this.useSensitivePrivateHeaders = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted sensitive private headers hosts: none", (Object[])new Object[0]);
                    }
                    return;
                }
                if ("*".equals(string)) {
                    addrs.clear();
                    this.useSensitivePrivateHeaders = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"trusted sensitive private headers hosts: *", (Object[])new Object[0]);
                    }
                    break;
                }
                addrs.add(string);
                this.useSensitivePrivateHeaders = true;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"trusted sensitive private headers hosts: none", (Object[])new Object[0]);
            }
            return;
        }
        if (!addrs.isEmpty()) {
            this.restrictSensitiveHeaderOrigin = new HashSet();
            for (String string : addrs) {
                if (string == null || string.isEmpty()) continue;
                this.restrictSensitiveHeaderOrigin.add(string.toLowerCase());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("trusted sensitive private headers hosts: " + Arrays.toString(addrs.toArray())), (Object[])new Object[0]);
            }
        }
    }

    public static boolean usePrivateHeaders(String hostAddr) {
        return HttpDispatcher.usePrivateHeaders(hostAddr, null);
    }

    public static boolean usePrivateHeaders(String hostAddr, String headerName) {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f != null) {
            return f.isTrusted(hostAddr, headerName);
        }
        return headerName == null || !HttpHeaderKeys.isSensitivePrivateHeader(headerName);
    }

    public boolean isTrusted(String hostAddr, String headerName) {
        if (!this.wcTrusted) {
            return false;
        }
        if (hostAddr == null) {
            return this.usePrivateHeaders;
        }
        if (HttpHeaderKeys.isSensitivePrivateHeader(headerName)) {
            return this.isTrustedForSensitiveHeaders(hostAddr);
        }
        if (!this.usePrivateHeaders) {
            return this.isTrustedForSensitiveHeaders(hostAddr);
        }
        if (this.restrictPrivateHeaderOrigin == null) {
            return true;
        }
        boolean trustedOrigin = this.restrictPrivateHeaderOrigin.contains(hostAddr.toLowerCase());
        if (!trustedOrigin) {
            trustedOrigin = this.isTrustedForSensitiveHeaders(hostAddr);
        }
        return trustedOrigin;
    }

    public boolean isTrustedForSensitiveHeaders(String hostAddr) {
        if (!this.useSensitivePrivateHeaders) {
            return false;
        }
        if (this.restrictSensitiveHeaderOrigin == null) {
            return true;
        }
        return this.restrictSensitiveHeaderOrigin.contains(hostAddr.toLowerCase());
    }

    public static HttpDateFormat getDateFormatter() {
        return HttpDateFormatImpl.getInstance();
    }

    @Reference(name="encodingUtils")
    protected void setEncodingUtils(EncodingUtils service) {
        this.encodingSvc = service;
    }

    protected void unsetEncodingUtils(EncodingUtils service) {
        if (this.encodingSvc == service) {
            this.encodingSvc = null;
        }
    }

    public static EncodingUtils getEncodingUtils() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        EncodingUtils svc = null;
        if (f != null) {
            svc = f.encodingSvc;
        }
        if (svc == null) {
            svc = new EncodingUtilsImpl();
        }
        return svc;
    }

    @Reference(name="eventService")
    protected void setEventService(EventEngine service) {
        this.eventSvc = service;
    }

    protected void unsetEventService(EventEngine service) {
        if (this.eventSvc == service) {
            this.eventSvc = null;
        }
    }

    public static EventEngine getEventService() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f != null) {
            return f.eventSvc;
        }
        return null;
    }

    @Reference(name="executorService")
    protected void setExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    protected void unsetExecutorService(ExecutorService service) {
        if (this.executorService == service) {
            this.executorService = null;
        }
    }

    public static ExecutorService getExecutorService() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"HttpDispatcher instance not found", (Object[])new Object[0]);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("HttpDispatcher instance: " + f.toString()), (Object[])new Object[0]);
        }
        return f.executorService;
    }

    public static long getApproxTime() {
        return QuickApproxTime.getApproxTime();
    }

    @Reference(name="approxTime", policy=ReferencePolicy.DYNAMIC)
    protected void setApproxTime(ApproximateTime ref) {
    }

    protected void unsetApproxTime(ApproximateTime ref) {
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        this.chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
        if (bundle == this.chfw) {
            this.chfw = null;
        }
    }

    public static CHFWBundle getCHFWBundle() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f != null) {
            return f.chfw;
        }
        return null;
    }

    public static WsByteBufferPoolManager getBufferManager() {
        CHFWBundle chfw = HttpDispatcher.getCHFWBundle();
        if (null == chfw) {
            return ChannelFrameworkFactory.getBufferManager();
        }
        return chfw.getBufferManager();
    }

    public static ChannelFramework getFramework() {
        CHFWBundle chfw = HttpDispatcher.getCHFWBundle();
        if (null == chfw) {
            return ChannelFrameworkFactory.getChannelFramework();
        }
        return chfw.getFramework();
    }

    @Trivial
    @Reference(policy=ReferencePolicy.DYNAMIC, service=VirtualHostListener.class, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(service.pid=com.ibm.ws.webcontainer)")
    protected void setWebContainer(ServiceReference<VirtualHostListener> ref) {
        this.updatedWebContainer(ref);
    }

    protected void updatedWebContainer(ServiceReference<VirtualHostListener> ref) {
        boolean newTrusted = MetatypeUtils.parseBoolean((Object)"webContainer", (String)PROP_WC_TRUSTED, (Object)ref.getProperty(PROP_WC_TRUSTED), (boolean)true);
        if (newTrusted != this.wcTrusted) {
            this.wcTrusted = newTrusted;
            this.parseTrustedPrivateHeaderOrigin(this.origHeaderOrigin, this.origSensitiveHeaderOrigin);
            ((AtomicInteger)updateCount.get()).getAndIncrement();
        }
    }

    protected void unsetWebContainer(ServiceReference<VirtualHostListener> ref) {
    }

    @Reference(name="workClassifier", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setWorkClassifier(WorkClassifier service) {
        this.workClassifier = service;
    }

    protected void unsetWorkClassifier(WorkClassifier service) {
        if (this.workClassifier == service) {
            this.workClassifier = null;
        }
    }

    public static WorkClassifier getWorkClassifier() {
        HttpDispatcher f = (HttpDispatcher)((AtomicReference)instance.get()).get();
        if (f != null) {
            return f.workClassifier;
        }
        return null;
    }

    public static int getConfigUpdate() {
        return ((AtomicInteger)updateCount.get()).get();
    }

    @Reference(service=HttpTransportBehavior.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setBehavior(ServiceReference<HttpTransportBehavior> reference) {
        this.behaviorRef = reference;
        useEE7Streams = (Boolean)reference.getProperty("useEE7Streams");
        useIOExceptionBehavior = (Boolean)reference.getProperty("useIOEBehavior");
    }

    protected synchronized void unsetBehavior(ServiceReference<HttpTransportBehavior> reference) {
        if (reference == this.behaviorRef) {
            this.behaviorRef = null;
            useEE7Streams = false;
            useIOExceptionBehavior = null;
        }
    }

    public static boolean useEE7Streams() {
        return useEE7Streams;
    }

    public static Boolean useIOEForInboundConnectionsBehavior() {
        return useIOExceptionBehavior;
    }
}

