/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.SchedulingHelper;
import com.ibm.ws.threading.internal.SchedulingRunnableFixedHelper;
import com.ibm.ws.threading.internal.ThreadFactoryImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ScheduledExecutorImpl
extends ScheduledThreadPoolExecutor {
    private static final String threadGroupName = "Scheduled Executor Thread Group";
    private ExecutorService executor;
    static final long serialVersionUID = -9110693807503469597L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void unsetExecutor(ExecutorService executor) {
        this.executor = null;
    }

    public ScheduledExecutorImpl() {
        super(1, new ThreadFactoryImpl("Scheduled Executor", threadGroupName));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        SchedulingRunnableFixedHelper schedulingHelper = new SchedulingRunnableFixedHelper(false, command, this, initialDelay, period, unit);
        ScheduledFuture<?> schedFuture = this.schedule(schedulingHelper, initialDelay, unit);
        schedulingHelper.setScheduledFuture(schedFuture);
        return schedulingHelper;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        SchedulingRunnableFixedHelper schedulingHelper = new SchedulingRunnableFixedHelper(true, command, this, initialDelay, delay, unit);
        ScheduledFuture<?> schedFuture = this.schedule(schedulingHelper, initialDelay, unit);
        schedulingHelper.setScheduledFuture(schedFuture);
        return schedulingHelper;
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable r, RunnableScheduledFuture<V> task) {
        ExecutorService executorService = this.executor;
        if (this.executor == null) {
            return task;
        }
        return new SchedulingHelper<Object>(Executors.callable(r, null), task, executorService, this.getQueue());
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> c, RunnableScheduledFuture<V> task) {
        ExecutorService executorService = this.executor;
        if (this.executor == null) {
            return task;
        }
        return new SchedulingHelper<V>(c, task, executorService, this.getQueue());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ScheduledExecutorImpl.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    }
}

