/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.QueueItem;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class SchedulingHelper<V>
implements RunnableScheduledFuture<V> {
    private final Callable<V> m_callable;
    volatile boolean m_isDone = false;
    volatile boolean m_cancelResult = false;
    RunnableScheduledFuture<V> m_schedFuture;
    CountDownLatch m_coordinationLatch;
    ExecutorService m_executor;
    Future<V> m_defaultFuture;
    RuntimeException m_pendingException = null;
    private final BlockingQueue<Runnable> m_scheduledExecutorQueue;
    static final long serialVersionUID = 2955063284661034074L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SchedulingHelper(Callable<V> inCallable, RunnableScheduledFuture<V> inTask, ExecutorService inExecutor, BlockingQueue<Runnable> scheduledExecutorQueue) {
        this.m_callable = inCallable;
        this.m_coordinationLatch = new CountDownLatch(1);
        this.m_executor = inExecutor;
        this.m_schedFuture = inTask;
        this.m_scheduledExecutorQueue = scheduledExecutorQueue;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.m_schedFuture.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.m_schedFuture.compareTo(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.m_schedFuture.equals(o);
    }

    public final int hashCode() {
        return this.m_schedFuture.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SchedulingHelper<V>: ");
        sb.append("m_callable: " + (this.m_callable != null ? this.m_callable.toString() : "null"));
        sb.append(", m_isDone: " + this.m_isDone);
        sb.append(", m_cancelResult: " + this.m_cancelResult);
        sb.append(", m_schedFuture: " + (this.m_schedFuture != null ? this.m_schedFuture.toString() : "null"));
        sb.append(", m_coordinationLatch: " + (this.m_coordinationLatch != null ? this.m_coordinationLatch.toString() : "null"));
        sb.append(", m_executor: " + this.m_executor);
        sb.append(", m_defaultFuture: " + this.m_defaultFuture);
        sb.append(", m_pendingException: " + this.m_pendingException);
        return sb.toString();
    }

    @Override
    public boolean isCancelled() {
        return this.m_cancelResult;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.m_isDone) {
            return false;
        }
        this.m_isDone = true;
        if (this.m_pendingException != null) {
            return false;
        }
        this.m_cancelResult = this.m_schedFuture.cancel(false);
        if (!this.m_cancelResult || this.m_defaultFuture != null) {
            try {
                this.m_coordinationLatch.await();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.threading.internal.SchedulingHelper", (String)"186", (Object)this, (Object[])new Object[]{mayInterruptIfRunning});
            }
            if (this.m_defaultFuture != null) {
                this.m_cancelResult = this.m_defaultFuture.cancel(mayInterruptIfRunning);
            }
        }
        if (this.m_cancelResult) {
            this.m_pendingException = new CancellationException();
            this.m_scheduledExecutorQueue.remove(this);
        }
        this.m_coordinationLatch.countDown();
        return this.m_cancelResult;
    }

    @Override
    public boolean isDone() {
        boolean retVal = false;
        if (this.m_isDone || this.m_pendingException != null) {
            retVal = true;
        }
        if (this.m_defaultFuture != null && this.m_defaultFuture.isDone()) {
            this.m_isDone = true;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.m_coordinationLatch.await();
        if (this.m_pendingException != null) {
            throw this.m_pendingException;
        }
        return this.m_defaultFuture.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.m_coordinationLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.m_pendingException != null) {
            throw this.m_pendingException;
        }
        return this.m_defaultFuture.get(timeout, unit);
    }

    @Override
    public boolean isPeriodic() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            if (this.isDone()) {
                return;
            }
            ExpeditedFutureTask<V> futureTask = new ExpeditedFutureTask<V>(this.m_callable);
            this.m_defaultFuture = futureTask;
            this.m_executor.execute(futureTask);
            this.m_scheduledExecutorQueue.remove(this);
        }
        catch (Exception futureTask) {
            void e;
            FFDCFilter.processException((Throwable)futureTask, (String)"com.ibm.ws.threading.internal.SchedulingHelper", (String)"288", (Object)this, (Object[])new Object[0]);
            this.m_pendingException = new RuntimeException((Throwable)e);
            return;
        }
        finally {
            this.m_coordinationLatch.countDown();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SchedulingHelper.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ExpeditedFutureTask<V>
    extends FutureTask<V>
    implements QueueItem {
        static final long serialVersionUID = 1001026598119771911L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExpeditedFutureTask(Callable<V> arg0) {
            super(arg0);
        }

        @Override
        public boolean isExpedited() {
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ExpeditedFutureTask.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }
}

