/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.persistence.InMemoryMappingFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="InMemoryUrlStreamHandler", service={URLStreamHandlerService.class, InMemoryUrlStreamHandler.class}, property={"url.handler.protocol=persistence-service", "url.handler.protocol=persistence-service"})
public class InMemoryUrlStreamHandler
extends AbstractURLStreamHandlerService {
    private final Map<String, InMemoryMappingFile> _data = new ConcurrentHashMap<String, InMemoryMappingFile>();
    static final long serialVersionUID = -5424877747323007774L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public URLConnection openConnection(URL u) throws IOException {
        return new PsURLConnection(u, this._data.get(u.getFile()));
    }

    void clear() {
        this._data.clear();
    }

    void deregister(List<URL> urls) {
        for (URL url : urls) {
            this._data.remove(url.getFile());
        }
    }

    void register(URL url, InMemoryMappingFile immf) {
        this._data.put(url.getFile(), immf);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(InMemoryUrlStreamHandler.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class PsURLConnection
    extends URLConnection {
        InMemoryMappingFile _mappingFile;
        static final long serialVersionUID = -6801514122023186911L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PsURLConnection(URL u, InMemoryMappingFile mappingFile) {
            super(u);
            this._mappingFile = mappingFile;
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this._mappingFile.getMappingFile());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PsURLConnection.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
        }
    }
}

