/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.persistence.InMemoryMappingFile;
import com.ibm.wsspi.persistence.PersistenceServiceUnitConfig;
import com.ibm.wsspi.persistence.internal.InMemoryUrlStreamHandler;
import com.ibm.wsspi.persistence.internal.eclipselink.PsSessionEventListener;
import com.ibm.wsspi.persistence.internal.util.DoPrivHelper;
import com.ibm.wsspi.persistence.internal.util.PersistenceClassLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.eclipse.persistence.jpa.PersistenceProvider;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class PUInfoImpl
implements PersistenceUnitInfo {
    private final DataSource _jtaDataSource;
    private final DataSource _nonJtaDataSource;
    private final List<String> _classes;
    private final List<String> _mappingFileNames;
    private final List<URL> _inMemoryMappingFileURLs;
    private final Properties _props;
    private final String _name;
    private static final AtomicInteger _nameGenerator;
    private final PersistenceClassLoader _appLoader;
    private final InMemoryUrlStreamHandler _inMemHandler;
    private final URL _puRoot;
    static final long serialVersionUID = 5212699127289914538L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    PUInfoImpl(PersistenceServiceUnitConfig conf, InMemoryUrlStreamHandler inMemHandler, URL bundleRoot) {
        this._inMemHandler = inMemHandler;
        this._puRoot = bundleRoot;
        this._jtaDataSource = conf.getJtaDataSource();
        this._nonJtaDataSource = conf.getNonJaDataSource();
        this._classes = new ArrayList<String>(conf.getClasses());
        this._name = "persistence_service_pu-" + _nameGenerator.incrementAndGet();
        this._inMemoryMappingFileURLs = new ArrayList<URL>();
        this._mappingFileNames = new ArrayList<String>(conf.getMappingFileNames());
        this._appLoader = DoPrivHelper.newPersistenceClassLoader(conf.getConsumerLoader(), PersistenceProvider.class, PUInfoImpl.class);
        List<InMemoryMappingFile> inMemoryMappingFiles = this.copyInMemoryMappingFiles(conf.getInMemoryMappingFiles());
        for (String file : this._mappingFileNames) {
            this._appLoader.registerFileResource(file);
        }
        List<String> inMemNames = this.processInMemoryMappingFiles(inMemoryMappingFiles);
        this._mappingFileNames.addAll(inMemNames);
        this._props = new Properties();
        if (conf.getCreateOrUpdateTables()) {
            this._props.put("javax.persistence.schema-generation.database.action", "create");
        }
        this._props.putAll(conf.getProperties());
        Boolean allow = conf.getAllowUnicode();
        if (allow == null || allow.equals(Boolean.FALSE)) {
            this._props.put("eclipselink.session-event-listener", PsSessionEventListener.class.getName());
        }
        this._props.putAll(conf.getProperties());
    }

    private List<InMemoryMappingFile> copyInMemoryMappingFiles(List<InMemoryMappingFile> copyIMMF) {
        ArrayList<InMemoryMappingFile> immf = new ArrayList<InMemoryMappingFile>();
        for (InMemoryMappingFile file : copyIMMF) {
            immf.add(new InMemoryMappingFile(file.getMappingFile()));
        }
        return immf;
    }

    private PUInfoImpl(PUInfoImpl source) throws IllegalArgumentException {
        this._puRoot = source._puRoot;
        this._jtaDataSource = source._jtaDataSource;
        this._nonJtaDataSource = source._nonJtaDataSource;
        this._classes = Collections.unmodifiableList(source._classes);
        this._mappingFileNames = Collections.unmodifiableList(source._mappingFileNames);
        this._inMemoryMappingFileURLs = Collections.unmodifiableList(source._inMemoryMappingFileURLs);
        this._appLoader = source._appLoader;
        this._name = "persistence_service_pu-" + _nameGenerator.incrementAndGet();
        this._inMemHandler = source._inMemHandler;
        this._props = new Properties();
        this._props.putAll((Map<?, ?>)source._props);
    }

    public void addTransformer(ClassTransformer arg0) {
    }

    public boolean excludeUnlistedClasses() {
        return true;
    }

    @Trivial
    public ClassLoader getClassLoader() {
        return this._appLoader;
    }

    @Trivial
    public List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    @Trivial
    public DataSource getJtaDataSource() {
        return this._jtaDataSource;
    }

    @Trivial
    public List<String> getManagedClassNames() {
        return this._classes != null ? this._classes : Collections.emptyList();
    }

    @Trivial
    public List<String> getMappingFileNames() {
        return this._mappingFileNames != null ? this._mappingFileNames : Collections.emptyList();
    }

    @Trivial
    public ClassLoader getNewTempClassLoader() {
        throw new UnsupportedOperationException();
    }

    @Trivial
    public DataSource getNonJtaDataSource() {
        return this._nonJtaDataSource;
    }

    @Trivial
    public String getPersistenceProviderClassName() {
        return PersistenceProvider.class.getName();
    }

    @Trivial
    public String getPersistenceUnitName() {
        return this._name;
    }

    @Trivial
    public URL getPersistenceUnitRootUrl() {
        return this._puRoot;
    }

    @Trivial
    public String getPersistenceXMLSchemaVersion() {
        return "2.1";
    }

    @Trivial
    public Properties getProperties() {
        return this._props != null ? this._props : new Properties();
    }

    @Trivial
    public SharedCacheMode getSharedCacheMode() {
        return SharedCacheMode.NONE;
    }

    @Trivial
    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.JTA;
    }

    @Trivial
    public ValidationMode getValidationMode() {
        return ValidationMode.NONE;
    }

    public void close() {
        this._inMemHandler.deregister(this._inMemoryMappingFileURLs);
    }

    PersistenceUnitInfo createCopyWithNewName() {
        return new PUInfoImpl(this);
    }

    @Trivial
    private List<String> processInMemoryMappingFiles(List<InMemoryMappingFile> immfs) {
        ArrayList<String> res = new ArrayList<String>();
        for (InMemoryMappingFile immf : immfs) {
            URL url = this._appLoader.registerInMemoryResource(immf);
            this._inMemHandler.register(url, immf);
            this._inMemoryMappingFileURLs.add(url);
            res.add(immf.getName());
        }
        return res;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PUInfoImpl.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
        _nameGenerator = new AtomicInteger(0);
    }
}

