/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PemKeyUtil {
    protected static final String BEGIN = "-----BEGIN PUBLIC KEY-----";
    protected static final String END = "-----END PUBLIC KEY-----";
    protected static final String BEGIN2 = "-----BEGIN RSA PUBLIC KEY-----";
    protected static final String END2 = "-----END RSA PUBLIC KEY-----";
    protected static final String LINE_SEPARATOR_UNIX = "\n";
    protected static final String LINE_SEPARATOR_MAC = "\r";
    protected static final String LINE_SEPARATOR_WINDOW = "\r\n";
    protected static final String RSA_KEY = "RSA";
    static final long serialVersionUID = 2572840014148294093L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static PublicKey getPublicKey(String pkcs8pem) throws Exception {
        String pemKey = PemKeyUtil.removeDelimiter(pkcs8pem);
        byte[] encodedKey = Base64.decodeBase64((String)pemKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY);
        return keyFactory.generatePublic(keySpec);
    }

    private static String removeDelimiter(String pem) {
        pem = pem.replaceAll(BEGIN, "");
        pem = pem.replaceAll(END, "");
        pem = pem.replaceAll(BEGIN2, "");
        pem = pem.replaceAll(END2, "");
        pem = pem.replaceAll(LINE_SEPARATOR_UNIX, "");
        pem = pem.replaceAll(LINE_SEPARATOR_MAC, "");
        pem = pem.replaceAll(LINE_SEPARATOR_WINDOW, "");
        return pem.trim();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PemKeyUtil.class, null, null);
    }
}

