/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.InformixHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;

public class InformixJCCHelper
extends InformixHelper {
    private static transient com.ibm.ejs.ras.TraceComponent ifxTc = Tr.register((String)"com.ibm.ws.informix.jcclogwriter", (String)"WAS.database", null);
    private static volatile transient PrintWriter pw;
    private final AtomicReference<Method> setJCCLogWriter = new AtomicReference();
    private final AtomicReference<Method> setJCCLogWriter2 = new AtomicReference();
    private static final Class<?>[] TYPES_PrintWriter;
    private static final Class<?>[] TYPES_PrintWriter_int;
    private transient int configuredTraceLevel = 0;
    private transient Class<?> currClass = InformixJCCHelper.class;

    InformixJCCHelper(WSManagedConnectionFactoryImpl mcf) throws Exception {
        super(mcf);
        mcf.supportsGetTypeMap = false;
        this.configuredTraceLevel = 0;
        Collections.addAll(this.staleErrorCodes, -4499);
    }

    @Override
    public void doConnectionSetup(Connection conn) throws SQLException {
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        try {
            stmt.setCursorName(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        stmt.setFetchDirection(1000);
        if (stmt.getMaxFieldSize() != 0) {
            stmt.setMaxFieldSize(0);
        }
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public final boolean doesStatementCacheIsoLevel() {
        return true;
    }

    @Override
    public int getDefaultIsolationLevel() {
        return 4;
    }

    private final Object invokeOnDB2Connection(Connection con, AtomicReference<Method> methRef, String methName, Class<?>[] paramTypes, Object ... params) throws SQLException {
        try {
            Method m = methRef.get();
            if (m == null) {
                Class c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, "com.ibm.db2.jcc.DB2Connection");
                m = c.getMethod(methName, paramTypes);
                methRef.set(m);
            }
            return m.invoke((Object)con, params);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (NoSuchMethodException x) {
            throw (Error)new NoSuchMethodError(methName).initCause(x);
        }
        catch (InvocationTargetException e) {
            throw AdapterUtil.toSQLException(e.getCause());
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && ifxTc.isDebugEnabled() && !mc.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !ifxTc.isDebugEnabled() && mc.loggingEnabled;
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && ifxTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)ifxTc, (String)"Disabling logging on connection: ", (Object[])new Object[]{mc.sqlConn});
        }
        try {
            this.invokeOnDB2Connection(mc.sqlConn, this.setJCCLogWriter, "setJCCLogWriter", TYPES_PrintWriter, new Object[]{null});
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"86", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && ifxTc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((TraceComponent)ifxTc, (String)"Setting printWriter on connection and with level: ", (Object[])new Object[]{pw, mc.sqlConn, this.configuredTraceLevel});
        }
        try {
            this.invokeOnDB2Connection(mc.sqlConn, this.setJCCLogWriter2, "setJCCLogWriter", TYPES_PrintWriter_int, pw, this.configuredTraceLevel);
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"108", (Object)this);
            throw AdapterUtil.translateSQLException(e, mc, true, this.currClass);
        }
        mc.loggingEnabled = true;
    }

    @Override
    boolean isAuthException(SQLException x) {
        return x.getErrorCode() == -4214 || super.isAuthException(x);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (pw == null) {
            pw = new PrintWriter((Writer)new TraceWriter(ifxTc), true);
        }
        com.ibm.websphere.ras.Tr.debug((TraceComponent)ifxTc, (String)"returning", (Object[])new Object[]{pw});
        return pw;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    static {
        TYPES_PrintWriter = new Class[]{PrintWriter.class};
        TYPES_PrintWriter_int = new Class[]{PrintWriter.class, Integer.TYPE};
    }
}

