/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileUtils {
    private static final int maxSearchDepth = 2;
    private static final String FILE_REGEXP = "part\\.(\\d+)\\.(log|txt)";
    private static final String DIR_REGEXP = "(\\d+)";
    private static final Pattern file_Pattern;
    private static final Pattern dir_Pattern;
    static final long serialVersionUID = -6483854922601501075L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static List<File> findFiles(File dir, FileFilter fileFilter) {
        ArrayList<File> retMe = new ArrayList<File>();
        if (fileFilter == null) {
            return retMe;
        }
        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        @TraceOptions
        class DirStackObj {
            List<File> d_lst;
            int index;
            static final long serialVersionUID = 6674346243736630834L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public DirStackObj(List<File> f, int i) {
                this.d_lst = f;
                this.index = i;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(DirStackObj.class, null, null);
            }
        }
        Stack<DirStackObj> dirLstStack = new Stack<DirStackObj>();
        List<File> wrkLst = FileUtils.handleSort(dir);
        int i = 0;
        boolean skip = false;
        while (true) {
            if (i < wrkLst.size()) {
                skip = true;
                File file = wrkLst.get(i);
                if (fileFilter.accept(file)) {
                    retMe.add(file);
                    ++i;
                    skip = false;
                }
                if (file.isDirectory() && dirLstStack.size() < 2) {
                    dirLstStack.push(new DirStackObj(wrkLst, i));
                    File wrkDir = new File(file.getPath());
                    wrkLst = FileUtils.handleSort(wrkDir);
                    i = 0;
                } else {
                    if (!skip) continue;
                    ++i;
                    continue;
                }
            }
            if (i < wrkLst.size()) continue;
            if (dirLstStack.empty()) break;
            DirStackObj dirObj = (DirStackObj)dirLstStack.pop();
            wrkLst = dirObj.d_lst;
            i = ++dirObj.index;
        }
        return retMe;
    }

    private static List<File> handleSort(File dir) {
        File[] wrk = dir.listFiles();
        if (wrk == null) {
            return new ArrayList<File>();
        }
        ArrayList<File> wrk_files = new ArrayList<File>();
        ArrayList<File> wrk_dirs = new ArrayList<File>();
        for (File f : wrk) {
            if (f.isFile()) {
                wrk_files.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            wrk_dirs.add(f);
        }
        Collections.sort(wrk_files, NaturalComparator.instance);
        Collections.sort(wrk_dirs, NaturalComparator.instance);
        wrk_files.addAll(wrk_dirs);
        return wrk_files;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FileUtils.class, null, null);
        file_Pattern = Pattern.compile(FILE_REGEXP);
        dir_Pattern = Pattern.compile(DIR_REGEXP);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class NaturalComparator
    implements Comparator<File> {
        public static final Comparator<File> instance;
        static final long serialVersionUID = 624801401877729641L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NaturalComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String s1 = f1.getName();
            String s2 = f2.getName();
            Matcher m1 = file_Pattern.matcher(s1);
            Matcher m2 = file_Pattern.matcher(s2);
            boolean bothMatch = false;
            if (m1.matches() && m2.matches()) {
                bothMatch = true;
            } else {
                m1 = dir_Pattern.matcher(s1);
                m2 = dir_Pattern.matcher(s2);
                if (m1.matches() && m2.matches()) {
                    bothMatch = true;
                }
            }
            if (bothMatch) {
                return Integer.parseInt(m1.group(1)) - Integer.parseInt(m2.group(1));
            }
            return s1.compareTo(s2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NaturalComparator.class, null, null);
            instance = new NaturalComparator();
        }
    }
}

