/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.ExecutionAssignedToServerException;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.jbatch.container.ws.BatchDispatcher;
import com.ibm.jbatch.container.ws.BatchDispatcherException;
import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.BatchStatusValidator;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.JobStoppedOnStartException;
import com.ibm.jbatch.container.ws.WSBatchAuthService;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobOperator;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jbatch.joblog.JobInstanceLog;
import com.ibm.ws.jbatch.joblog.services.IJobLogManagerService;
import com.ibm.ws.jbatch.rest.BatchManager;
import com.ibm.ws.jbatch.rest.JPAQueryHelperImpl;
import com.ibm.ws.jbatch.rest.internal.BatchJobExecutionAlreadyCompleteException;
import com.ibm.ws.jbatch.rest.internal.BatchJobExecutionNotRunningException;
import com.ibm.ws.jbatch.rest.internal.BatchJobRestartException;
import com.ibm.ws.jbatch.rest.internal.BatchNoSuchJobExecutionException;
import com.ibm.ws.jbatch.rest.internal.BatchNoSuchJobInstanceException;
import com.ibm.ws.jbatch.rest.utils.PurgeStatus;
import com.ibm.ws.jbatch.rest.utils.ResourceBundleRest;
import com.ibm.ws.jbatch.rest.utils.StringUtils;
import com.ibm.ws.jbatch.rest.utils.WSPurgeResponse;
import com.ibm.ws.jbatch.rest.utils.WSSearchObject;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class BatchManagerImpl
implements BatchManager {
    private BatchDispatcher batchDispatcher;
    private WSJobOperator wsJobOperator;
    private WSJobRepository jobRepository;
    private J2EENameFactory j2eeNameFactory;
    private WSBatchAuthService authService;
    private BatchEventsPublisher eventsPublisher;
    private IJobLogManagerService jobLogManagerService;
    protected boolean deactivated = false;
    static final long serialVersionUID = 1205532577813647772L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setWSJobOperator(WSJobOperator ref) {
        this.wsJobOperator = ref;
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setBatchDispatcher(BatchDispatcher ref) {
        this.batchDispatcher = ref;
    }

    @Reference
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        this.eventsPublisher = publisher;
    }

    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = null;
        }
    }

    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        this.j2eeNameFactory = j2eeNameFactory;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSBatchAuthService(WSBatchAuthService bas) {
        this.authService = bas;
    }

    protected void unsetWSBatchAuthService(WSBatchAuthService bas) {
        if (this.authService == bas) {
            this.authService = null;
        }
    }

    protected J2EEName createJ2EEName(String app, String module, String comp) {
        return this.j2eeNameFactory.create(this.getAppName(app, module), this.getModuleName(app, module), StringUtils.isEmpty(comp) ? null : comp);
    }

    protected String getAppName(String app, String module) {
        return !StringUtils.isEmpty(app) ? app : StringUtils.trimSuffixes(module, ".war", ".jar");
    }

    protected String getModuleName(String app, String module) {
        return !StringUtils.isEmpty(module) ? module : app + ".war";
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setIJobLogManagerService(IJobLogManagerService jobLogManagerService) {
        this.jobLogManagerService = jobLogManagerService;
    }

    protected void unsetIJobLogManagerService(IJobLogManagerService jobLogManagerService) {
        if (this.jobLogManagerService == jobLogManagerService) {
            this.jobLogManagerService = null;
        }
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) throws Exception {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, Map<String, Object> config) throws Exception {
        this.deactivated = true;
    }

    @Override
    public WSPurgeResponse purge(long jobInstanceId, boolean purgeJobStoreOnly) {
        WSPurgeResponse purgeResponse;
        block10: {
            purgeResponse = new WSPurgeResponse(jobInstanceId, PurgeStatus.COMPLETED, "Successful purge.", null);
            try {
                if (!this.jobRepository.isJobInstancePurgeable(jobInstanceId)) {
                    purgeResponse.setMessage("The specified job instance, " + jobInstanceId + ", cannot be purged because it has active job executions.");
                    purgeResponse.setPurgeStatus(PurgeStatus.STILL_ACTIVE);
                    return purgeResponse;
                }
            }
            catch (NoSuchJobInstanceException noSuchJobInstanceException) {
                FFDCFilter.processException((Throwable)noSuchJobInstanceException, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"247", (Object)this, (Object[])new Object[]{jobInstanceId, purgeJobStoreOnly});
                purgeResponse.setMessage(ResourceBundleRest.getMessage("job.instance.not.found", jobInstanceId));
                purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
                return purgeResponse;
            }
            if (!purgeJobStoreOnly) {
                try {
                    boolean fileSuccess = this.purgeJobLogFiles(jobInstanceId);
                    if (fileSuccess) {
                        boolean dbSuccess = this.wsJobOperator.purgeJobInstance(jobInstanceId);
                        if (!dbSuccess) {
                            purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). The job logs were sucessfully deleted but not all database entries were deleted.");
                            purgeResponse.setPurgeStatus(PurgeStatus.JOBLOGS_ONLY);
                        }
                        break block10;
                    }
                    purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries.");
                    purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
                }
                catch (BatchJobNotLocalException fileSuccess) {
                    FFDCFilter.processException((Throwable)fileSuccess, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"272", (Object)this, (Object[])new Object[]{jobInstanceId, purgeJobStoreOnly});
                    purgeResponse.setMessage("The request cannot be completed because the job execution did not run on this server.");
                    purgeResponse.setPurgeStatus(PurgeStatus.NOT_LOCAL);
                }
            } else {
                boolean dbSuccess = this.wsJobOperator.purgeJobInstance(jobInstanceId);
                if (!dbSuccess) {
                    purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). Not all database entries were deleted.");
                    purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
                }
            }
        }
        return purgeResponse;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<WSPurgeResponse> purge(boolean purgeJobStoreOnly, int page, int pageSize, String instanceIds, String createTime, String instanceState, String exitStatus) {
        WSSearchObject wsso = null;
        try {
            wsso = new WSSearchObject(instanceIds, createTime, instanceState, exitStatus);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"313", (Object)this, (Object[])new Object[]{purgeJobStoreOnly, page, pageSize, instanceIds, createTime, instanceState, exitStatus});
            ArrayList<WSPurgeResponse> purgeResponseList = new ArrayList<WSPurgeResponse>(1);
            WSPurgeResponse purgeResponse = new WSPurgeResponse(-1L, PurgeStatus.FAILED, "An error occurred while processing the specified parameters", null);
            purgeResponseList.add(purgeResponse);
            return purgeResponseList;
        }
        List jobInstances = this.jobRepository.getJobInstances((IJPAQueryHelper)new JPAQueryHelperImpl(wsso), page, pageSize);
        ArrayList<Long> instanceList = new ArrayList<Long>(jobInstances.size());
        for (WSJobInstance job : jobInstances) {
            instanceList.add(job.getInstanceId());
        }
        ArrayList<WSPurgeResponse> purgeResponseList = new ArrayList<WSPurgeResponse>(instanceList.size());
        Iterator iterator = instanceList.iterator();
        while (iterator.hasNext()) {
            long instanceId = (Long)iterator.next();
            try {
                purgeResponseList.add(this.purge(instanceId, purgeJobStoreOnly));
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"335", (Object)this, (Object[])new Object[]{purgeJobStoreOnly, page, pageSize, instanceIds, createTime, instanceState, exitStatus});
                purgeResponseList.add(new WSPurgeResponse(instanceId, PurgeStatus.FAILED, "Exception ocurred during purge of job instance " + instanceId + " : " + e.getMessage(), null));
            }
        }
        return purgeResponseList;
    }

    /*
     * WARNING - void declaration
     */
    private boolean purgeJobLogFiles(long jobInstanceId) throws BatchJobNotLocalException {
        JobInstanceLog instanceLog = null;
        try {
            instanceLog = this.jobLogManagerService.getJobInstanceLog(jobInstanceId);
        }
        catch (NoSuchJobInstanceException noSuchJobInstanceException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchJobInstanceException, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"357", (Object)this, (Object[])new Object[]{jobInstanceId});
            throw new BatchNoSuchJobInstanceException((Throwable)e, jobInstanceId);
        }
        boolean fileSuccess = instanceLog.purge();
        return fileSuccess;
    }

    private String getCorrelationId(Properties jobParameters) {
        if (jobParameters != null) {
            return jobParameters.getProperty("com_ibm_ws_batch_events_correlationId", null);
        }
        return null;
    }

    @Override
    @FFDCIgnore(value={JobStoppedOnStartException.class})
    public WSJobInstance start(String appName, String moduleName, String compName, String jobXMLName, Properties jobParameters, String jsl) throws BatchDispatcherException {
        J2EEName j2eeName = this.createJ2EEName(appName, moduleName, compName);
        String correlationId = this.getCorrelationId(jobParameters);
        WSJobInstance jobInstance = this.wsJobOperator.createJobInstance(j2eeName.toString(), jobXMLName, jsl, correlationId);
        WSJobExecution jobExecution = this.jobRepository.createJobExecution(jobInstance.getInstanceId(), jobParameters);
        if (this.eventsPublisher != null) {
            this.eventsPublisher.publishJobExecutionEvent(jobExecution, "batch/jobs/execution/starting", correlationId);
        }
        try {
            this.batchDispatcher.start((WSJobInstance)jobExecution.getJobInstance(), jobParameters, jobExecution.getExecutionId());
        }
        catch (JobStoppedOnStartException jobStoppedOnStartException) {
            // empty catch block
        }
        return this.jobRepository.getJobInstanceFromExecution(jobExecution.getExecutionId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long stopJobInstance(long jobInstanceId) throws BatchNoSuchJobInstanceException, BatchJobExecutionNotRunningException, BatchContainerRuntimeException, JobSecurityException, BatchJobNotLocalException {
        WSJobExecution jobExec = (WSJobExecution)this.getMostRecentJobExecutionFromInstance(jobInstanceId);
        if (jobExec == null && this.authService != null) {
            this.authService.authorizedJobStopByInstance(jobInstanceId);
        }
        if (jobExec == null) {
            long execId = -1L;
            WSJobInstance jobInstance = this.jobRepository.getJobInstance(jobInstanceId);
            this.jobRepository.updateJobInstanceWithInstanceStateAndBatchStatus(jobInstanceId, InstanceState.STOPPED, BatchStatus.STOPPED);
            if (this.eventsPublisher != null) {
                this.eventsPublisher.publishJobInstanceEvent(jobInstance, "batch/jobs/instance/stopping", null);
                this.eventsPublisher.publishJobInstanceEvent(jobInstance, "batch/jobs/instance/stopped", null);
            }
            return execId;
        }
        try {
            return this.stopJobExecution(jobExec.getExecutionId());
        }
        catch (BatchJobExecutionNotRunningException execId) {
            void e;
            FFDCFilter.processException((Throwable)((Object)execId), (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"464", (Object)this, (Object[])new Object[]{jobInstanceId});
            throw new BatchJobExecutionNotRunningException((Throwable)e, e.getJobExecutionId(), jobInstanceId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalStateException.class})
    protected JobExecution getMostRecentJobExecutionFromInstance(long jobInstanceId) throws BatchNoSuchJobInstanceException {
        try {
            return this.jobRepository.getMostRecentJobExecutionFromInstance(jobInstanceId);
        }
        catch (NoSuchJobInstanceException noSuchJobInstanceException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchJobInstanceException, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"479", (Object)this, (Object[])new Object[]{jobInstanceId});
            throw new BatchNoSuchJobInstanceException((Throwable)e, jobInstanceId);
        }
        catch (IllegalStateException i) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WSJobInstance restartJobInstance(long jobInstanceId, Properties jobParameters) throws BatchNoSuchJobInstanceException, BatchContainerRuntimeException, BatchJobExecutionAlreadyCompleteException, BatchJobRestartException {
        long execId = -1L;
        WSJobExecution jobExec = (WSJobExecution)this.getMostRecentJobExecutionFromInstance(jobInstanceId);
        if (this.authService != null) {
            this.authService.authorizedJobRestartByInstance(jobInstanceId);
        }
        try {
            if (jobExec == null) {
                BatchStatusValidator.validateStatusAtInstanceRestart((long)jobInstanceId, (Properties)jobParameters);
            } else {
                execId = jobExec.getExecutionId();
                BatchStatusValidator.validateStatusAtExecutionRestart((long)execId, (Properties)jobParameters);
            }
            this.jobRepository.updateJobInstanceStateOnRestart(jobInstanceId);
            WSJobExecution exec = this.jobRepository.createJobExecution(jobInstanceId, jobParameters);
            execId = exec.getExecutionId();
            if (this.eventsPublisher != null) {
                String correlationId = this.getCorrelationId(jobParameters);
                this.eventsPublisher.publishJobExecutionEvent(exec, "batch/jobs/execution/starting", correlationId);
            }
            this.batchDispatcher.restartInstance(jobInstanceId, jobParameters, exec.getExecutionId());
            return this.jobRepository.getJobInstance(jobInstanceId);
        }
        catch (JobExecutionAlreadyCompleteException exec) {
            void e;
            FFDCFilter.processException((Throwable)exec, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"532", (Object)this, (Object[])new Object[]{jobInstanceId, jobParameters});
            throw new BatchJobExecutionAlreadyCompleteException((Throwable)e, execId, jobInstanceId);
        }
        catch (JobRestartException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"534", (Object)this, (Object[])new Object[]{jobInstanceId, jobParameters});
            throw new BatchJobRestartException(e, execId, jobInstanceId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long stopJobExecution(long jobExecutionId) throws JobSecurityException, BatchDispatcherException, BatchJobNotLocalException {
        try {
            if (this.authService != null) {
                this.authService.authorizedJobStopByExecution(jobExecutionId);
            }
        }
        catch (NoSuchJobExecutionException noSuchJobExecutionException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchJobExecutionException, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"555", (Object)this, (Object[])new Object[]{jobExecutionId});
            throw new BatchNoSuchJobExecutionException((Throwable)e, jobExecutionId);
        }
        WSJobExecution jobExecution = this.jobRepository.getJobExecution(jobExecutionId);
        try {
            if (!jobExecution.getServerId().equals("")) {
                this.batchDispatcher.stop(jobExecutionId);
                return jobExecutionId;
            }
            try {
                this.jobRepository.updateJobExecutionAndInstanceNotSetToServerYet(jobExecutionId, new Date());
            }
            catch (ExecutionAssignedToServerException executionAssignedToServerException) {
                FFDCFilter.processException((Throwable)executionAssignedToServerException, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"569", (Object)this, (Object[])new Object[]{jobExecutionId});
                this.batchDispatcher.stop(jobExecutionId);
                return jobExecutionId;
            }
            if (this.eventsPublisher != null) {
                this.eventsPublisher.publishJobInstanceEvent((WSJobInstance)jobExecution.getJobInstance(), "batch/jobs/instance/stopping", null);
                this.eventsPublisher.publishJobInstanceEvent((WSJobInstance)jobExecution.getJobInstance(), "batch/jobs/instance/stopped", null);
            }
            return jobExecutionId;
        }
        catch (JobExecutionNotRunningException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"583", (Object)this, (Object[])new Object[]{jobExecutionId});
            throw new BatchJobExecutionNotRunningException(e, jobExecutionId);
        }
        catch (NoSuchJobExecutionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"585", (Object)this, (Object[])new Object[]{jobExecutionId});
            throw new BatchNoSuchJobExecutionException(e, jobExecutionId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WSJobInstance restartJobExecution(long jobExecutionId, Properties jobParams) {
        long previousExecId = jobExecutionId;
        try {
            if (this.authService != null) {
                this.authService.authorizedJobRestartByExecution(previousExecId);
            }
        }
        catch (NoSuchJobExecutionException noSuchJobExecutionException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchJobExecutionException, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"607", (Object)this, (Object[])new Object[]{jobExecutionId, jobParams});
            throw new BatchNoSuchJobExecutionException((Throwable)e, previousExecId);
        }
        try {
            BatchStatusValidator.validateStatusAtExecutionRestart((long)previousExecId, (Properties)jobParams);
            long instanceId = this.jobRepository.getJobInstanceFromExecution(previousExecId).getInstanceId();
            this.jobRepository.updateJobInstanceStateOnRestart(instanceId);
            WSJobExecution exec = this.jobRepository.createJobExecution(instanceId, jobParams);
            long newExecId = exec.getExecutionId();
            if (this.eventsPublisher != null) {
                String correlationId = this.getCorrelationId(jobParams);
                this.eventsPublisher.publishJobExecutionEvent(exec, "batch/jobs/execution/starting", correlationId);
            }
            this.batchDispatcher.restartInstance(instanceId, jobParams, newExecId);
            return this.jobRepository.getJobInstanceFromExecution(newExecId);
        }
        catch (JobExecutionAlreadyCompleteException instanceId) {
            void e;
            FFDCFilter.processException((Throwable)instanceId, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"629", (Object)this, (Object[])new Object[]{jobExecutionId, jobParams});
            throw new BatchJobExecutionAlreadyCompleteException((Throwable)e, previousExecId);
        }
        catch (JobRestartException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"631", (Object)this, (Object[])new Object[]{jobExecutionId, jobParams});
            throw new BatchJobRestartException(e, previousExecId);
        }
        catch (NoSuchJobExecutionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.BatchManagerImpl", (String)"633", (Object)this, (Object[])new Object[]{jobExecutionId, jobParams});
            throw new BatchNoSuchJobExecutionException(e, previousExecId);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BatchManagerImpl.class, (String)"wsbatch", null);
    }
}

