/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal.resources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.rest.internal.BatchRequestUtil;
import com.ibm.ws.jbatch.rest.internal.resources.RequestException;
import com.ibm.ws.jbatch.rest.internal.resources.RequestHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RequestRouter {
    List<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
    static final long serialVersionUID = -8723661222224700785L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RequestRouter addHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
        return this;
    }

    protected RequestHandler getHandler(RESTRequest request) throws IOException {
        List<String> requestPath = BatchRequestUtil.splitPath(request.getPath());
        for (RequestHandler requestHandler : this.requestHandlers) {
            if (!requestHandler.canHandle(requestPath)) continue;
            return requestHandler;
        }
        throw new IOException("No handler for request " + request.getPath());
    }

    /*
     * WARNING - void declaration
     */
    public void routeRequest(RESTRequest request, RESTResponse response) throws Exception {
        try {
            this.routeRequestInternal(request, response, this.getHandler(request));
        }
        catch (RequestException requestException) {
            void re;
            FFDCFilter.processException((Throwable)requestException, (String)"com.ibm.ws.jbatch.rest.internal.resources.RequestRouter", (String)"71", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(re.getHttpResponseCode(), re.getMessage());
        }
    }

    protected void routeRequestInternal(RESTRequest request, RESTResponse response, RequestHandler handler) throws Exception {
        if ("GET".equals(request.getMethod())) {
            handler.get(request, response);
        } else if ("POST".equals(request.getMethod())) {
            handler.post(request, response);
        } else if ("PUT".equals(request.getMethod())) {
            handler.put(request, response);
        } else if ("DELETE".equals(request.getMethod())) {
            handler.delete(request, response);
        } else if ("OPTIONS".equals(request.getMethod())) {
            handler.options(request, response);
        } else if ("TRACE".equals(request.getMethod())) {
            handler.trace(request, response);
        } else {
            throw new IOException("Unrecognized HTTP request method: " + request.getMethod());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RequestRouter.class, (String)"wsbatch", null);
    }
}

