/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.yoko.rmi.util.ComparableComparator;
import org.apache.yoko.rmi.util.Queue;

public class PriorityQueue
implements Queue {
    public static final int DEFAULT_QUEUE_SIZE = 4;
    Comparator cmp;
    int elem_count = 0;
    int elem_max;
    Object[] elem_data;

    public PriorityQueue(int size, Comparator cmp) {
        this.elem_max = size < 4 ? 4 : size;
        this.elem_count = 0;
        this.elem_data = new Object[this.elem_max + 2];
        this.cmp = cmp;
    }

    public PriorityQueue(int size) {
        this(size, new ComparableComparator());
    }

    public PriorityQueue() {
        this(4, new ComparableComparator());
    }

    public PriorityQueue(Comparator cmp) {
        this(4, cmp);
    }

    @Override
    public int size() {
        return this.elem_count;
    }

    @Override
    public Object[] toArray(Object[] result) {
        if (result.length < this.size()) {
            Class<?> elementClass = result.getClass().getComponentType();
            result = (Object[])Array.newInstance(elementClass, this.size());
        }
        int count = this.elem_count;
        for (int i = 0; i < count; ++i) {
            result[i] = this.dequeue();
        }
        return result;
    }

    @Override
    public void clear() {
        this.elem_count = 0;
    }

    @Override
    public Object dequeue() {
        if (this.elem_count == 0) {
            return null;
        }
        Object result = this.elem_data[1];
        this.elem_data[1] = this.elem_data[this.elem_count];
        --this.elem_count;
        this.sift_down(1);
        return result;
    }

    private void sift_down(int i) {
        int top_idx = i;
        int left_idx = i * 2;
        int right_idx = left_idx + 1;
        if (this.elem_count < left_idx) {
            return;
        }
        if (this.elem_count == left_idx) {
            Object left = this.elem_data[left_idx];
            Object top = this.elem_data[top_idx];
            if (this.cmp.compare(left, top) < 0) {
                this.elem_data[top_idx] = left;
                this.elem_data[left_idx] = top;
            }
            return;
        }
        Object top = this.elem_data[top_idx];
        Object left = this.elem_data[left_idx];
        Object right = this.elem_data[right_idx];
        if (this.cmp.compare(left, right) < 0) {
            if (this.cmp.compare(left, top) < 0) {
                this.elem_data[top_idx] = left;
                this.elem_data[left_idx] = top;
                this.sift_down(left_idx);
            }
        } else if (this.cmp.compare(right, top) < 0) {
            this.elem_data[top_idx] = right;
            this.elem_data[right_idx] = top;
            this.sift_down(right_idx);
        }
    }

    @Override
    public void enqueue(Object o) {
        if (this.elem_max == this.elem_count) {
            int new_max = this.elem_max * 2;
            Object[] new_data = new Object[new_max + 2];
            System.arraycopy(this.elem_data, 0, new_data, 0, this.elem_max + 2);
            this.elem_max = new_max;
            this.elem_data = new_data;
        }
        ++this.elem_count;
        this.elem_data[this.elem_count] = o;
        this.sift_up(this.elem_count);
    }

    private void sift_up(int idx) {
        if (idx == 1) {
            return;
        }
        Object me = this.elem_data[idx];
        Object top = this.elem_data[idx / 2];
        if (this.cmp.compare(me, top) < 0) {
            this.elem_data[idx] = top;
            this.elem_data[idx / 2] = me;
            this.sift_up(idx / 2);
        }
    }

    @Override
    public void push(Object o) {
        this.enqueue(o);
    }
}

