/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PathUtils {
    private static final char COLON = ':';
    private static final char OPEN = '{';
    private static final char CLOSE = '}';
    private static final char SLASH = '/';
    private static final Pattern TRIM_PATTERN;
    static final long serialVersionUID = 8109868271769951916L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String parsePath(String uri, Map<String, String> patterns) {
        if (uri == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)uri)) {
            return String.valueOf('/');
        }
        StringCharacterIterator ci = new StringCharacterIterator(uri);
        StringBuilder pathBuffer = new StringBuilder();
        char c = ci.first();
        if (c == '\uffff') {
            return String.valueOf('/');
        }
        do {
            if (c == '{') {
                String regexBuffer = PathUtils.cutParameter(ci, patterns);
                if (regexBuffer == null) {
                    return null;
                }
                pathBuffer.append(regexBuffer);
                continue;
            }
            int length = pathBuffer.length();
            if (c == '/' && length != 0 && pathBuffer.charAt(length - 1) == '/') continue;
            pathBuffer.append(c);
        } while ((c = ci.next()) != '\uffff');
        return pathBuffer.toString();
    }

    public static String collectPath(String ... pathParts) {
        StringBuilder sb = new StringBuilder();
        for (String item : pathParts) {
            String path;
            if (StringUtils.isBlank((CharSequence)item) || !StringUtils.isNotBlank((CharSequence)(path = PathUtils.trimPath(item)))) continue;
            sb.append('/').append(path);
        }
        return sb.length() > 0 ? sb.toString() : String.valueOf('/');
    }

    private static String trimPath(String value) {
        Matcher matcher = TRIM_PATTERN.matcher(value);
        return matcher.find() && StringUtils.isNotBlank((CharSequence)matcher.group(1)) ? matcher.group(1) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String cutParameter(CharacterIterator ci, Map<String, String> patterns) {
        StringBuilder regexBuffer = new StringBuilder();
        int braceCount = 1;
        char regexChar = ci.next();
        while (regexChar != '\uffff') {
            if (regexChar == '{') {
                ++braceCount;
            } else if (regexChar == '}' && --braceCount == 0) break;
            regexBuffer.append(regexChar);
            regexChar = ci.next();
        }
        if (braceCount != 0) {
            return null;
        }
        String regex = StringUtils.trimToNull((String)regexBuffer.toString());
        if (regex == null) {
            return null;
        }
        StringBuilder pathBuffer = new StringBuilder();
        pathBuffer.append('{');
        int index = regex.indexOf(58);
        if (index != -1) {
            String name = StringUtils.trimToNull((String)regex.substring(0, index));
            String value = StringUtils.trimToNull((String)regex.substring(index + 1, regex.length()));
            if (name == null) return null;
            pathBuffer.append(name);
            if (value != null) {
                patterns.put(name, value);
            }
        } else {
            pathBuffer.append(regex);
        }
        pathBuffer.append('}');
        return pathBuffer.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PathUtils.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
        TRIM_PATTERN = Pattern.compile("^/*(.*?)/*$");
    }
}

