/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.CallbackProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ExampleProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.HeaderProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.LinkProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ParameterProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.RequestBodyProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ResponseProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SecuritySchemeProcessor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ComponentsProcessor {
    private final ResolverCache cache;
    private final OpenAPI openApi;
    private final SchemaProcessor schemaProcessor;
    private final ResponseProcessor responseProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ParameterProcessor parameterProcessor;
    private final HeaderProcessor headerProcessor;
    private final ExampleProcessor exampleProcessor;
    private final LinkProcessor linkProcessor;
    private final CallbackProcessor callbackProcessor;
    private final SecuritySchemeProcessor securitySchemeProcessor;
    static final long serialVersionUID = -3615048694492909069L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ComponentsProcessor(OpenAPI openApi, ResolverCache cache) {
        this.cache = cache;
        this.openApi = openApi;
        this.schemaProcessor = new SchemaProcessor(cache, openApi);
        this.responseProcessor = new ResponseProcessor(cache, openApi);
        this.requestBodyProcessor = new RequestBodyProcessor(cache, openApi);
        this.parameterProcessor = new ParameterProcessor(cache, openApi);
        this.headerProcessor = new HeaderProcessor(cache, openApi);
        this.exampleProcessor = new ExampleProcessor(cache, openApi);
        this.linkProcessor = new LinkProcessor(cache, openApi);
        this.callbackProcessor = new CallbackProcessor(cache, openApi);
        this.securitySchemeProcessor = new SecuritySchemeProcessor(cache, openApi);
    }

    public void processComponents() {
        LinkedHashSet<String> keySet;
        if (this.openApi.getComponents() == null) {
            return;
        }
        Map schemas = this.openApi.getComponents().getSchemas();
        Map responses = this.openApi.getComponents().getResponses();
        Map requestBodies = this.openApi.getComponents().getRequestBodies();
        Map parameters = this.openApi.getComponents().getParameters();
        Map headers = this.openApi.getComponents().getHeaders();
        Map examples = this.openApi.getComponents().getExamples();
        Map links = this.openApi.getComponents().getLinks();
        Map callbacks = this.openApi.getComponents().getCallbacks();
        Map securitySchemes = this.openApi.getComponents().getSecuritySchemes();
        if (schemas != null) {
            keySet = new LinkedHashSet<String>();
            while (schemas.keySet().size() > keySet.size()) {
                this.processSchemas(keySet, schemas);
            }
        }
        if (responses != null) {
            keySet = new LinkedHashSet();
            while (responses.keySet().size() > keySet.size()) {
                this.processResponses(keySet, responses);
            }
        }
        if (requestBodies != null) {
            keySet = new LinkedHashSet();
            while (requestBodies.keySet().size() > keySet.size()) {
                this.processRequestBodies(keySet, requestBodies);
            }
        }
        if (parameters != null) {
            keySet = new LinkedHashSet();
            while (parameters.keySet().size() > keySet.size()) {
                this.processParameters(keySet, parameters);
            }
        }
        if (headers != null) {
            keySet = new LinkedHashSet();
            while (headers.keySet().size() > keySet.size()) {
                this.processHeaders(keySet, headers);
            }
        }
        if (examples != null) {
            keySet = new LinkedHashSet();
            while (examples.keySet().size() > keySet.size()) {
                this.processExamples(keySet, examples);
            }
        }
        if (links != null) {
            keySet = new LinkedHashSet();
            while (links.keySet().size() > keySet.size()) {
                this.processLinks(keySet, links);
            }
        }
        if (callbacks != null) {
            keySet = new LinkedHashSet();
            while (callbacks.keySet().size() > keySet.size()) {
                this.processCallbacks(keySet, callbacks);
            }
        }
        if (securitySchemes != null) {
            keySet = new LinkedHashSet();
            while (securitySchemes.keySet().size() > keySet.size()) {
                this.processSecuritySchemes(keySet, securitySchemes);
            }
        }
    }

    private void processSecuritySchemes(Set<String> securitySchemeKey, Map<String, SecurityScheme> securitySchemes) {
        securitySchemeKey.addAll(securitySchemes.keySet());
        for (String securitySchemeName : securitySchemeKey) {
            SecurityScheme securityScheme = securitySchemes.get(securitySchemeName);
            SecurityScheme resolvedSecurityScheme = this.securitySchemeProcessor.processSecurityScheme(securityScheme);
            securitySchemes.replace(securitySchemeName, securityScheme, resolvedSecurityScheme);
        }
    }

    private void processCallbacks(Set<String> callbackKey, Map<String, Callback> callbacks) {
        callbackKey.addAll(callbacks.keySet());
        for (String callbackName : callbackKey) {
            Callback callback = callbacks.get(callbackName);
            this.callbackProcessor.processCallback(callback);
        }
    }

    private void processLinks(Set<String> linkKey, Map<String, Link> links) {
        linkKey.addAll(links.keySet());
        for (String linkName : linkKey) {
            Link link = links.get(linkName);
            this.linkProcessor.processLink(link);
        }
    }

    private void processExamples(Set<String> exampleKey, Map<String, Example> examples) {
        exampleKey.addAll(examples.keySet());
        for (String exampleName : exampleKey) {
            Example example = examples.get(exampleName);
            this.exampleProcessor.processExample(example);
        }
    }

    private void processHeaders(Set<String> HeaderKey, Map<String, Header> headers) {
        HeaderKey.addAll(headers.keySet());
        for (String headersName : HeaderKey) {
            Header header = headers.get(headersName);
            this.headerProcessor.processHeader(header);
        }
    }

    private void processParameters(Set<String> ParametersKey, Map<String, Parameter> parameters) {
        ParametersKey.addAll(parameters.keySet());
        for (String parametersName : ParametersKey) {
            Parameter parameter = parameters.get(parametersName);
            this.parameterProcessor.processParameter(parameter);
        }
    }

    private void processRequestBodies(Set<String> requestBodyKey, Map<String, RequestBody> requestBodies) {
        requestBodyKey.addAll(requestBodies.keySet());
        for (String requestBodyName : requestBodyKey) {
            RequestBody requestBody = requestBodies.get(requestBodyName);
            this.requestBodyProcessor.processRequestBody(requestBody);
        }
    }

    private void processResponses(Set<String> responseKey, Map<String, APIResponse> responses) {
        responseKey.addAll(responses.keySet());
        for (String responseName : responseKey) {
            APIResponse response = responses.get(responseName);
            this.responseProcessor.processResponse(response);
        }
    }

    public void processSchemas(Set<String> schemaKeys, Map<String, Schema> schemas) {
        schemaKeys.addAll(schemas.keySet());
        for (String schemaName : schemaKeys) {
            Schema schema = schemas.get(schemaName);
            this.schemaProcessor.processSchema(schema);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ComponentsProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

