/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.impl.model.ComponentsImpl;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ExternalRefProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    static final long serialVersionUID = 1202642842460420783L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ExternalRefProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public String processRefToExternalSchema(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Schema existingModel;
        LinkedHashMap schemas;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Schema schema = this.cache.loadRef($ref, refFormat, Schema.class);
        if (schema == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((schemas = this.openAPI.getComponents().getSchemas()) == null) {
            schemas = new LinkedHashMap();
        }
        if ((existingModel = (Schema)schemas.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, schemas.keySet()))) != null && existingModel.getRef() != null) {
            existingModel = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingModel == null) {
            Map subProps;
            this.openAPI.getComponents().addSchema(newRef, schema);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (schema.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(schema.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    schema.setRef(this.processRefToExternalSchema(schema.getRef(), format));
                } else {
                    this.processRefToExternalSchema(file + schema.getRef(), RefFormat.RELATIVE);
                }
            }
            if ((subProps = schema.getProperties()) != null) {
                for (Map.Entry prop : subProps.entrySet()) {
                    Schema mapProp;
                    if (((Schema)prop.getValue()).getRef() != null) {
                        this.processRefProperty((Schema)prop.getValue(), file);
                        continue;
                    }
                    if (((Schema)prop.getValue()).getType() == Schema.SchemaType.ARRAY) {
                        Schema arrayProp = (Schema)prop.getValue();
                        if (arrayProp.getItems().getRef() == null) continue;
                        this.processRefProperty(arrayProp.getItems(), file);
                        continue;
                    }
                    if (((Schema)prop.getValue()).getAdditionalProperties() == null || !((mapProp = (Schema)prop.getValue()).getAdditionalProperties() instanceof Schema)) continue;
                    Schema additionalProps = (Schema)mapProp.getAdditionalProperties();
                    if (additionalProps.getRef() != null) {
                        this.processRefProperty(additionalProps, file);
                        continue;
                    }
                    if (additionalProps.getType() != Schema.SchemaType.ARRAY || additionalProps.getItems().getRef() == null) continue;
                    this.processRefProperty(additionalProps.getItems(), file);
                }
            }
            if (schema.getType() == Schema.SchemaType.ARRAY && schema.getItems().getRef() != null) {
                this.processRefProperty(schema.getItems(), file);
            }
        }
        return newRef;
    }

    public String processRefToExternalResponse(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        APIResponse existingResponse;
        LinkedHashMap responses;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        APIResponse response = this.cache.loadRef($ref, refFormat, APIResponse.class);
        if (response == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((responses = this.openAPI.getComponents().getResponses()) == null) {
            responses = new LinkedHashMap();
        }
        if ((existingResponse = (APIResponse)responses.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, responses.keySet()))) != null && existingResponse.getRef() != null) {
            existingResponse = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingResponse == null) {
            this.openAPI.getComponents().addResponse(newRef, response);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (response.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(response.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    response.setRef(this.processRefToExternalResponse(response.getRef(), format));
                } else {
                    this.processRefToExternalResponse(file + response.getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalRequestBody(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        RequestBody existingBody;
        LinkedHashMap bodies;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        RequestBody body = this.cache.loadRef($ref, refFormat, RequestBody.class);
        if (body == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((bodies = this.openAPI.getComponents().getRequestBodies()) == null) {
            bodies = new LinkedHashMap();
        }
        if ((existingBody = (RequestBody)bodies.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, bodies.keySet()))) != null && existingBody.getRef() != null) {
            existingBody = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingBody == null) {
            this.openAPI.getComponents().addRequestBody(newRef, body);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (body.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(body.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    body.setRef(this.processRefToExternalRequestBody(body.getRef(), format));
                } else {
                    this.processRefToExternalRequestBody(file + body.getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalHeader(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Header existingHeader;
        LinkedHashMap headers;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Header header = this.cache.loadRef($ref, refFormat, Header.class);
        if (header == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((headers = this.openAPI.getComponents().getHeaders()) == null) {
            headers = new LinkedHashMap();
        }
        if ((existingHeader = (Header)headers.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, headers.keySet()))) != null && existingHeader.getRef() != null) {
            existingHeader = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingHeader == null) {
            this.openAPI.getComponents().addHeader(newRef, header);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (header.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(header.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    header.setRef(this.processRefToExternalHeader(header.getRef(), format));
                } else {
                    this.processRefToExternalHeader(file + header.getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalSecurityScheme(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        SecurityScheme existingSecurityScheme;
        LinkedHashMap securitySchemeMap;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        SecurityScheme securityScheme = this.cache.loadRef($ref, refFormat, SecurityScheme.class);
        if (securityScheme == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((securitySchemeMap = this.openAPI.getComponents().getSecuritySchemes()) == null) {
            securitySchemeMap = new LinkedHashMap();
        }
        if ((existingSecurityScheme = (SecurityScheme)securitySchemeMap.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, securitySchemeMap.keySet()))) != null && existingSecurityScheme.getRef() != null) {
            existingSecurityScheme = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingSecurityScheme == null) {
            this.openAPI.getComponents().addSecurityScheme(newRef, securityScheme);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (securityScheme.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(securityScheme.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    securityScheme.setRef(this.processRefToExternalSecurityScheme(securityScheme.getRef(), format));
                } else {
                    this.processRefToExternalSecurityScheme(file + securityScheme.getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalLink(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Link existingLink;
        LinkedHashMap links;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Link link = this.cache.loadRef($ref, refFormat, Link.class);
        if (link == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((links = this.openAPI.getComponents().getLinks()) == null) {
            links = new LinkedHashMap();
        }
        if ((existingLink = (Link)links.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, links.keySet()))) != null && existingLink.getRef() != null) {
            existingLink = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingLink == null) {
            this.openAPI.getComponents().addLink(newRef, link);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (link.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(link.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    link.setRef(this.processRefToExternalLink(link.getRef(), format));
                } else {
                    this.processRefToExternalLink(file + link.getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalExample(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Example existingExample;
        LinkedHashMap examples;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Example example = this.cache.loadRef($ref, refFormat, Example.class);
        if (example == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((examples = this.openAPI.getComponents().getExamples()) == null) {
            examples = new LinkedHashMap();
        }
        if ((existingExample = (Example)examples.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, examples.keySet()))) != null && existingExample.getRef() != null) {
            existingExample = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingExample == null) {
            this.openAPI.getComponents().addExample(newRef, example);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (example.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(example.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    example.setRef(this.processRefToExternalExample(example.getRef(), format));
                } else {
                    this.processRefToExternalExample(file + example.getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalParameter(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Parameter existingParameters;
        LinkedHashMap parameters;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Parameter parameter = this.cache.loadRef($ref, refFormat, Parameter.class);
        if (parameter == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((parameters = this.openAPI.getComponents().getParameters()) == null) {
            parameters = new LinkedHashMap();
        }
        if ((existingParameters = (Parameter)parameters.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, parameters.keySet()))) != null && existingParameters.getRef() != null) {
            existingParameters = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingParameters == null) {
            this.openAPI.getComponents().addParameter(newRef, parameter);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (parameter.getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(parameter.getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    parameter.setRef(this.processRefToExternalParameter(parameter.getRef(), format));
                } else {
                    this.processRefToExternalParameter(file + parameter.getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalCallback(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Callback existingCallback;
        LinkedHashMap callbacks;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Callback callback = this.cache.loadRef($ref, refFormat, Callback.class);
        if (callback == null) {
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents((Components)new ComponentsImpl());
        }
        if ((callbacks = this.openAPI.getComponents().getCallbacks()) == null) {
            callbacks = new LinkedHashMap();
        }
        if ((existingCallback = (Callback)callbacks.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref, callback.keySet()))) != null && ((PathItem)existingCallback.get((Object)"$ref")).getRef() != null) {
            existingCallback = null;
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingCallback == null) {
            this.openAPI.getComponents().addCallback(newRef, callback);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (callback.get((Object)"$ref") != null && ((PathItem)callback.get((Object)"$ref")).getRef() != null) {
                RefFormat format = RefUtils.computeRefFormat(((PathItem)callback.get((Object)"$ref")).getRef());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    ((PathItem)callback.get((Object)"$ref")).setRef(this.processRefToExternalCallback(((PathItem)callback.get((Object)"$ref")).getRef(), format));
                } else {
                    this.processRefToExternalCallback(file + ((PathItem)callback.get((Object)"$ref")).getRef(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    private void processRefProperty(Schema subRef, String externalFile) {
        RefFormat format = RefUtils.computeRefFormat(subRef.getRef());
        if (RefUtils.isAnExternalRefFormat(format)) {
            String $ref = this.constructRef(subRef, externalFile);
            subRef.setRef($ref);
            if ($ref.startsWith(".")) {
                this.processRefToExternalSchema($ref, RefFormat.RELATIVE);
            } else {
                this.processRefToExternalSchema($ref, RefFormat.URL);
            }
        } else {
            this.processRefToExternalSchema(externalFile + subRef.getRef(), RefFormat.RELATIVE);
        }
    }

    protected String constructRef(Schema refProperty, String rootLocation) {
        String ref = refProperty.getRef();
        return ExternalRefProcessor.join(rootLocation, ref);
    }

    public static String join(String source, String fragment) {
        try {
            boolean isRelative = false;
            if (source.startsWith("/") || source.startsWith(".")) {
                isRelative = true;
            }
            URI uri = new URI(source);
            if (!source.endsWith("/") && fragment.startsWith("./") && "".equals(uri.getPath())) {
                uri = new URI(source + "/");
            } else if ("".equals(uri.getPath()) && !fragment.startsWith("/")) {
                uri = new URI(source + "/");
            }
            URI f = new URI(fragment);
            URI resolved = uri.resolve(f);
            URI normalized = resolved.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception isRelative) {
            FFDCFilter.processException((Throwable)isRelative, (String)"com.ibm.ws.microprofile.openapi.impl.parser.processors.ExternalRefProcessor", (String)"644", null, (Object[])new Object[]{source, fragment});
            return source;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ExternalRefProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

