/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.model.ComponentsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InlineModelResolver {
    private OpenAPI openAPI;
    private boolean skipMatches;
    Map<String, Schema> addedModels = new HashMap<String, Schema>();
    Map<String, String> generatedSignature = new HashMap<String, String>();
    static final long serialVersionUID = -7476455241848255530L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().setSchemas(new HashMap());
        }
        Paths paths = openAPI.getPaths();
        if (openAPI.getComponents() == null) {
            openAPI.setComponents((Components)new ComponentsImpl());
        }
        Map models = openAPI.getComponents().getSchemas();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get(pathname);
                for (Operation operation : path.readOperations()) {
                    APIResponses responses;
                    Parameter parameter2;
                    List parameters;
                    RequestBody body = operation.getRequestBody();
                    if (body != null && body.getContent() != null) {
                        Content content = body.getContent();
                        for (String key : content.keySet()) {
                            Schema op;
                            Schema am;
                            Schema inner;
                            MediaType mediaType;
                            if (content.get(key) == null || (mediaType = (MediaType)content.get(key)).getSchema() == null) continue;
                            Schema model = mediaType.getSchema();
                            if (model.getProperties() != null && model.getProperties().size() > 0) {
                                this.flattenProperties(model.getProperties(), pathname);
                                String modelName = this.resolveModelName(model.getTitle(), "body");
                                mediaType.setSchema(new SchemaImpl().ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchema(modelName, model);
                                continue;
                            }
                            if (model.getType() != Schema.SchemaType.ARRAY || (inner = (am = model).getItems()).getType() != Schema.SchemaType.OBJECT || (op = inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), "body");
                            Schema innerModel = this.objectmodelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                am.setItems(new SchemaImpl().ref(existing));
                                continue;
                            }
                            am.setItems(new SchemaImpl().ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchema(modelName, innerModel);
                        }
                    }
                    if ((parameters = operation.getParameters()) != null) {
                        for (Parameter parameter2 : parameters) {
                            Schema op;
                            Schema am;
                            Schema inner;
                            if (parameter2.getSchema() == null) continue;
                            Schema model = parameter2.getSchema();
                            if (model.getProperties() != null) {
                                if (model.getType() != null && !"object".equals(model.getType()) || model.getProperties() == null || model.getProperties().size() <= 0) continue;
                                this.flattenProperties(model.getProperties(), pathname);
                                String modelName = this.resolveModelName(model.getTitle(), parameter2.getName());
                                parameter2.setSchema(new SchemaImpl().ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchema(modelName, model);
                                continue;
                            }
                            if (model.getType() != Schema.SchemaType.ARRAY || (inner = (am = model).getItems()).getType() != Schema.SchemaType.OBJECT || (op = inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), parameter2.getName());
                            Schema innerModel = this.objectmodelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                am.setItems(new SchemaImpl().ref(existing));
                                continue;
                            }
                            am.setItems(new SchemaImpl().ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchema(modelName, innerModel);
                        }
                    }
                    if ((responses = operation.getResponses()) == null) continue;
                    parameter2 = responses.keySet().iterator();
                    while (parameter2.hasNext()) {
                        String key = (String)parameter2.next();
                        APIResponse response = (APIResponse)responses.get(key);
                        if (response.getContent() == null) continue;
                        Content content = response.getContent();
                        for (String name : content.keySet()) {
                            Schema op;
                            Schema innerProperty;
                            MediaType media;
                            if (content.get(name) == null || (media = (MediaType)content.get(name)).getSchema() == null) continue;
                            Schema property = media.getSchema();
                            if (property.getType() == Schema.SchemaType.OBJECT) {
                                Schema op2 = property;
                                if (op2.getProperties() == null || op2.getProperties().size() <= 0) continue;
                                String modelName = this.resolveModelName(op2.getTitle(), "inline_response_" + key);
                                Schema model = this.objectmodelFromProperty(op2, modelName);
                                String existing = this.matchGenerated(model);
                                if (existing != null) {
                                    media.setSchema(this.makeRefProperty(existing, property));
                                    continue;
                                }
                                media.setSchema(this.makeRefProperty(modelName, property));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchema(modelName, model);
                                continue;
                            }
                            if (property.getType() == Schema.SchemaType.ARRAY) {
                                Schema op3;
                                Schema ap = property;
                                Schema inner = ap.getItems();
                                if (inner.getType() != Schema.SchemaType.OBJECT || (op3 = inner).getProperties() == null || op3.getProperties().size() <= 0) continue;
                                this.flattenProperties(op3.getProperties(), pathname);
                                String modelName = this.resolveModelName(op3.getTitle(), "inline_response_" + key);
                                Schema innerModel = this.objectmodelFromProperty(op3, modelName);
                                String existing = this.matchGenerated(innerModel);
                                if (existing != null) {
                                    ap.setItems(this.makeRefProperty(existing, op3));
                                    continue;
                                }
                                ap.setItems(this.makeRefProperty(modelName, op3));
                                this.addGenerated(modelName, innerModel);
                                openAPI.getComponents().addSchema(modelName, innerModel);
                                continue;
                            }
                            if (property.getAdditionalProperties() == null || !(property.getAdditionalProperties() instanceof Schema) || (innerProperty = (Schema)property.getAdditionalProperties()).getType() != Schema.SchemaType.OBJECT || (op = innerProperty).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
                            Schema innerModel = this.objectmodelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                property.setAdditionalProperties(new SchemaImpl().ref(existing));
                                continue;
                            }
                            property.setAdditionalProperties(new SchemaImpl().ref(modelName));
                            this.addGenerated(modelName, innerModel);
                            openAPI.getComponents().addSchema(modelName, innerModel);
                        }
                    }
                }
            }
        }
        if (models != null) {
            ArrayList modelNames = new ArrayList(models.keySet());
            for (String modelName : modelNames) {
                Schema model = (Schema)models.get(modelName);
                if (model.getProperties() != null) {
                    Map properties = model.getProperties();
                    this.flattenProperties(properties, modelName);
                    this.fixStringModel(model);
                    continue;
                }
                if (model.getType() == Schema.SchemaType.ARRAY) {
                    Schema op;
                    Schema m = model;
                    Schema inner = m.getItems();
                    if (inner.getType() != Schema.SchemaType.OBJECT || (op = inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                    String innerModelName = this.resolveModelName(op.getTitle(), modelName + "_inner");
                    Schema innerModel = this.objectmodelFromProperty(op, innerModelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing == null) {
                        openAPI.getComponents().addSchema(innerModelName, innerModel);
                        this.addGenerated(innerModelName, innerModel);
                        m.setItems(new SchemaImpl().ref(innerModelName));
                        continue;
                    }
                    m.setItems(new SchemaImpl().ref(existing));
                    continue;
                }
                if (!SchemaProcessor.isComposedSchema(model)) continue;
                Schema composedSchema = model;
                List list = null;
                if (composedSchema.getAllOf() != null) {
                    list = composedSchema.getAllOf();
                } else if (composedSchema.getAnyOf() != null) {
                    list = composedSchema.getAnyOf();
                } else if (composedSchema.getOneOf() != null) {
                    list = composedSchema.getOneOf();
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (((Schema)list.get(i)).getProperties() == null) continue;
                    this.flattenProperties(((Schema)list.get(i)).getProperties(), modelName);
                }
            }
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (m.getType() != null && m.getType().equals((Object)"string") && m.getExample() != null && (example = m.getExample().toString()).substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Schema model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty(model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Schema model) {
        this.generatedSignature.put(Json.pretty(model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        boolean done = false;
        key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        while (!done) {
            String name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.openAPI.getComponents().getSchemas() == null) {
                return name;
            }
            if (!this.openAPI.getComponents().getSchemas().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    public void flattenProperties(Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (String key : properties.keySet()) {
            Schema op;
            Schema inner;
            Schema property = properties.get(key);
            if (property.getType() == Schema.SchemaType.OBJECT && property.getProperties() != null && property.getProperties().size() > 0) {
                Schema op2 = property;
                String modelName = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Schema model = this.objectmodelFromProperty(op2, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    propsToUpdate.put(key, new SchemaImpl().ref(existing));
                    continue;
                }
                propsToUpdate.put(key, new SchemaImpl().ref(modelName));
                modelsToAdd.put(modelName, model);
                this.addGenerated(modelName, model);
                this.openAPI.getComponents().addSchema(modelName, model);
                continue;
            }
            if (property.getType() == Schema.SchemaType.ARRAY) {
                Schema op3;
                Schema ap = property;
                Schema inner2 = ap.getItems();
                if (inner2.getType() != Schema.SchemaType.OBJECT || (op3 = inner2).getProperties() == null || op3.getProperties().size() <= 0) continue;
                this.flattenProperties(op3.getProperties(), path);
                String modelName = this.resolveModelName(op3.getTitle(), path + "_" + key);
                Schema innerModel = this.objectmodelFromProperty(op3, modelName);
                String existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    ap.setItems(new SchemaImpl().ref(existing));
                    continue;
                }
                ap.setItems(new SchemaImpl().ref(modelName));
                this.addGenerated(modelName, innerModel);
                this.openAPI.getComponents().addSchema(modelName, innerModel);
                continue;
            }
            if (property.getAdditionalProperties() == null || !(property.getAdditionalProperties() instanceof Schema) || (inner = (Schema)property.getAdditionalProperties()).getType() != Schema.SchemaType.OBJECT || (op = inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(op.getProperties(), path);
            String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
            Schema innerModel = this.objectmodelFromProperty(op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                property.setAdditionalProperties(new SchemaImpl().ref(existing));
                continue;
            }
            property.setAdditionalProperties(new SchemaImpl().ref(modelName));
            this.addGenerated(modelName, innerModel);
            this.openAPI.getComponents().addSchema(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.openAPI.getComponents().addSchema(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    public Schema arraymodelFromProperty(Schema object, String path) {
        Schema inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()).getType() == Schema.SchemaType.ARRAY) {
            Schema model = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            model.setDescription(description);
            model.setExample((Object)example);
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Schema objectmodelFromProperty(Schema objectSchema, String path) {
        String description = objectSchema.getDescription();
        String example = null;
        Object obj = objectSchema.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = ((SchemaImpl)objectSchema).getName();
        XML xml = objectSchema.getXml();
        Map properties = objectSchema.getProperties();
        SchemaImpl model = new SchemaImpl();
        model.setDescription(description);
        model.setExample((Object)example);
        model.setName(name);
        model.setXml(xml);
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    public Schema schemaModelFromProperty(Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        Schema model = new SchemaImpl().type(Schema.SchemaType.ARRAY);
        model.setDescription(description);
        model.setExample((Object)example);
        if (object.getAdditionalProperties() != null && object.getAdditionalProperties() instanceof Schema) {
            model.setItems((Schema)object.getAdditionalProperties());
        }
        return model;
    }

    public Schema makeRefProperty(String ref, Schema property) {
        Schema newProperty = new SchemaImpl().ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Schema source, Schema target) {
        if (source.getExtensions() != null) {
            Map vendorExtensions = source.getExtensions();
            for (String extName : vendorExtensions.keySet()) {
                ((SchemaImpl)target).addExtension_compat(extName, vendorExtensions.get(extName));
            }
        }
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(InlineModelResolver.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

