/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.model.ComponentsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import com.ibm.ws.microprofile.openapi.impl.model.OpenAPIImpl;
import com.ibm.ws.microprofile.openapi.impl.model.OperationImpl;
import com.ibm.ws.microprofile.openapi.impl.model.PathItemImpl;
import com.ibm.ws.microprofile.openapi.impl.model.PathsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.callbacks.CallbackImpl;
import com.ibm.ws.microprofile.openapi.impl.model.examples.ExampleImpl;
import com.ibm.ws.microprofile.openapi.impl.model.headers.HeaderImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.ContactImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.InfoImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.LicenseImpl;
import com.ibm.ws.microprofile.openapi.impl.model.links.LinkImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.ContentImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.DiscriminatorImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.EncodingImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.MediaTypeImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.XMLImpl;
import com.ibm.ws.microprofile.openapi.impl.model.parameters.ParameterImpl;
import com.ibm.ws.microprofile.openapi.impl.model.parameters.RequestBodyImpl;
import com.ibm.ws.microprofile.openapi.impl.model.responses.APIResponseImpl;
import com.ibm.ws.microprofile.openapi.impl.model.responses.APIResponsesImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.OAuthFlowImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.OAuthFlowsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.ScopesImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.SecurityRequirementImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.SecuritySchemeImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerVariableImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerVariablesImpl;
import com.ibm.ws.microprofile.openapi.impl.model.tags.TagImpl;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.SwaggerParseResult;
import com.ibm.ws.microprofile.openapi.impl.parser.util.SchemaTypeUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIDeserializer {
    protected static Set<String> ROOT_KEYS;
    protected static Set<String> INFO_KEYS;
    protected static Set<String> CONTACT_KEYS;
    protected static Set<String> LICENSE_KEYS;
    protected static Set<String> TAG_KEYS;
    protected static Set<String> RESPONSE_KEYS;
    protected static Set<String> SERVER_KEYS;
    protected static Set<String> SERVER_VARIABLE_KEYS;
    protected static Set<String> PATHITEM_KEYS;
    protected static Set<String> OPERATION_KEYS;
    protected static Set<String> PARAMETER_KEYS;
    protected static Set<String> REQUEST_BODY_KEYS;
    protected static Set<String> SECURITY_SCHEME_KEYS;
    protected static Set<String> EXTERNAL_DOCS_KEYS;
    protected static Set<String> COMPONENTS_KEYS;
    protected static Set<String> SCHEMA_KEYS;
    protected static Set<String> EXAMPLE_KEYS;
    protected static Set<String> HEADER_KEYS;
    protected static Set<String> LINK_KEYS;
    protected static Set<String> MEDIATYPE_KEYS;
    protected static Set<String> XML_KEYS;
    protected static Set<String> OAUTHFLOW_KEYS;
    protected static Set<String> OAUTHFLOWS_KEYS;
    protected static Set<String> ENCODING_KEYS;
    private static final String QUERY_PARAMETER = "query";
    private static final String COOKIE_PARAMETER = "cookie";
    private static final String PATH_PARAMETER = "path";
    private static final String HEADER_PARAMETER = "header";
    static final long serialVersionUID = -2862491568547980866L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public SwaggerParseResult deserialize(JsonNode rootNode, OpenAPI startingModel) {
        SwaggerParseResult result = new SwaggerParseResult();
        try {
            ParseResult rootParse = new ParseResult();
            OpenAPI api = this.parseRoot(rootNode, rootParse, startingModel);
            result.setOpenAPI(api);
            result.setMessages(rootParse.getMessages());
        }
        catch (Exception rootParse) {
            void e;
            FFDCFilter.processException((Throwable)rootParse, (String)"com.ibm.ws.microprofile.openapi.impl.parser.util.OpenAPIDeserializer", (String)"152", (Object)this, (Object[])new Object[]{rootNode, startingModel});
            result.setMessages(Arrays.asList(e.getMessage()));
        }
        return result;
    }

    public OpenAPI parseRoot(JsonNode node, ParseResult result, OpenAPI startingModel) {
        String location = "";
        OpenAPIImpl openAPI = new OpenAPIImpl();
        if (startingModel != null) {
            openAPI = startingModel;
        }
        if (node.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            ArrayNode array;
            ObjectNode rootNode = (ObjectNode)node;
            String value = this.getString("openapi", rootNode, true, location, result);
            if (value == null || !value.startsWith("3.0")) {
                return null;
            }
            openAPI.setOpenapi(value);
            ObjectNode obj = this.getObject("info", rootNode, true, location, result);
            if (obj != null) {
                Info info = this.getInfo(obj, "info", result);
                openAPI.setInfo(info);
            }
            if ((obj = this.getObject("paths", rootNode, true, location, result)) != null) {
                Paths paths = this.getPaths(obj, "paths", result);
                if (openAPI.getPaths() != null && paths != null && paths.size() > 0) {
                    for (Object entry : paths.entrySet()) {
                        openAPI.path((String)entry.getKey(), (PathItem)entry.getValue());
                    }
                } else {
                    openAPI.setPaths(paths);
                }
            }
            if ((obj = this.getObject("components", rootNode, false, location, result)) != null) {
                Components components = this.getComponents(obj, "components", result);
                if (components != null && openAPI.getComponents() != null) {
                    this.mergeComponents(openAPI.getComponents(), components);
                } else if (components != null) {
                    openAPI.setComponents(components);
                }
            }
            if ((array = this.getArray("servers", rootNode, false, location, result)) != null && array.size() > 0) {
                List<Server> servers = this.getServersList(array, String.format("%s.%s'", location, "servers"), result);
                if (openAPI.getServers() != null && openAPI.getServers().size() > 0 && servers != null && servers.size() > 0) {
                    for (Server server : servers) {
                        openAPI.addServer(server);
                    }
                } else if (servers != null && servers.size() > 0) {
                    openAPI.setServers(servers);
                }
            }
            if ((obj = this.getObject("externalDocs", rootNode, false, location, result)) != null) {
                ExternalDocumentation externalDocs = this.getExternalDocs(obj, "externalDocs", result);
                openAPI.setExternalDocs(externalDocs);
            }
            if ((array = this.getArray("tags", rootNode, false, location, result)) != null && array.size() > 0) {
                List<Tag> tags = this.getTagList(array, "tags", result);
                if (openAPI.getTags() != null && openAPI.getTags().size() > 0 && tags != null && tags.size() > 0) {
                    LinkedHashMap tagsMap = new LinkedHashMap();
                    for (Tag tag : openAPI.getTags()) {
                        tagsMap.put(tag.getName(), tag);
                    }
                    for (Tag tag : tags) {
                        tagsMap.put(tag.getName(), tag);
                    }
                    openAPI.setTags(new ArrayList(tagsMap.values()));
                } else if (tags != null && tags.size() > 0) {
                    openAPI.setTags(tags);
                }
            }
            if ((array = this.getArray("security", rootNode, false, location, result)) != null && array.size() > 0) {
                List<SecurityRequirement> securityRequirements = this.getSecurityRequirementsList(array, "security", result);
                if (openAPI.getSecurity() != null && securityRequirements != null && securityRequirements.size() > 0) {
                    for (SecurityRequirement securityRequirement : securityRequirements) {
                        openAPI.addSecurityRequirement(securityRequirement);
                    }
                } else if (securityRequirements != null && securityRequirements.size() > 0) {
                    openAPI.setSecurity(securityRequirements);
                }
            }
            Map<String, Object> extensions = this.getExtensions(rootNode);
            if (openAPI.getExtensions() != null && extensions != null && extensions.size() > 0) {
                openAPI.setExtensions(this.mergeMaps(openAPI.getExtensions(), extensions));
            } else if (extensions != null && extensions.size() > 0) {
                openAPI.setExtensions(extensions);
            }
            Set<String> keys = this.getKeys(rootNode);
            for (String key : keys) {
                if (ROOT_KEYS.contains(key) || key.startsWith("x-")) continue;
                result.extra(location, key, node.get(key));
            }
        } else {
            result.invalidType(location, "openapi", "object", node);
            result.invalid();
            return null;
        }
        return openAPI;
    }

    private void mergeComponents(Components to, Components from) {
        Map resMap = this.mergeMaps(to.getCallbacks(), from.getCallbacks());
        to.setCallbacks(resMap);
        resMap = this.mergeMaps(to.getExamples(), from.getExamples());
        to.setExamples(resMap);
        resMap = this.mergeMaps(to.getExtensions(), from.getExtensions());
        to.setExtensions(resMap);
        resMap = this.mergeMaps(to.getHeaders(), from.getHeaders());
        to.setHeaders(resMap);
        resMap = this.mergeMaps(to.getLinks(), from.getLinks());
        to.setLinks(resMap);
        resMap = this.mergeMaps(to.getParameters(), from.getParameters());
        to.setParameters(resMap);
        resMap = this.mergeMaps(to.getRequestBodies(), from.getRequestBodies());
        to.setRequestBodies(resMap);
        resMap = this.mergeMaps(to.getResponses(), from.getResponses());
        to.setResponses(resMap);
        resMap = this.mergeMaps(to.getSchemas(), from.getSchemas());
        to.setSchemas(resMap);
        resMap = this.mergeMaps(to.getSecuritySchemes(), from.getSecuritySchemes());
        to.setSecuritySchemes(resMap);
    }

    private <T> Map<String, T> mergeMaps(Map<String, T> resultMap, Map<String, T> inMap) {
        if (inMap == null || inMap.isEmpty()) {
            return resultMap;
        }
        if (resultMap == null) {
            resultMap = new LinkedHashMap<String, T>();
        }
        resultMap.putAll(inMap);
        return resultMap;
    }

    public Map<String, Object> getExtensions(ObjectNode node) {
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (!key.startsWith("x-")) continue;
            extensions.put(key, Json.mapper().convertValue((Object)node.get(key), Object.class));
        }
        return extensions;
    }

    public Components getComponents(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        ComponentsImpl components = new ComponentsImpl();
        ObjectNode node = this.getObject("schemas", obj, false, location, result);
        if (node != null) {
            components.setSchemas(this.getSchemas(node, String.format("%s.%s'", location, "schemas"), result));
        }
        if ((node = this.getObject("responses", obj, false, location, result)) != null) {
            components.setResponses((Map)this.getResponses(node, String.format("%s.%s'", location, "responses"), result));
        }
        if ((node = this.getObject("parameters", obj, false, location, result)) != null) {
            components.setParameters(this.getParameters(node, String.format("%s.%s'", location, "parameters"), result));
        }
        if ((node = this.getObject("examples", obj, false, location, result)) != null) {
            components.setExamples(this.getExamples(node, String.format("%s.%s'", location, "examples"), result));
        }
        if ((node = this.getObject("requestBodies", obj, false, location, result)) != null) {
            components.setRequestBodies(this.getRequestBodies(node, String.format("%s.%s'", location, "requestBodies"), result));
        }
        if ((node = this.getObject("headers", obj, false, location, result)) != null) {
            components.setHeaders(this.getHeaders(node, String.format("%s.%s'", location, "headers"), result));
        }
        if ((node = this.getObject("securitySchemes", obj, false, location, result)) != null) {
            components.setSecuritySchemes(this.getSecuritySchemes(node, String.format("%s.%s'", location, "securitySchemes"), result));
        }
        if ((node = this.getObject("links", obj, false, location, result)) != null) {
            components.setLinks(this.getLinks(node, String.format("%s.%s'", location, "links"), result));
        }
        if ((node = this.getObject("callbacks", obj, false, location, result)) != null) {
            components.setCallbacks(this.getCallbacks(node, String.format("%s.%s'", location, "callbacks"), result));
        }
        components.setExtensions(new LinkedHashMap());
        Map<String, Object> extensions = this.getExtensions(obj);
        if (extensions != null && extensions.size() > 0) {
            components.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (COMPONENTS_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return components;
    }

    public List<Tag> getTagList(ArrayNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (JsonNode item : obj) {
            Tag tag;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (tag = this.getTag((ObjectNode)item, location, result)) == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    public Tag getTag(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode docs;
        ExternalDocumentation externalDocs;
        if (obj == null) {
            return null;
        }
        TagImpl tag = new TagImpl();
        String value = this.getString("name", obj, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            tag.setName(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", obj, false, location, result)))) {
            tag.setDescription(value);
        }
        if ((externalDocs = this.getExternalDocs(docs = this.getObject("externalDocs", obj, false, location, result), String.format("%s.%s'", location, "externalDocs"), result)) != null) {
            tag.setExternalDocs(externalDocs);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            tag.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (TAG_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return tag;
    }

    public List<Server> getServersList(ArrayNode obj, String location, ParseResult result) {
        ArrayList<Server> servers = new ArrayList<Server>();
        if (obj == null) {
            return null;
        }
        for (JsonNode item : obj) {
            Server server;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (server = this.getServer((ObjectNode)item, location, result)) == null) continue;
            servers.add(server);
        }
        if (servers.isEmpty()) {
            return null;
        }
        return servers;
    }

    public Server getServer(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode variables;
        ServerVariables serverVariables;
        if (obj == null) {
            return null;
        }
        ServerImpl server = new ServerImpl();
        String value = this.getString("url", obj, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            server.setUrl(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", obj, false, location, result)))) {
            server.setDescription(value);
        }
        if (obj.get("variables") != null && (serverVariables = this.getServerVariables(variables = this.getObject("variables", obj, false, location, result), String.format("%s.%s'", location, "variables"), result)) != null && serverVariables.size() > 0) {
            server.setVariables(serverVariables);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            server.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (SERVER_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return server;
    }

    public ServerVariables getServerVariables(ObjectNode obj, String location, ParseResult result) {
        ServerVariablesImpl serverVariables = new ServerVariablesImpl();
        if (obj == null) {
            return null;
        }
        Set<String> serverKeys = this.getKeys(obj);
        for (String serverName : serverKeys) {
            JsonNode serverValue = obj.get(serverName);
            ObjectNode server = (ObjectNode)serverValue;
            ServerVariable serverVariable = this.getServerVariable(server, String.format("%s.%s'", location, serverName), result);
            serverVariables.addServerVariable(serverName, serverVariable);
        }
        return serverVariables;
    }

    public ServerVariable getServerVariable(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        String value;
        if (obj == null) {
            return null;
        }
        ServerVariableImpl serverVariable = new ServerVariableImpl();
        ArrayNode arrayNode = this.getArray("enum", obj, false, location, result);
        if (arrayNode != null) {
            ArrayList<String> _enum = new ArrayList<String>();
            for (JsonNode n : arrayNode) {
                if (n.isValueNode()) {
                    _enum.add(n.asText());
                    serverVariable.setEnumeration(_enum);
                    continue;
                }
                result.invalidType(location, "enum", "value", n);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("default", obj, true, String.format("%s.%s'", location, "default"), result)))) {
            serverVariable.setDefaultValue(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", obj, false, String.format("%s.%s'", location, "description"), result)))) {
            serverVariable.setDescription(value);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            serverVariable.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (SERVER_VARIABLE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return serverVariable;
    }

    public Paths getPaths(ObjectNode obj, String location, ParseResult result) {
        PathsImpl paths = new PathsImpl();
        if (obj == null) {
            return null;
        }
        Set<String> pathKeys = this.getKeys(obj);
        for (String pathName : pathKeys) {
            JsonNode pathValue = obj.get(pathName);
            if (pathName.startsWith("x-")) {
                result.unsupported(location, pathName, pathValue);
                continue;
            }
            if (!pathValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, pathName, "object", pathValue);
                continue;
            }
            ObjectNode path = (ObjectNode)pathValue;
            PathItem pathObj = this.getPathItem(path, String.format("%s.%s'", location, pathName), result);
            paths.put((Object)pathName, (Object)pathObj);
        }
        return paths;
    }

    public PathItem getPathItem(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        Operation operation;
        ObjectNode node;
        ArrayNode servers;
        ArrayNode parameters;
        PathItemImpl pathItem = new PathItemImpl();
        if (obj.get("$ref") != null) {
            JsonNode ref = obj.get("$ref");
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                pathItem.setRef(ref.asText());
                return (PathItem)pathItem.ref(ref.asText());
            }
            if (ref.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode node2 = (ObjectNode)ref;
                Set<String> keys = this.getKeys(node2);
                for (String key : keys) {
                    result.extra(location, key, node2.get(key));
                }
            }
            return null;
        }
        String value = this.getString("summary", obj, false, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            pathItem.setSummary(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", obj, false, location, result)))) {
            pathItem.setDescription(value);
        }
        if ((parameters = this.getArray("parameters", obj, false, location, result)) != null && parameters.size() > 0) {
            pathItem.setParameters(this.getParameterList(parameters, location, result));
        }
        if ((servers = this.getArray("servers", obj, false, location, result)) != null && servers.size() > 0) {
            pathItem.setServers(this.getServersList(servers, location, result));
        }
        if ((node = this.getObject("get", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(get)", result)) != null) {
            pathItem.setGET(operation);
        }
        if ((node = this.getObject("put", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(put)", result)) != null) {
            pathItem.setPUT(operation);
        }
        if ((node = this.getObject("post", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(post)", result)) != null) {
            pathItem.setPOST(operation);
        }
        if ((node = this.getObject("head", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(head)", result)) != null) {
            pathItem.setHEAD(operation);
        }
        if ((node = this.getObject("delete", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(delete)", result)) != null) {
            pathItem.setDELETE(operation);
        }
        if ((node = this.getObject("patch", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(patch)", result)) != null) {
            pathItem.setPATCH(operation);
        }
        if ((node = this.getObject("options", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(options)", result)) != null) {
            pathItem.setOPTIONS(operation);
        }
        if ((node = this.getObject("trace", obj, false, location, result)) != null && (operation = this.getOperation(node, location + "(options)", result)) != null) {
            pathItem.setTRACE(operation);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            pathItem.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (PATHITEM_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return pathItem;
    }

    public ExternalDocumentation getExternalDocs(ObjectNode node, String location, ParseResult result) {
        ExternalDocumentationImpl externalDocs = null;
        if (node != null) {
            Map<String, Object> extensions;
            externalDocs = new ExternalDocumentationImpl();
            String value = this.getString("description", node, false, location, result);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                externalDocs.description(value);
            }
            if (StringUtils.isNotBlank((CharSequence)(value = this.getString("url", node, true, location, result)))) {
                externalDocs.url(value);
            }
            if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
                externalDocs.setExtensions(extensions);
            }
            Set<String> keys = this.getKeys(node);
            for (String key : keys) {
                if (EXTERNAL_DOCS_KEYS.contains(key) || key.startsWith("x-")) continue;
                result.extra(location, key, node.get(key));
            }
        }
        return externalDocs;
    }

    public String getString(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        String value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "string", (JsonNode)node);
        } else {
            value = v.asText();
        }
        return value;
    }

    public Set<String> getKeys(ObjectNode node) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (node == null) {
            return keys;
        }
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            keys.add((String)it.next());
        }
        return keys;
    }

    public ObjectNode getObject(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        JsonNode value = node.get(key);
        ObjectNode object = null;
        if (value == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!value.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            result.invalidType(location, key, "object", value);
            if (required) {
                result.invalid();
            }
        } else {
            object = (ObjectNode)value;
        }
        return object;
    }

    public Info getInfo(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        InfoImpl info = new InfoImpl();
        String value = this.getString("title", node, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            info.setTitle(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", node, false, location, result)))) {
            info.setDescription(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("termsOfService", node, false, location, result)))) {
            info.setTermsOfService(value);
        }
        ObjectNode obj = this.getObject("contact", node, false, "contact", result);
        Contact contact = this.getContact(obj, String.format("%s.%s'", location, "contact"), result);
        if (obj != null) {
            info.setContact(contact);
        }
        obj = this.getObject("license", node, false, location, result);
        License license = this.getLicense(obj, String.format("%s.%s'", location, "license"), result);
        if (obj != null) {
            info.setLicense(license);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("version", node, true, location, result)))) {
            info.setVersion(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            info.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (INFO_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return info;
    }

    public License getLicense(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        LicenseImpl license = new LicenseImpl();
        String value = this.getString("name", node, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            license.setName(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("url", node, false, location, result)))) {
            license.setUrl(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            license.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (LICENSE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return license;
    }

    public Contact getContact(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        ContactImpl contact = new ContactImpl();
        String value = this.getString("name", node, false, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            contact.setName(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("url", node, false, location, result)))) {
            contact.setUrl(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("email", node, false, location, result)))) {
            contact.setEmail(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            contact.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (CONTACT_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return contact;
    }

    public Content getContent(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        ContentImpl content = new ContentImpl();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            MediaType mediaType = this.getMediaType((ObjectNode)node.get(key), location, result);
            if (mediaType == null) continue;
            content.addMediaType(key, mediaType);
        }
        return content;
    }

    public MediaType getMediaType(ObjectNode contentNode, String location, ParseResult result) {
        Object example;
        ObjectNode examplesObject;
        Map<String, Object> extensions;
        ObjectNode encodingObject;
        if (contentNode == null) {
            return null;
        }
        MediaTypeImpl mediaType = new MediaTypeImpl();
        ObjectNode schemaObject = this.getObject("schema", contentNode, false, location, result);
        if (schemaObject != null) {
            mediaType.setSchema(this.getSchema(schemaObject, String.format("%s.%s'", location, "schema"), result));
        }
        if ((encodingObject = this.getObject("encoding", contentNode, false, location, result)) != null) {
            mediaType.setEncoding(this.getEncodingMap(encodingObject, String.format("%s.%s'", location, "encoding"), result));
        }
        if ((extensions = this.getExtensions(contentNode)) != null && extensions.size() > 0) {
            mediaType.setExtensions(extensions);
        }
        if ((examplesObject = this.getObject("examples", contentNode, false, location, result)) != null) {
            mediaType.setExamples(this.getExamples(examplesObject, String.format("%s.%s'", location, "examples"), result));
        }
        if ((example = this.getAnyExample("example", contentNode, location, result)) != null) {
            mediaType.setExample(example);
        }
        Set<String> keys = this.getKeys(contentNode);
        for (String key : keys) {
            if (MEDIATYPE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, contentNode.get(key));
        }
        return mediaType;
    }

    public Map<String, Encoding> getEncodingMap(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, Encoding> encodings = new LinkedHashMap<String, Encoding>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            Encoding encoding = this.getEncoding((ObjectNode)node.get(key), location, result);
            if (encoding == null) continue;
            encodings.put(key, encoding);
        }
        return encodings;
    }

    public Encoding getEncoding(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode headersObject;
        Boolean allowReserved;
        if (node == null) {
            return null;
        }
        EncodingImpl encoding = new EncodingImpl();
        String value = this.getString("contentType", node, true, location, result);
        encoding.setContentType(value);
        value = this.getString("style", node, false, location, result);
        if (StringUtils.isBlank((CharSequence)value)) {
            encoding.setStyle(Encoding.Style.FORM);
        } else if (value.equals(Encoding.Style.FORM.toString())) {
            encoding.setStyle(Encoding.Style.FORM);
        } else if (value.equals(Encoding.Style.DEEP_OBJECT.toString())) {
            encoding.setStyle(Encoding.Style.DEEP_OBJECT);
        } else if (value.equals(Encoding.Style.PIPE_DELIMITED.toString())) {
            encoding.setStyle(Encoding.Style.PIPE_DELIMITED);
        } else if (value.equals(Encoding.Style.SPACE_DELIMITED.toString())) {
            encoding.setStyle(Encoding.Style.SPACE_DELIMITED);
        } else {
            result.invalidType(location, "style", "string", (JsonNode)node);
        }
        Boolean explode = this.getBoolean("explode", node, false, location, result);
        if (explode != null) {
            encoding.setExplode(explode);
        }
        if ((allowReserved = this.getBoolean("allowReserved", node, false, location, result)) != null) {
            encoding.setAllowReserved(allowReserved);
        }
        if ((headersObject = this.getObject("headers", node, false, location, result)) != null) {
            encoding.setHeaders(this.getHeaders(headersObject, location, result));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            encoding.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (ENCODING_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return encoding;
    }

    public Map<String, Link> getLinks(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        Set<String> linkKeys = this.getKeys(obj);
        for (String linkName : linkKeys) {
            JsonNode linkValue = obj.get(linkName);
            if (!linkValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, linkName, "object", linkValue);
                continue;
            }
            ObjectNode link = (ObjectNode)linkValue;
            Link linkObj = this.getLink(link, String.format("%s.%s'", location, linkName), result);
            if (linkObj == null) continue;
            links.put(linkName, linkObj);
        }
        return links;
    }

    public Link getLink(ObjectNode linkNode, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode serverObject;
        ObjectNode parametersObject;
        if (linkNode == null) {
            return null;
        }
        LinkImpl link = new LinkImpl();
        JsonNode ref = linkNode.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                link.setRef(ref.asText());
                return (Link)link.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)linkNode);
            return null;
        }
        String value = this.getString("operationRef", linkNode, false, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            link.setOperationRef(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("operationId", linkNode, false, location, result)))) {
            link.setOperationId(value);
        }
        if ((parametersObject = this.getObject("parameters", linkNode, false, location, result)) != null) {
            link.setParameters(this.getLinkParameters(parametersObject, location, result));
        }
        if ((serverObject = this.getObject("server", linkNode, false, location, result)) != null) {
            link.setServer(this.getServer(serverObject, location, result));
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", linkNode, false, location, result)))) {
            link.setDescription(value);
        }
        if ((extensions = this.getExtensions(linkNode)) != null && extensions.size() > 0) {
            link.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(linkNode);
        for (String key : keys) {
            if (LINK_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, linkNode.get(key));
        }
        return link;
    }

    private Map<String, Object> getLinkParameters(ObjectNode parametersObject, String location, ParseResult result) {
        LinkedHashMap<String, Object> linkParameters = new LinkedHashMap<String, Object>();
        Set<String> keys = this.getKeys(parametersObject);
        for (String name : keys) {
            JsonNode value = parametersObject.get(name);
            linkParameters.put(name, value.asText());
        }
        return linkParameters;
    }

    public Map<String, Callback> getCallbacks(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            Callback callback = this.getCallback((ObjectNode)node.get(key), location, result);
            if (callback == null) continue;
            callbacks.put(key, callback);
        }
        return callbacks;
    }

    public Callback getCallback(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        CallbackImpl callback = new CallbackImpl();
        Set<String> keys = this.getKeys(node);
        for (String name : keys) {
            JsonNode value = node.get(name);
            if (node == null) continue;
            JsonNode ref = node.get("$ref");
            if (ref != null) {
                if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                    PathItemImpl pathItem = new PathItemImpl();
                    return callback.addPathItem(name, (PathItem)pathItem.ref(ref.asText()));
                }
                result.invalidType(location, "$ref", "string", (JsonNode)node);
                return null;
            }
            callback.addPathItem(name, this.getPathItem((ObjectNode)value, location, result));
            Map<String, Object> extensions = this.getExtensions(node);
            if (extensions == null || extensions.size() <= 0) continue;
            callback.setExtensions(extensions);
        }
        return callback;
    }

    public XML getXml(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        Boolean wrapped;
        Boolean attribute;
        if (node == null) {
            return null;
        }
        XMLImpl xml = new XMLImpl();
        String value = this.getString("name", node, false, String.format("%s.%s'", location, "name"), result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            xml.setName(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("namespace", node, false, String.format("%s.%s'", location, "namespace"), result)))) {
            xml.setNamespace(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("prefix", node, false, String.format("%s.%s'", location, "prefix"), result)))) {
            xml.setPrefix(value);
        }
        if ((attribute = this.getBoolean("attribute", node, false, location, result)) != null) {
            xml.setAttribute(attribute);
        }
        if ((wrapped = this.getBoolean("wrapped", node, false, location, result)) != null) {
            xml.setWrapped(wrapped);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            xml.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (XML_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return xml;
    }

    public ArrayNode getArray(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        JsonNode value = node.get(key);
        ArrayNode arrayNode = null;
        if (value == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!value.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            result.invalidType(location, key, "array", value);
        } else {
            arrayNode = (ArrayNode)value;
        }
        return arrayNode;
    }

    public Boolean getBoolean(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        Boolean value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
            value = v.asBoolean();
        } else if (v.getNodeType().equals((Object)JsonNodeType.STRING)) {
            String stringValue = v.textValue();
            return Boolean.parseBoolean(stringValue);
        }
        return value;
    }

    public BigDecimal getBigDecimal(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        BigDecimal value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            value = new BigDecimal(v.asText());
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "double", (JsonNode)node);
        }
        return value;
    }

    public Integer getInteger(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        Integer value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            value = v.intValue();
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "integer", (JsonNode)node);
        }
        return value;
    }

    public Map<String, Parameter> getParameters(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        Set<String> parameterKeys = this.getKeys(obj);
        for (String parameterName : parameterKeys) {
            Parameter parameter;
            ObjectNode parameterObj;
            JsonNode parameterValue = obj.get(parameterName);
            if (!parameterValue.getNodeType().equals((Object)JsonNodeType.OBJECT) || (parameterObj = (ObjectNode)parameterValue) == null || (parameter = this.getParameter(parameterObj, String.format("%s.%s'", location, parameterName), result)) == null) continue;
            parameters.put(parameterName, parameter);
        }
        return parameters;
    }

    public List<Parameter> getParameterList(ArrayNode obj, String location, ParseResult result) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (obj == null) {
            return parameters;
        }
        for (JsonNode item : obj) {
            Parameter parameter;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (parameter = this.getParameter((ObjectNode)item, location, result)) == null) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public Parameter getParameter(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode contentNode;
        Object example;
        ObjectNode examplesObject;
        Boolean allowEmptyValue;
        Boolean required;
        if (obj == null) {
            return null;
        }
        ParameterImpl parameter = null;
        JsonNode ref = obj.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                parameter = new ParameterImpl();
                parameter.setRef(ref.asText());
                return (Parameter)parameter.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)obj);
            return null;
        }
        String l = null;
        JsonNode ln = obj.get("name");
        l = ln != null ? ln.asText() : "['unknown']";
        String value = this.getString("in", obj, true, location = location + ".[" + l + "]", result);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (QUERY_PARAMETER.equals(value)) {
            parameter = new ParameterImpl().in(Parameter.In.QUERY);
        } else if (HEADER_PARAMETER.equals(value)) {
            parameter = new ParameterImpl().in(Parameter.In.HEADER);
        } else if (PATH_PARAMETER.equals(value)) {
            parameter = new ParameterImpl().in(Parameter.In.PATH);
        } else if (COOKIE_PARAMETER.equals(value)) {
            parameter = new ParameterImpl().in(Parameter.In.COOKIE);
        }
        if (parameter == null) {
            result.invalidType(location, "in", "string", (JsonNode)obj);
            return null;
        }
        value = this.getString("name", obj, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            parameter.setName(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", obj, false, location, result)))) {
            parameter.setDescription(value);
        }
        if ((required = this.getBoolean("required", obj, false, location, result)) != null) {
            parameter.setRequired(required);
        } else {
            parameter.setRequired(Boolean.valueOf(false));
        }
        Boolean deprecated = this.getBoolean("deprecated", obj, false, location, result);
        if (deprecated != null) {
            parameter.setDeprecated(deprecated);
        }
        if ((allowEmptyValue = this.getBoolean("allowEmptyValue", obj, false, location, result)) != null) {
            parameter.setAllowEmptyValue(allowEmptyValue);
        }
        value = this.getString("style", obj, false, location, result);
        this.setStyle(value, (Parameter)parameter, location, obj, result);
        Boolean explode = this.getBoolean("explode", obj, false, location, result);
        if (explode != null) {
            parameter.setExplode(explode);
        } else if (parameter.getStyle() != null && parameter.getStyle().equals((Object)Parameter.Style.FORM)) {
            parameter.setExplode(Boolean.TRUE);
        } else {
            parameter.setExplode(Boolean.FALSE);
        }
        ObjectNode parameterObject = this.getObject("schema", obj, false, location, result);
        if (parameterObject != null) {
            parameter.setSchema(this.getSchema(parameterObject, String.format("%s.%s'", location, "schemas"), result));
        }
        if ((examplesObject = this.getObject("examples", obj, false, location, result)) != null) {
            parameter.setExamples(this.getExamples(examplesObject, String.format("%s.%s'", location, "examples"), result));
        }
        if ((example = this.getAnyExample("example", obj, location, result)) != null) {
            parameter.setExample(example);
        }
        if ((contentNode = this.getObject("content", obj, false, location, result)) != null) {
            parameter.setContent(this.getContent(contentNode, String.format("%s.%s'", location, "content"), result));
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            parameter.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (PARAMETER_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return parameter;
    }

    public Map<String, Header> getHeaders(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Header> headers = new LinkedHashMap<String, Header>();
        Set<String> headerKeys = this.getKeys(obj);
        for (String headerName : headerKeys) {
            JsonNode headerValue = obj.get(headerName);
            if (!headerValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, headerName, "object", headerValue);
                continue;
            }
            ObjectNode header = (ObjectNode)headerValue;
            Header headerObj = this.getHeader(header, String.format("%s.%s'", location, headerName), result);
            if (headerObj == null) continue;
            headers.put(headerName, headerObj);
        }
        return headers;
    }

    public Header getHeader(ObjectNode headerNode, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode contentNode;
        Object example;
        ObjectNode examplesObject;
        Boolean explode;
        Boolean allowEmptyValue;
        Boolean deprecated;
        Boolean required;
        if (headerNode == null) {
            return null;
        }
        HeaderImpl header = new HeaderImpl();
        JsonNode ref = headerNode.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                header.setRef(ref.asText());
                return (Header)header.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)headerNode);
            return null;
        }
        String value = this.getString("description", headerNode, false, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            header.setDescription(value);
        }
        if ((required = this.getBoolean("required", headerNode, false, location, result)) != null) {
            header.setRequired(required);
        }
        if ((deprecated = this.getBoolean("deprecated", headerNode, false, location, result)) != null) {
            header.setDeprecated(deprecated);
        }
        if ((allowEmptyValue = this.getBoolean("allowEmptyValue", headerNode, false, location, result)) != null) {
            header.setAllowEmptyValue(allowEmptyValue);
        }
        if ((explode = this.getBoolean("explode", headerNode, false, location, result)) != null) {
            header.setExplode(explode);
        } else {
            header.setExplode(Boolean.FALSE);
        }
        header.setStyle(Header.Style.SIMPLE);
        ObjectNode headerObject = this.getObject("schema", headerNode, false, location, result);
        if (headerObject != null) {
            header.setSchema(this.getSchema(headerObject, location, result));
        }
        if ((examplesObject = this.getObject("examples", headerNode, false, location, result)) != null) {
            header.setExamples(this.getExamples(examplesObject, location, result));
        }
        if ((example = this.getAnyExample("example", headerNode, location, result)) != null) {
            header.setExample(example);
        }
        if ((contentNode = this.getObject("content", headerNode, false, location, result)) != null) {
            header.setContent(this.getContent(contentNode, String.format("%s.%s'", location, "content"), result));
        }
        if ((extensions = this.getExtensions(headerNode)) != null && extensions.size() > 0) {
            header.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(headerNode);
        for (String key : oAuthFlowKeys) {
            if (HEADER_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, headerNode.get(key));
        }
        return header;
    }

    public Object getAnyExample(String nodeKey, ObjectNode node, String location, ParseResult result) {
        JsonNode example = node.get(nodeKey);
        if (example != null) {
            ArrayNode arrayValue;
            String value;
            if (example.getNodeType().equals((Object)JsonNodeType.STRING) && StringUtils.isNotBlank((CharSequence)(value = this.getString(nodeKey, node, false, location, result)))) {
                return value;
            }
            if (example.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
                Integer integerExample = this.getInteger(nodeKey, node, false, location, result);
                if (integerExample != null) {
                    return integerExample;
                }
                BigDecimal bigDecimalExample = this.getBigDecimal(nodeKey, node, false, location, result);
                if (bigDecimalExample != null) {
                    return bigDecimalExample;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode objectValue = this.getObject(nodeKey, node, false, location, result);
                if (objectValue != null) {
                    return objectValue;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.ARRAY) && (arrayValue = this.getArray(nodeKey, node, false, location, result)) != null) {
                return arrayValue;
            }
        }
        return null;
    }

    public Map<String, SecurityScheme> getSecuritySchemes(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, SecurityScheme> securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        Set<String> securitySchemeKeys = this.getKeys(obj);
        for (String securitySchemeName : securitySchemeKeys) {
            JsonNode securitySchemeValue = obj.get(securitySchemeName);
            if (!securitySchemeValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, securitySchemeName, "object", securitySchemeValue);
                continue;
            }
            ObjectNode securityScheme = (ObjectNode)securitySchemeValue;
            SecurityScheme securitySchemeObj = this.getSecurityScheme(securityScheme, String.format("%s.%s'", location, securitySchemeName), result);
            if (securityScheme == null) continue;
            securitySchemes.put(securitySchemeName, securitySchemeObj);
        }
        return securitySchemes;
    }

    public SecurityScheme getSecurityScheme(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode flowsObject;
        if (node == null) {
            return null;
        }
        SecuritySchemeImpl securityScheme = new SecuritySchemeImpl();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                securityScheme.setRef(ref.asText());
                return (SecurityScheme)securityScheme.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        boolean openIdConnectRequired = false;
        boolean flowsRequired = false;
        boolean schemeRequired = false;
        boolean inRequired = false;
        boolean nameRequired = false;
        boolean bearerFormatRequired = false;
        boolean descriptionRequired = false;
        String value = this.getString("type", node, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (SecurityScheme.Type.APIKEY.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.APIKEY);
                inRequired = true;
                nameRequired = true;
            } else if (SecurityScheme.Type.HTTP.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.HTTP);
                schemeRequired = true;
            } else if (SecurityScheme.Type.OAUTH2.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.OAUTH2);
                flowsRequired = true;
            } else if (SecurityScheme.Type.OPENIDCONNECT.toString().equals(value)) {
                securityScheme.setType(SecurityScheme.Type.OPENIDCONNECT);
                openIdConnectRequired = true;
            } else {
                result.invalidType(location + ".type", "type", "http|apiKey|oauth2|openIdConnect ", (JsonNode)node);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", node, descriptionRequired, location, result)))) {
            securityScheme.setDescription(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("name", node, nameRequired, location, result)))) {
            securityScheme.setName(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("in", node, inRequired, location, result)))) {
            if (QUERY_PARAMETER.equals(value)) {
                securityScheme.setIn(SecurityScheme.In.QUERY);
            } else if (HEADER_PARAMETER.equals(value)) {
                securityScheme.setIn(SecurityScheme.In.HEADER);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("scheme", node, schemeRequired, location, result)))) {
            securityScheme.setScheme(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("bearerFormat", node, bearerFormatRequired, location, result)))) {
            securityScheme.setBearerFormat(value);
        }
        if ((flowsObject = this.getObject("flows", node, flowsRequired, location, result)) != null) {
            securityScheme.setFlows(this.getOAuthFlows(flowsObject, location, result));
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("openIdConnectUrl", node, openIdConnectRequired, location, result)))) {
            securityScheme.setOpenIdConnectUrl(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            securityScheme.setExtensions(extensions);
        }
        Set<String> securitySchemeKeys = this.getKeys(node);
        for (String key : securitySchemeKeys) {
            if (SECURITY_SCHEME_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return securityScheme;
    }

    public OAuthFlows getOAuthFlows(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        OAuthFlowsImpl oAuthFlows = new OAuthFlowsImpl();
        ObjectNode objectNode = this.getObject("implicit", node, false, location, result);
        if (objectNode != null) {
            oAuthFlows.setImplicit(this.getOAuthFlow("implicit", objectNode, location, result));
        }
        if ((objectNode = this.getObject("password", node, false, location, result)) != null) {
            oAuthFlows.setPassword(this.getOAuthFlow("password", objectNode, location, result));
        }
        if ((objectNode = this.getObject("clientCredentials", node, false, location, result)) != null) {
            oAuthFlows.setClientCredentials(this.getOAuthFlow("clientCredentials", objectNode, location, result));
        }
        if ((objectNode = this.getObject("authorizationCode", node, false, location, result)) != null) {
            oAuthFlows.setAuthorizationCode(this.getOAuthFlow("authorizationCode", objectNode, location, result));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            oAuthFlows.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(node);
        for (String key : oAuthFlowKeys) {
            if (OAUTHFLOWS_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return oAuthFlows;
    }

    public OAuthFlow getOAuthFlow(String oAuthFlowType, ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        OAuthFlowImpl oAuthFlow = new OAuthFlowImpl();
        boolean refreshUrlRequired = false;
        boolean tokenUrlRequired = false;
        boolean authorizationUrlRequired = false;
        boolean scopesRequired = true;
        switch (oAuthFlowType) {
            case "implicit": {
                authorizationUrlRequired = true;
                break;
            }
            case "password": {
                tokenUrlRequired = true;
                break;
            }
            case "clientCredentials": {
                tokenUrlRequired = true;
                break;
            }
            case "authorizationCode": {
                tokenUrlRequired = true;
                authorizationUrlRequired = true;
            }
        }
        String value = this.getString("authorizationUrl", node, authorizationUrlRequired, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            oAuthFlow.setAuthorizationUrl(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("tokenUrl", node, tokenUrlRequired, location, result)))) {
            oAuthFlow.setTokenUrl(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("refreshUrl", node, refreshUrlRequired, location, result)))) {
            oAuthFlow.setRefreshUrl(value);
        }
        ObjectNode scopesObject = this.getObject("scopes", node, scopesRequired, location, result);
        ScopesImpl scope = new ScopesImpl();
        Set<String> keys = this.getKeys(scopesObject);
        for (String name : keys) {
            JsonNode scopeValue = scopesObject.get(name);
            if (scopesObject == null) continue;
            scope.addScope(name, scopeValue.asText());
            oAuthFlow.setScopes((Scopes)scope);
        }
        Map<String, Object> extensions = this.getExtensions(node);
        if (extensions != null && extensions.size() > 0) {
            oAuthFlow.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(node);
        for (String key : oAuthFlowKeys) {
            if (OAUTHFLOW_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return oAuthFlow;
    }

    public Map<String, Schema> getSchemas(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Schema> schemas = new LinkedHashMap<String, Schema>();
        Set<String> schemaKeys = this.getKeys(obj);
        for (String schemaName : schemaKeys) {
            JsonNode schemaValue = obj.get(schemaName);
            if (!schemaValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, schemaName, "object", schemaValue);
                continue;
            }
            ObjectNode schema = (ObjectNode)schemaValue;
            Schema schemaObj = this.getSchema(schema, String.format("%s.%s'", location, schemaName), result);
            if (schemaObj == null) continue;
            schemas.put(schemaName, schemaObj);
        }
        return schemas;
    }

    public Discriminator getDiscriminator(ObjectNode node, String location, ParseResult result) {
        ObjectNode mappingNode;
        DiscriminatorImpl discriminator = new DiscriminatorImpl();
        String value = this.getString("propertyName", node, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            discriminator.setPropertyName(value);
        }
        if ((mappingNode = this.getObject("mapping", node, false, location, result)) != null) {
            LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
            Set<String> keys = this.getKeys(mappingNode);
            for (String key : keys) {
                mapping.put(key, mappingNode.get(key).asText());
            }
            discriminator.setMapping(mapping);
        }
        return discriminator;
    }

    public Schema getSchema(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        Object example;
        ExternalDocumentation docs;
        ObjectNode externalDocs;
        XML xml;
        ObjectNode xmlNode;
        Schema additionalProperties;
        ObjectNode additionalPropertiesObj;
        Schema not;
        ObjectNode notObj;
        ArrayNode enumArray;
        ArrayNode required;
        String pattern;
        Integer integer;
        Boolean bool;
        BigDecimal bigDecimal;
        ObjectNode discriminatorNode;
        if (node == null) {
            return null;
        }
        Schema schema = null;
        ArrayNode oneOfArray = this.getArray("oneOf", node, false, location, result);
        ArrayNode allOfArray = this.getArray("allOf", node, false, location, result);
        ArrayNode anyOfArray = this.getArray("anyOf", node, false, location, result);
        ObjectNode itemsNode = this.getObject("items", node, false, location, result);
        if (allOfArray != null) {
            SchemaImpl allOfList = new SchemaImpl();
            for (JsonNode n : allOfArray) {
                if (!n.isObject()) continue;
                schema = this.getSchema((ObjectNode)n, location, result);
                allOfList.addAllOf(schema);
            }
            schema = allOfList;
        } else if (anyOfArray != null) {
            SchemaImpl anyOfList = new SchemaImpl();
            for (JsonNode n : anyOfArray) {
                if (!n.isObject()) continue;
                schema = this.getSchema((ObjectNode)n, location, result);
                anyOfList.addAnyOf(schema);
            }
            schema = anyOfList;
        } else if (oneOfArray != null) {
            SchemaImpl oneOfList = new SchemaImpl();
            for (JsonNode n : oneOfArray) {
                if (!n.isObject()) continue;
                schema = this.getSchema((ObjectNode)n, location, result);
                oneOfList.addOneOf(schema);
            }
            schema = oneOfList;
        } else if (itemsNode != null) {
            Schema items = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            if (itemsNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                items.setItems(this.getSchema(itemsNode, location, result));
            } else if (itemsNode.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                for (JsonNode n : itemsNode) {
                    if (!n.isValueNode()) continue;
                    items.setItems(this.getSchema(itemsNode, location, result));
                }
            }
            schema = items;
        } else {
            schema = SchemaTypeUtil.createSchemaByType(node);
        }
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                schema.setRef(ref.asText());
                return (Schema)schema.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String value = this.getString("title", node, false, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            schema.setTitle(value);
        }
        if ((discriminatorNode = this.getObject("discriminator", node, false, location, result)) != null) {
            schema.setDiscriminator(this.getDiscriminator(discriminatorNode, location, result));
        }
        if ((bigDecimal = this.getBigDecimal("multipleOf", node, false, location, result)) != null) {
            schema.setMultipleOf(bigDecimal);
        }
        if ((bigDecimal = this.getBigDecimal("maximum", node, false, location, result)) != null) {
            schema.setMaximum(bigDecimal);
        }
        if ((bool = this.getBoolean("exclusiveMaximum", node, false, location, result)) != null) {
            schema.setExclusiveMaximum(bool);
        }
        if ((bigDecimal = this.getBigDecimal("minimum", node, false, location, result)) != null) {
            schema.setMinimum(bigDecimal);
        }
        if ((bool = this.getBoolean("exclusiveMinimum", node, false, location, result)) != null) {
            schema.setExclusiveMinimum(bool);
        }
        if ((integer = this.getInteger("minLength", node, false, location, result)) != null) {
            schema.setMinLength(integer);
        }
        if ((integer = this.getInteger("maxLength", node, false, location, result)) != null) {
            schema.setMaxLength(integer);
        }
        if (StringUtils.isNotBlank((CharSequence)(pattern = this.getString("pattern", node, false, location, result)))) {
            schema.setPattern(pattern);
        }
        if ((integer = this.getInteger("maxItems", node, false, location, result)) != null) {
            schema.setMaxItems(integer);
        }
        if ((integer = this.getInteger("minItems", node, false, location, result)) != null) {
            schema.setMinItems(integer);
        }
        if ((bool = this.getBoolean("uniqueItems", node, false, location, result)) != null) {
            schema.setUniqueItems(bool);
        }
        if ((integer = this.getInteger("maxProperties", node, false, location, result)) != null) {
            schema.setMaxProperties(integer);
        }
        if ((integer = this.getInteger("minProperties", node, false, location, result)) != null) {
            schema.setMinProperties(integer);
        }
        if ((required = this.getArray("required", node, false, location, result)) != null) {
            ArrayList<String> requiredList = new ArrayList<String>();
            for (JsonNode n : required) {
                if (n.getNodeType().equals((Object)JsonNodeType.STRING)) {
                    requiredList.add(((TextNode)n).textValue());
                    continue;
                }
                result.invalidType(location, "required", "string", n);
            }
            if (requiredList.size() > 0) {
                schema.setRequired(requiredList);
            }
        }
        if ((enumArray = this.getArray("enum", node, false, location, result)) != null) {
            for (JsonNode n : enumArray) {
                if (n.isNumber()) {
                    schema.addEnumeration((Object)String.valueOf(n.numberValue()));
                    continue;
                }
                if (n.isValueNode()) {
                    schema.addEnumeration((Object)n.asText());
                    continue;
                }
                result.invalidType(location, "enum", "value", n);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("type", node, false, location, result)))) {
            schema.setType(Schema.SchemaType.valueOf((String)value.toUpperCase()));
        }
        if ((notObj = this.getObject("not", node, false, location, result)) != null && (not = this.getSchema(notObj, location, result)) != null) {
            schema.setNot(not);
        }
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        ObjectNode propertiesObj = this.getObject("properties", node, false, location, result);
        Schema property = null;
        Set<String> keys = this.getKeys(propertiesObj);
        for (String name : keys) {
            JsonNode propertyValue = propertiesObj.get(name);
            if (!propertyValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, "properties", "object", propertyValue);
                continue;
            }
            if (propertiesObj == null || (property = this.getSchema((ObjectNode)propertyValue, location, result)) == null) continue;
            properties.put(name, property);
        }
        if (propertiesObj != null) {
            schema.setProperties(properties);
        }
        if ((additionalPropertiesObj = this.getObject("additionalProperties", node, false, location, result)) != null && (additionalProperties = this.getSchema(additionalPropertiesObj, location, result)) != null) {
            schema.setAdditionalProperties(additionalProperties);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", node, false, location, result)))) {
            schema.setDescription(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("format", node, false, location, result)))) {
            schema.setFormat(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("default", node, false, location, result)))) {
            schema.setDefaultValue((Object)value);
        }
        if ((bool = this.getBoolean("nullable", node, false, location, result)) != null) {
            schema.setNullable(bool);
        }
        if ((bool = this.getBoolean("readOnly", node, false, location, result)) != null) {
            schema.setReadOnly(bool);
        }
        if ((bool = this.getBoolean("writeOnly", node, false, location, result)) != null) {
            schema.setWriteOnly(bool);
        }
        if ((xmlNode = this.getObject("xml", node, false, location, result)) != null && (xml = this.getXml(xmlNode, location, result)) != null) {
            schema.setXml(xml);
        }
        if ((externalDocs = this.getObject("externalDocs", node, false, location, result)) != null && (docs = this.getExternalDocs(externalDocs, location, result)) != null) {
            schema.setExternalDocs(docs);
        }
        if ((example = this.getAnyExample("example", node, location, result)) != null) {
            schema.setExample(example);
        }
        if ((bool = this.getBoolean("deprecated", node, false, location, result)) != null) {
            schema.setDeprecated(bool);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            schema.setExtensions(extensions);
        }
        Set<String> schemaKeys = this.getKeys(node);
        for (String key : schemaKeys) {
            if (SCHEMA_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return schema;
    }

    public Map<String, Example> getExamples(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Example> examples = new LinkedHashMap<String, Example>();
        Set<String> exampleKeys = this.getKeys(obj);
        for (String exampleName : exampleKeys) {
            Example exampleObj;
            JsonNode exampleValue = obj.get(exampleName);
            if (!exampleValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, exampleName, "object", exampleValue);
                continue;
            }
            ObjectNode example = (ObjectNode)exampleValue;
            if (example == null || (exampleObj = this.getExample(example, String.format("%s.%s'", location, exampleName), result)) == null) continue;
            examples.put(exampleName, exampleObj);
        }
        return examples;
    }

    public List<Example> getExampleList(ArrayNode obj, String location, ParseResult result) {
        ArrayList<Example> examples = new ArrayList<Example>();
        if (obj == null) {
            return examples;
        }
        for (JsonNode item : obj) {
            Example example;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (example = this.getExample((ObjectNode)item, location, result)) == null) continue;
            examples.add(example);
        }
        return examples;
    }

    public Example getExample(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        Object sample;
        if (node == null) {
            return null;
        }
        ExampleImpl example = new ExampleImpl();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                example.setRef(ref.asText());
                return (Example)example.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String value = this.getString("summary", node, false, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            example.setSummary(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", node, false, location, result)))) {
            example.setDescription(value);
        }
        if ((sample = this.getAnyExample("value", node, location, result)) != null) {
            example.setValue(sample);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("externalValue", node, false, location, result)))) {
            example.setExternalValue(value);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            example.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (EXAMPLE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return example;
    }

    public void setStyle(String value, Parameter parameter, String location, ObjectNode obj, ParseResult result) {
        if (StringUtils.isBlank((CharSequence)value)) {
            if (QUERY_PARAMETER.equals(parameter.getIn()) || COOKIE_PARAMETER.equals(parameter.getIn())) {
                parameter.setStyle(Parameter.Style.FORM);
            } else if (PATH_PARAMETER.equals(parameter.getIn()) || HEADER_PARAMETER.equals(parameter.getIn())) {
                parameter.setStyle(Parameter.Style.SIMPLE);
            }
        } else if (value.equals(Parameter.Style.FORM.toString())) {
            parameter.setStyle(Parameter.Style.FORM);
        } else if (value.equals(Parameter.Style.DEEPOBJECT.toString())) {
            parameter.setStyle(Parameter.Style.DEEPOBJECT);
        } else if (value.equals(Parameter.Style.LABEL.toString())) {
            parameter.setStyle(Parameter.Style.LABEL);
        } else if (value.equals(Parameter.Style.MATRIX.toString())) {
            parameter.setStyle(Parameter.Style.MATRIX);
        } else if (value.equals(Parameter.Style.PIPEDELIMITED.toString())) {
            parameter.setStyle(Parameter.Style.PIPEDELIMITED);
        } else if (value.equals(Parameter.Style.SIMPLE.toString())) {
            parameter.setStyle(Parameter.Style.SIMPLE);
        } else if (value.equals(Parameter.Style.SPACEDELIMITED.toString())) {
            parameter.setStyle(Parameter.Style.SPACEDELIMITED);
        } else {
            result.invalidType(location, "style", "string", (JsonNode)obj);
        }
    }

    public APIResponses getResponses(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        APIResponsesImpl apiResponses = new APIResponsesImpl();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            APIResponse response;
            ObjectNode obj = this.getObject(key, node, false, String.format("%s.%s'", location, "responses"), result);
            if (obj == null || (response = this.getResponse(obj, String.format("%s.%s'", location, key), result)) == null) continue;
            apiResponses.put((Object)key, (Object)response);
        }
        return apiResponses;
    }

    public APIResponse getResponse(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode contentObject;
        Map<String, Link> links;
        ObjectNode linksObj;
        Map<String, Header> headers;
        ObjectNode headerObject;
        if (node == null) {
            return null;
        }
        APIResponseImpl apiResponse = new APIResponseImpl();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                apiResponse.setRef(ref.asText());
                return (APIResponse)apiResponse.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String value = this.getString("description", node, true, location, result);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            apiResponse.description(value);
        }
        if ((headerObject = this.getObject("headers", node, false, location, result)) != null && (headers = this.getHeaders(headerObject, location, result)) != null && headers.size() > 0) {
            apiResponse.setHeaders(headers);
        }
        if ((linksObj = this.getObject("links", node, false, location, result)) != null && (links = this.getLinks(linksObj, location, result)) != null && links.size() > 0) {
            apiResponse.setLinks(links);
        }
        if ((contentObject = this.getObject("content", node, false, location, result)) != null) {
            apiResponse.setContent(this.getContent(contentObject, String.format("%s.%s'", location, "content"), result));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            apiResponse.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (RESPONSE_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return apiResponse;
    }

    public List<String> getTagsStrings(ArrayNode nodes, String location, ParseResult result) {
        if (nodes == null) {
            return null;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (JsonNode node : nodes) {
            if (!node.getNodeType().equals((Object)JsonNodeType.STRING)) continue;
            tags.add(node.textValue());
        }
        return tags;
    }

    public Operation getOperation(ObjectNode obj, String location, ParseResult result) {
        Map<String, Object> extensions;
        Boolean deprecated;
        ObjectNode callbacksNode;
        Map<String, Callback> callbacks;
        ObjectNode responsesNode;
        APIResponses responses;
        ObjectNode requestObjectNode;
        ArrayNode parameters;
        ObjectNode externalDocs;
        ExternalDocumentation docs;
        String value;
        if (obj == null) {
            return null;
        }
        OperationImpl operation = new OperationImpl();
        ArrayNode array = this.getArray("tags", obj, false, location, result);
        List<String> tags = this.getTagsStrings(array, String.format("%s.%s'", location, "tags"), result);
        if (tags != null) {
            operation.setTags(tags);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("summary", obj, false, location, result)))) {
            operation.setSummary(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("description", obj, false, location, result)))) {
            operation.setDescription(value);
        }
        if ((docs = this.getExternalDocs(externalDocs = this.getObject("externalDocs", obj, false, location, result), String.format("%s.%s'", location, "externalDocs"), result)) != null) {
            operation.setExternalDocs(docs);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = this.getString("operationId", obj, false, location, result)))) {
            operation.operationId(value);
        }
        if ((parameters = this.getArray("parameters", obj, false, location, result)) != null) {
            operation.setParameters(this.getParameterList(parameters, String.format("%s.%s'", location, "parameters"), result));
        }
        if ((requestObjectNode = this.getObject("requestBody", obj, false, location, result)) != null) {
            operation.setRequestBody(this.getRequestBody(requestObjectNode, String.format("%s.%s'", location, "requestBody"), result));
        }
        if ((responses = this.getResponses(responsesNode = this.getObject("responses", obj, true, location, result), String.format("%s.%s'", location, "responses"), result)) != null) {
            operation.setResponses(responses);
        }
        if ((callbacks = this.getCallbacks(callbacksNode = this.getObject("callbacks", obj, false, location, result), String.format("%s.%s'", location, "callbacks"), result)) != null) {
            operation.setCallbacks(callbacks);
        }
        if ((deprecated = this.getBoolean("deprecated", obj, false, location, result)) != null) {
            operation.setDeprecated(deprecated);
        }
        if ((array = this.getArray("servers", obj, false, location, result)) != null && array.size() > 0) {
            operation.setServers(this.getServersList(array, String.format("%s.%s'", location, "servers"), result));
        }
        if ((array = this.getArray("security", obj, false, location, result)) != null) {
            operation.setSecurity(this.getSecurityRequirementsList(array, String.format("%s.%s'", location, "security"), result));
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            operation.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (OPERATION_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, obj.get(key));
        }
        return operation;
    }

    public List<SecurityRequirement> getSecurityRequirementsList(ArrayNode nodes, String location, ParseResult result) {
        if (nodes == null) {
            return null;
        }
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (JsonNode node : nodes) {
            if (!node.getNodeType().equals((Object)JsonNodeType.OBJECT)) continue;
            SecurityRequirementImpl securityRequirement = new SecurityRequirementImpl();
            Set<String> keys = this.getKeys((ObjectNode)node);
            for (String key : keys) {
                if (key == null) continue;
                JsonNode value = node.get(key);
                if (key == null || !JsonNodeType.ARRAY.equals((Object)value.getNodeType())) continue;
                ArrayNode arrayNode = (ArrayNode)value;
                List scopes = Stream.generate(arrayNode.elements()::next).map(n -> n.asText()).limit(arrayNode.size()).collect(Collectors.toList());
                securityRequirement.addScheme(key, scopes);
                if (securityRequirement.size() <= 0) continue;
                securityRequirements.add((SecurityRequirement)securityRequirement);
            }
        }
        return securityRequirements;
    }

    public Map<String, RequestBody> getRequestBodies(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, RequestBody> bodies = new LinkedHashMap<String, RequestBody>();
        Set<String> bodyKeys = this.getKeys(obj);
        for (String bodyName : bodyKeys) {
            JsonNode bodyValue = obj.get(bodyName);
            if (!bodyValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, bodyName, "object", bodyValue);
                continue;
            }
            ObjectNode bodyObj = (ObjectNode)bodyValue;
            RequestBody body = this.getRequestBody(bodyObj, String.format("%s.%s'", location, bodyName), result);
            if (body == null) continue;
            bodies.put(bodyName, body);
        }
        return bodies;
    }

    protected RequestBody getRequestBody(ObjectNode node, String location, ParseResult result) {
        Map<String, Object> extensions;
        ObjectNode contentNode;
        Boolean required;
        if (node == null) {
            return null;
        }
        RequestBodyImpl body = new RequestBodyImpl();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                body.setRef(ref.asText());
                return (RequestBody)body.ref(ref.asText());
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String description = this.getString("description", node, false, location, result);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            body.setDescription(description);
        }
        if ((required = this.getBoolean("required", node, false, location, result)) != null) {
            body.setRequired(required);
        }
        if ((contentNode = this.getObject("content", node, true, location, result)) != null) {
            body.setContent(this.getContent(contentNode, location + ".content", result));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            body.setExtensions(extensions);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (REQUEST_BODY_KEYS.contains(key) || key.startsWith("x-")) continue;
            result.extra(location, key, node.get(key));
        }
        return body;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OpenAPIDeserializer.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
        ROOT_KEYS = new LinkedHashSet<String>(Arrays.asList("openapi", "info", "servers", "paths", "components", "security", "tags", "externalDocs"));
        INFO_KEYS = new LinkedHashSet<String>(Arrays.asList("title", "description", "termsOfService", "contact", "license", "version"));
        CONTACT_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url", "email"));
        LICENSE_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url"));
        TAG_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "name", "externalDocs"));
        RESPONSE_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "headers", "content", "links"));
        SERVER_KEYS = new LinkedHashSet<String>(Arrays.asList("url", "description", "variables"));
        SERVER_VARIABLE_KEYS = new LinkedHashSet<String>(Arrays.asList("enum", "default", "description"));
        PATHITEM_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "get", "put", "post", "delete", "head", "patch", "options", "trace", "servers", "parameters"));
        OPERATION_KEYS = new LinkedHashSet<String>(Arrays.asList("tags", "summary", "description", "externalDocs", "operationId", "parameters", "requestBody", "responses", "callbacks", "deprecated", "security", "servers"));
        PARAMETER_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
        REQUEST_BODY_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "content", "required"));
        SECURITY_SCHEME_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "type", "name", "in", "description", "flows", "scheme", "bearerFormat", "openIdConnectUrl"));
        EXTERNAL_DOCS_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "url"));
        COMPONENTS_KEYS = new LinkedHashSet<String>(Arrays.asList("schemas", "responses", "parameters", "examples", "requestBodies", "headers", "securitySchemes", "links", "callbacks"));
        SCHEMA_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "title", "multipleOf", "maximum", "format", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "maxProperties", "minProperties", "required", "enum", "type", "allOf", "oneOf", "anyOf", "not", "items", "properties", "additionalProperties", "description", "format", "default", "nullable", "discriminator", "readOnly", "writeOnly", "xml", "externalDocs", "example", "deprecated"));
        EXAMPLE_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "value", "externalValue"));
        HEADER_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
        LINK_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "operationRef", "operationId", "parameters", "requestBody", "description", "server"));
        MEDIATYPE_KEYS = new LinkedHashSet<String>(Arrays.asList("schema", "example", "examples", "encoding"));
        XML_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "namespace", "prefix", "attribute", "wrapped"));
        OAUTHFLOW_KEYS = new LinkedHashSet<String>(Arrays.asList("authorizationUrl", "tokenUrl", "refreshUrl", "scopes"));
        OAUTHFLOWS_KEYS = new LinkedHashSet<String>(Arrays.asList("implicit", "password", "clientCredentials", "authorizationCode"));
        ENCODING_KEYS = new LinkedHashSet<String>(Arrays.asList("contentType", "headers", "style", "explode", "allowReserved"));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class Location {
        private final String location;
        private final String key;
        static final long serialVersionUID = -3483596759153965526L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location location1 = (Location)o;
            if (this.location != null ? !this.location.equals(location1.location) : location1.location != null) {
                return false;
            }
            return !(this.key == null ? location1.key != null : !this.key.equals(location1.key));
        }

        public int hashCode() {
            int result = this.location != null ? this.location.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public Location(String location, String key) {
            this.location = location;
            this.key = key;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Location.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class ParseResult {
        private boolean valid = true;
        private final Map<Location, JsonNode> extra = new LinkedHashMap<Location, JsonNode>();
        private final Map<Location, JsonNode> unsupported = new LinkedHashMap<Location, JsonNode>();
        private final Map<Location, String> invalidType = new LinkedHashMap<Location, String>();
        private final List<Location> missing = new ArrayList<Location>();
        static final long serialVersionUID = -995021187585867798L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void unsupported(String location, String key, JsonNode value) {
            this.unsupported.put(new Location(location, key), value);
        }

        public void extra(String location, String key, JsonNode value) {
            this.extra.put(new Location(location, key), value);
        }

        public void missing(String location, String key) {
            this.missing.add(new Location(location, key));
        }

        public void invalidType(String location, String key, String expectedType, JsonNode value) {
            this.invalidType.put(new Location(location, key), expectedType);
        }

        public void invalid() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<String> getMessages() {
            String message;
            String location;
            ArrayList<String> messages = new ArrayList<String>();
            for (Location l : this.extra.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unexpected";
                messages.add(message);
            }
            for (Location l : this.invalidType.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is not of type `" + this.invalidType.get(l) + "`";
                messages.add(message);
            }
            for (Location l : this.missing) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is missing";
                messages.add(message);
            }
            for (Location l : this.unsupported.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unsupported";
                messages.add(message);
            }
            return messages;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ParseResult.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
        }
    }
}

