/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kafka.security;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyLoginModule
implements LoginModule {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private Subject subject;
    private String username;
    private String encoded_password;
    private String decoded_password;
    static final long serialVersionUID = 8213089196406814571L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.username = (String)options.get(USERNAME);
        this.encoded_password = (String)options.get(PASSWORD);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean login() throws LoginException {
        if (this.encoded_password != null) {
            if (PasswordUtil.isEncrypted((String)this.encoded_password)) {
                try {
                    this.decoded_password = PasswordUtil.decode((String)this.encoded_password);
                }
                catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                    void e;
                    FFDCFilter.processException((Throwable)invalidPasswordDecodingException, (String)"com.ibm.ws.kafka.security.LibertyLoginModule", (String)"50", (Object)this, (Object[])new Object[0]);
                    throw new LoginException(e.getMessage());
                }
                catch (UnsupportedCryptoAlgorithmException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kafka.security.LibertyLoginModule", (String)"52", (Object)this, (Object[])new Object[0]);
                    throw new LoginException(e.getMessage());
                }
            } else {
                this.decoded_password = this.encoded_password;
            }
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.username != null) {
            this.subject.getPublicCredentials().add(this.username);
        }
        if (this.decoded_password != null) {
            this.subject.getPrivateCredentials().add(this.decoded_password);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.username != null) {
            this.subject.getPublicCredentials().remove(this.username);
        }
        if (this.decoded_password != null) {
            this.subject.getPrivateCredentials().remove(this.decoded_password);
        }
        this.username = null;
        this.encoded_password = null;
        this.decoded_password = null;
        this.subject = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return this.abort();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LibertyLoginModule.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    }
}

