/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaConnectorConstants;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaOutput;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaProducer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.eclipse.microprofile.reactive.messaging.spi.OutgoingConnectorFactory;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

@Connector(value="liberty-kafka")
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KafkaOutgoingConnector
implements OutgoingConnectorFactory {
    private static final TraceComponent tc = Tr.register(KafkaOutgoingConnector.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    @Inject
    private KafkaAdapterFactory kafkaAdapterFactory;
    private final List<KafkaOutput<?, ?>> kafkaOutputs = Collections.synchronizedList(new ArrayList());
    static final long serialVersionUID = 369199060001387231L;

    public SubscriberBuilder<Message<Object>, Void> getSubscriberBuilder(Config config) {
        Map producerConfig = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(k -> !KafkaConnectorConstants.NON_KAFKA_PROPS.contains(k)).collect(Collectors.toMap(Function.identity(), k -> config.getValue(k, String.class)));
        KafkaProducer kafkaProducer = this.kafkaAdapterFactory.newKafkaProducer(producerConfig);
        String channelName = (String)config.getValue("channel-name", String.class);
        String topic = config.getOptionalValue("topic", String.class).orElse(channelName);
        KafkaOutput kafkaOutput = new KafkaOutput(topic, kafkaProducer);
        this.kafkaOutputs.add(kafkaOutput);
        return ReactiveStreams.builder().to(kafkaOutput.getSubscriber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void shutdown() {
        List<KafkaOutput<?, ?>> list = this.kafkaOutputs;
        synchronized (list) {
            for (KafkaOutput<?, ?> kafkaOutput : this.kafkaOutputs) {
                kafkaOutput.shutdown(Duration.ZERO);
            }
        }
    }
}

