/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.Tracer;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingUtils {
    private static final TraceComponent tc = Tr.register(OpentracingUtils.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
    private static final String DEFAULT_SERVICE_NAME = "com.ibm.ws.opentracing.defaultServiceName";
    static final long serialVersionUID = 8989164367460949281L;

    @Trivial
    public static String getTracerText(Tracer tracer) {
        if (tracer == null) {
            return "null";
        }
        return tracer.getClass().getSimpleName() + "@" + Integer.toHexString(tracer.hashCode());
    }

    @Trivial
    public static String lookupAppName() {
        String appName;
        try {
            appName = (String)new InitialContext().lookup("java:app/AppName");
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.opentracing.OpentracingUtils", (String)"56", null, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"OPENTRACING_NO_APPNAME_FOUND_IN_JNDI", (Object[])new Object[0]);
            appName = DEFAULT_SERVICE_NAME;
        }
        return appName;
    }
}

