/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JandexLogger {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.jandex");
    static final long serialVersionUID = -8704463649714280652L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JandexLogger() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.anno.classsource.internal.JandexLogger", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.anno.classsource.internal.JandexLogger", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static boolean doLog() {
        return logger.isLoggable(Level.FINER);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void log(String sourceClass, String sourceMethod, String message) {
        logger.logp(Level.FINER, sourceClass, sourceMethod, message);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void log(String sourceClass, String sourceMethod, String message, Object ... parms) {
        logger.logp(Level.FINER, sourceClass, sourceMethod, message, parms);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getProperty(final String propertyName) {
        String string;
        Object token;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.ws.anno.classsource.internal.JandexLogger", "getProperty", new Object[]{propertyName});
            }
            token = ThreadIdentityManager.runAsServer();
            String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = 4866565096540664027L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return System.getProperty(propertyName);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            });
            string = string2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            string = string;
            logger.exiting("com.ibm.ws.anno.classsource.internal.JandexLogger", "getProperty", string);
        }
        return string;
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean getProperty(String sourceClass, String sourceMethod, String propertyName, boolean propertyDefaultValue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.anno.classsource.internal.JandexLogger", "getProperty", new Object[]{sourceClass, sourceMethod, propertyName, propertyDefaultValue});
        }
        String propertyText = JandexLogger.getProperty(propertyName);
        boolean propertyDefaulted = propertyText == null;
        boolean propertyValue = propertyDefaulted ? propertyDefaultValue : Boolean.parseBoolean(propertyText);
        if (JandexLogger.doLog()) {
            String debugText = "Property [ " + propertyName + " ] [ " + propertyValue + " ] (" + (propertyDefaulted ? "from default" : "from property") + ")";
            JandexLogger.log(sourceClass, sourceMethod, debugText);
        }
        boolean bl = propertyValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.anno.classsource.internal.JandexLogger", "getProperty", bl);
        }
        return bl;
    }
}

