/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.monitor.internal.ProbeManagerImpl;
import com.ibm.ws.monitor.internal.ReflectionHelper;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import com.ibm.ws.monitor.internal.bci.remap.AddVersionFieldClassAdapter;
import com.ibm.ws.monitor.internal.boot.templates.ClassAvailableProxy;
import com.ibm.ws.monitor.internal.boot.templates.ProbeProxy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MonitoringProxyActivator {
    public static final String BOOT_DELEGATED_PACKAGE = "com.ibm.ws.boot.delegated.monitoring";
    public static final String PROBE_PROXY_CLASS_NAME;
    public static final String PROBE_PROXY_CLASS_INTERNAL_NAME;
    public static final String CLASS_AVAILABLE_PROXY_CLASS_NAME;
    public static final String CLASS_AVAILABLE_PROXY_CLASS_INTERNAL_NAME;
    static final String TEMPLATE_CLASSES_PATH;
    static final String VERSION_FIELD_NAME = "BUNDLE_VERSION";
    static final String MONITORING_VERSION_MANIFEST_HEADER = "Liberty-Monitoring-Bundle-Version";
    final BundleContext bundleContext;
    final Instrumentation instrumentation;
    final ProbeManagerImpl probeManagerImpl;
    static final long serialVersionUID = -3032610278051102613L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    MonitoringProxyActivator(BundleContext bundleContext, ProbeManagerImpl probeManagerImpl, Instrumentation instrumentation) {
        this.bundleContext = bundleContext;
        this.probeManagerImpl = probeManagerImpl;
        this.instrumentation = instrumentation;
    }

    protected void activate() throws Exception {
        String runtimeVersion = this.getRuntimeClassVersion();
        if (runtimeVersion != null && !runtimeVersion.equals(this.getCurrentVersion())) {
            throw new IllegalStateException("Incompatible proxy code (version " + runtimeVersion + ")");
        }
        if (runtimeVersion == null) {
            JarFile proxyJar = this.getBootProxyJarIfCurrent();
            if (proxyJar == null) {
                proxyJar = this.createBootProxyJar();
            }
            this.instrumentation.appendToBootstrapClassLoaderSearch(proxyJar);
        }
        this.activateProbeProxyTarget();
        this.activateClassAvailableProxyTarget();
    }

    protected void deactivate() throws ComponentException {
        try {
            this.deactivateClassAvailableProxyTarget();
            this.deactivateProbeProxyTarget();
        }
        catch (Exception e) {
            throw new ComponentException((Throwable)e);
        }
    }

    @FFDCIgnore(value={Exception.class})
    String getRuntimeClassVersion() {
        String runtimeVersion = null;
        try {
            Class<?> clazz = Class.forName(PROBE_PROXY_CLASS_NAME);
            Field version = ReflectionHelper.getDeclaredField(clazz, VERSION_FIELD_NAME);
            runtimeVersion = (String)version.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return runtimeVersion;
    }

    JarFile getBootProxyJarIfCurrent() {
        File dataFile = this.bundleContext.getDataFile("boot-proxy.jar");
        if (!dataFile.exists()) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(dataFile);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String jarVersion = attrs.getValue(MONITORING_VERSION_MANIFEST_HEADER);
            if (!this.getCurrentVersion().equals(jarVersion)) {
                jarFile.close();
                jarFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jarFile;
    }

    JarFile createBootProxyJar() throws IOException {
        File dataFile = this.bundleContext.getDataFile("boot-proxy.jar");
        if (!dataFile.exists()) {
            dataFile.createNewFile();
        }
        Manifest manifest = this.createBootJarManifest();
        FileOutputStream fileOutputStream = new FileOutputStream(dataFile, false);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
        this.createDirectoryEntries(jarOutputStream, BOOT_DELEGATED_PACKAGE);
        Bundle bundle = this.bundleContext.getBundle();
        Enumeration entryPaths = bundle.getEntryPaths(TEMPLATE_CLASSES_PATH);
        if (entryPaths != null) {
            while (entryPaths.hasMoreElements()) {
                URL sourceClassResource = bundle.getEntry((String)entryPaths.nextElement());
                if (sourceClassResource == null) continue;
                this.writeRemappedClass(sourceClassResource, jarOutputStream, BOOT_DELEGATED_PACKAGE);
            }
        }
        jarOutputStream.close();
        fileOutputStream.close();
        return new JarFile(dataFile);
    }

    public void createDirectoryEntries(JarOutputStream jarStream, String packageName) throws IOException {
        StringBuilder entryName = new StringBuilder(packageName.length());
        for (String str : packageName.split("\\.")) {
            entryName.append(str).append("/");
            JarEntry jarEntry = new JarEntry(entryName.toString());
            jarStream.putNextEntry(jarEntry);
        }
    }

    private void writeRemappedClass(URL classUrl, JarOutputStream jarStream, String targetPackage) throws IOException {
        InputStream inputStream = classUrl.openStream();
        String sourceInternalName = this.getClassInternalName(classUrl);
        String targetInternalName = this.getTargetInternalName(sourceInternalName, targetPackage);
        SimpleRemapper remapper = new SimpleRemapper(sourceInternalName, targetInternalName);
        ClassReader reader = new ClassReader(inputStream);
        ClassWriter writer = new ClassWriter(reader, 2);
        ClassRemapper remappingVisitor = new ClassRemapper((ClassVisitor)writer, (Remapper)remapper);
        AddVersionFieldClassAdapter versionVisitor = new AddVersionFieldClassAdapter((ClassVisitor)remappingVisitor, VERSION_FIELD_NAME, this.getCurrentVersion());
        reader.accept((ClassVisitor)versionVisitor, 8);
        JarEntry jarEntry = new JarEntry(targetInternalName + ".class");
        jarStream.putNextEntry(jarEntry);
        jarStream.write(writer.toByteArray());
    }

    String getClassInternalName(URL classUrl) throws IOException {
        InputStream inputStream = classUrl.openStream();
        ClassReader reader = new ClassReader(inputStream);
        reader.accept(new ClassVisitor(458752){
            static final long serialVersionUID = -692416647971618741L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
            }
        }, 7);
        inputStream.close();
        return reader.getClassName();
    }

    String getTargetInternalName(String sourceInternalName, String targetPackage) {
        StringBuilder targetInternalName = new StringBuilder();
        targetInternalName.append(targetPackage.replaceAll("\\.", "/"));
        int lastSlashIndex = sourceInternalName.lastIndexOf(47);
        targetInternalName.append(sourceInternalName.substring(lastSlashIndex));
        return targetInternalName.toString();
    }

    Manifest createBootJarManifest() {
        Manifest manifest = new Manifest();
        Attributes manifestAttributes = manifest.getMainAttributes();
        manifestAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        manifestAttributes.putValue("Created-By", "Liberty Monitoring Extender");
        manifestAttributes.putValue("Created-Time", DateFormat.getInstance().format(new Date()));
        manifestAttributes.putValue(MONITORING_VERSION_MANIFEST_HEADER, this.getCurrentVersion());
        return manifest;
    }

    String getCurrentVersion() {
        return this.bundleContext.getBundle().getVersion().toString();
    }

    Method findProbeProxySetFireProbeTargetMethod() throws Exception {
        Class<?> proxyClass = Class.forName(PROBE_PROXY_CLASS_NAME);
        Method setFireProbeTargetMethod = ReflectionHelper.getDeclaredMethod(proxyClass, "setFireProbeTarget", Object.class, Method.class);
        ReflectionHelper.setAccessible(setFireProbeTargetMethod, true);
        return setFireProbeTargetMethod;
    }

    void activateProbeProxyTarget() throws Exception {
        Method method = ReflectionHelper.getDeclaredMethod(this.probeManagerImpl.getClass(), "fireProbe", Long.TYPE, Object.class, Object.class, Object.class);
        ReflectionHelper.setAccessible(method, true);
        if (!Type.getMethodDescriptor((Method)method).equals(ProbeMethodAdapter.FIRE_PROBE_METHOD_DESC)) {
            throw new IncompatibleClassChangeError("Proxy method signature does not match byte code");
        }
        this.findProbeProxySetFireProbeTargetMethod().invoke(null, this.probeManagerImpl, method);
    }

    void deactivateProbeProxyTarget() throws Exception {
        this.findProbeProxySetFireProbeTargetMethod().invoke(null, new Object[]{null, null});
    }

    Method findClassAvailableProxySetClassAvailableTargetMethod() throws Exception {
        Class<?> proxyClass = Class.forName(CLASS_AVAILABLE_PROXY_CLASS_NAME);
        Method method = ReflectionHelper.getDeclaredMethod(proxyClass, "setClassAvailableTarget", Object.class, Method.class);
        ReflectionHelper.setAccessible(method, true);
        return method;
    }

    void activateClassAvailableProxyTarget() throws Exception {
        Method method = ReflectionHelper.getDeclaredMethod(this.getClass(), "classAvailable", Class.class);
        this.findClassAvailableProxySetClassAvailableTargetMethod().invoke(null, this, method);
    }

    void deactivateClassAvailableProxyTarget() throws Exception {
        this.findClassAvailableProxySetClassAvailableTargetMethod().invoke(null, new Object[]{null, null});
    }

    public void classAvailable(Class<?> clazz) {
        this.probeManagerImpl.classAvailable(clazz);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MonitoringProxyActivator.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
        PROBE_PROXY_CLASS_NAME = "com.ibm.ws.boot.delegated.monitoring." + ProbeProxy.class.getSimpleName();
        PROBE_PROXY_CLASS_INTERNAL_NAME = PROBE_PROXY_CLASS_NAME.replaceAll("\\.", "/");
        CLASS_AVAILABLE_PROXY_CLASS_NAME = "com.ibm.ws.boot.delegated.monitoring." + ClassAvailableProxy.class.getSimpleName();
        CLASS_AVAILABLE_PROXY_CLASS_INTERNAL_NAME = CLASS_AVAILABLE_PROXY_CLASS_NAME.replaceAll("\\.", "/");
        TEMPLATE_CLASSES_PATH = ProbeProxy.class.getPackage().getName().replaceAll("\\.", "/");
    }
}

