/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ProbeAtEntryMethodAdapter
extends ProbeMethodAdapter {
    private Set<ProbeListener> enabledListeners = new HashSet<ProbeListener>();
    static final long serialVersionUID = -5367336682724983331L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ProbeAtEntryMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo, Set<ProbeListener> interested) {
        super(probeMethodAdapter, methodInfo);
        for (ProbeListener listener : interested) {
            ListenerConfiguration config = listener.getListenerConfiguration();
            ProbeAtEntry probeAtEntry = config.getProbeAtEntry();
            if (probeAtEntry == null) continue;
            this.enabledListeners.add(listener);
        }
    }

    @Override
    protected void onMethodEntry() {
        if (this.enabledListeners.isEmpty()) {
            return;
        }
        String probeKey = this.createKey();
        ProbeImpl probe = this.getProbe(probeKey);
        long probeId = probe.getIdentifier();
        this.setProbeInProgress(true);
        this.visitLdcInsn(probeId);
        if (this.isStatic() || this.isConstructor()) {
            this.visitInsn(1);
        } else {
            this.visitVarInsn(25, 0);
        }
        this.visitInsn(1);
        this.createParameterArray();
        this.visitFireProbeInvocation();
        this.setProbeInProgress(false);
        this.setProbeListeners(probe, this.enabledListeners);
    }

    private String createKey() {
        StringBuilder sb = new StringBuilder("METHOD_ENTRY: ");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeAtEntryMethodAdapter.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    }
}

