/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.monitor.annotation.ProbeAtExceptionExit;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ProbeAtExceptionExitMethodAdapter
extends ProbeMethodAdapter {
    private static final Type THROWABLE_TYPE;
    private final Set<ProbeListener> enabledListeners = new HashSet<ProbeListener>();
    private final Label startLabel = new Label();
    private final Label endLabel = new Label();
    static final long serialVersionUID = -4345947716170253531L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected ProbeAtExceptionExitMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo, Set<ProbeListener> interested) {
        super(probeMethodAdapter, methodInfo);
        for (ProbeListener listener : interested) {
            ListenerConfiguration config = listener.getListenerConfiguration();
            ProbeAtExceptionExit probeAtExceptionExit = config.getProbeAtExceptionExit();
            if (probeAtExceptionExit == null) continue;
            this.enabledListeners.add(listener);
        }
    }

    @Override
    public void onMethodEntry() {
        if (this.enabledListeners.isEmpty()) {
            return;
        }
        this.setProbeInProgress(true);
        this.visitTryCatchBlock(this.startLabel, this.endLabel, this.endLabel, THROWABLE_TYPE.getInternalName());
        this.visitLabel(this.startLabel);
        this.setProbeInProgress(false);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.enabledListeners.isEmpty()) {
            super.visitMaxs(maxStack, maxLocals);
            return;
        }
        this.setProbeInProgress(true);
        this.visitLabel(this.endLabel);
        ArrayList<Object> stackLocals = new ArrayList<Object>(this.getArgumentTypes().length + 2);
        if (!this.isStatic()) {
            stackLocals.add(Type.getType(this.getProbedClass()).getInternalName());
        }
        block7: for (Type type : this.getArgumentTypes()) {
            switch (type.getSort()) {
                case 9: 
                case 10: {
                    stackLocals.add(type.getInternalName());
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    stackLocals.add(Opcodes.INTEGER);
                    continue block7;
                }
                case 7: {
                    stackLocals.add(Opcodes.LONG);
                    continue block7;
                }
                case 6: {
                    stackLocals.add(Opcodes.FLOAT);
                    continue block7;
                }
                case 8: {
                    stackLocals.add(Opcodes.DOUBLE);
                    continue block7;
                }
            }
        }
        this.visitFrame(0, stackLocals.size(), stackLocals.toArray(), 1, new Object[]{THROWABLE_TYPE.getInternalName()});
        ProbeImpl probe = this.getProbe(this.createKey());
        long probeId = probe.getIdentifier();
        this.visitInsn(89);
        this.visitLdcInsn(probeId);
        this.visitInsn(93);
        this.visitInsn(88);
        if (this.isStatic()) {
            this.visitInsn(1);
        } else {
            this.visitVarInsn(25, 0);
        }
        this.visitInsn(95);
        this.visitInsn(1);
        this.visitInsn(95);
        this.visitFireProbeInvocation();
        this.visitInsn(191);
        this.setProbeInProgress(false);
        this.setProbeListeners(probe, this.enabledListeners);
        super.visitMaxs(maxStack, maxLocals);
    }

    private String createKey() {
        StringBuilder sb = new StringBuilder("METHOD_EXCEPTION_EXIT: ");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProbeAtExceptionExitMethodAdapter.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
        THROWABLE_TYPE = Type.getType(Throwable.class);
    }
}

