/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.pmi.server.data.SpdGroupBase;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.DoubleStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class SpdStatisticAggregate
extends SpdGroupBase
implements PmiConstants {
    private static final long serialVersionUID = -3407297120698502783L;
    protected StatisticImpl aggregateValue = null;
    protected int _type = -1;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SpdStatisticAggregate(PmiDataInfo dataInfo) {
        super(dataInfo.getId());
        this._type = dataInfo.getType();
        switch (this._type) {
            case 2: {
                this.aggregateValue = new CountStatisticImpl(this.dataId);
                break;
            }
            case 3: {
                this.aggregateValue = new DoubleStatisticImpl(this.dataId);
                break;
            }
            case 4: {
                this.aggregateValue = new TimeStatisticImpl(this.dataId);
                break;
            }
            case 6: {
                this.aggregateValue = new AverageStatisticImpl(this.dataId);
                break;
            }
            case 7: {
                this.aggregateValue = new RangeStatisticImpl(this.dataId);
                break;
            }
            case 5: {
                this.aggregateValue = new BoundedRangeStatisticImpl(this.dataId);
                break;
            }
            default: {
                this._type = -1;
                System.out.println("[SpdStatisticAggregate] Invalid statistic type");
            }
        }
    }

    @Override
    public boolean add(SpdData data) {
        if (data == null) {
            return false;
        }
        return super.add(data);
    }

    @Override
    public boolean remove(SpdData data) {
        if (data == null) {
            return false;
        }
        return super.remove(data);
    }

    @Override
    public StatisticImpl getStatistic() {
        StatisticImpl aggStat = this._getAggregate();
        aggStat.setLastSampleTime(System.currentTimeMillis());
        return aggStat;
    }

    private StatisticImpl _getAggregate() {
        switch (this._type) {
            case 2: {
                ((CountStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 3: {
                ((DoubleStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 4: {
                ((TimeStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 6: {
                ((AverageStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 5: {
                ((BoundedRangeStatisticImpl)this.aggregateValue).cleanup();
                break;
            }
            case 7: {
                ((RangeStatisticImpl)this.aggregateValue).cleanup();
                break;
            }
            default: {
                this._type = -1;
                System.out.println("[SpdStatisticAggregate] Invalid statistic type");
            }
        }
        for (int i = 0; i < this.members.size(); ++i) {
            Object member = this.members.get(i);
            if (member == null) continue;
            if (member instanceof SpdStatisticAggregate) {
                this.aggregateValue.combine(((SpdStatisticAggregate)member)._getAggregate());
                continue;
            }
            this.aggregateValue.combine(((SpdData)member).getStatistic());
        }
        return this.aggregateValue;
    }

    @Override
    public void updateAggregate() {
        this.getStatistic();
    }

    @Override
    public void reset(boolean resetAll) {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SpdStatisticAggregate.class, null, null);
    }
}

