/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.quickstart.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.quickstart.internal.Password;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.LDAPUtils;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class QuickStartSecurityRegistry
implements UserRegistry {
    static final String REALM_NAME = "QuickStartSecurityRealm";
    private volatile String user;
    @Sensitive
    private volatile Password password;
    static final long serialVersionUID = -5742953962710549989L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    QuickStartSecurityRegistry(String user, Password password) {
        this.update(user, password);
    }

    void update(String user, Password password) {
        if (user == null) {
            throw new IllegalArgumentException("user must not be null");
        }
        if (user.trim().isEmpty()) {
            throw new IllegalArgumentException("user must not be empty");
        }
        if (password == null) {
            throw new IllegalArgumentException("password must not be null");
        }
        if (password.isEmpty()) {
            throw new IllegalArgumentException("password must not be empty");
        }
        this.user = user;
        this.password = password;
    }

    public String getRealm() {
        return REALM_NAME;
    }

    public String checkPassword(String userSecurityName, @Sensitive String password) throws RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        if (password.isEmpty()) {
            throw new IllegalArgumentException("password is an empty String");
        }
        if (this.user.equals(userSecurityName) && this.password.checkPassword(password)) {
            return this.user;
        }
        return null;
    }

    public String mapCertificate(X509Certificate[] chain) throws CertificateMapNotSupportedException, CertificateMapFailedException, RegistryException {
        if (chain == null || chain.length == 0 || chain[0] == null) {
            throw new IllegalArgumentException("cert is null");
        }
        String dn = chain[0].getSubjectX500Principal().getName();
        String name = LDAPUtils.getCNFromDN((String)dn);
        if (name == null || !this.isValidUser(name)) {
            throw new CertificateMapFailedException("DN: " + dn + " does not map to a valid registry user");
        }
        return name;
    }

    public boolean isValidUser(String userSecurityName) throws RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        return this.user.equals(userSecurityName);
    }

    public SearchResult getUsers(String pattern, int limit) throws RegistryException {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern is an empty String");
        }
        if (limit >= 0 && this.user.matches(pattern)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.user);
            return new SearchResult(list, false);
        }
        return new SearchResult();
    }

    public String getUserDisplayName(String userSecurityName) throws EntryNotFoundException, RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (this.user.equals(userSecurityName)) {
            return this.user;
        }
        throw new EntryNotFoundException(userSecurityName + " does not exist");
    }

    public String getUniqueUserId(String userSecurityName) throws EntryNotFoundException, RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("userSecurityName is an empty String");
        }
        if (this.user.equals(userSecurityName)) {
            return this.user;
        }
        throw new EntryNotFoundException(userSecurityName + " does not exist");
    }

    public String getUserSecurityName(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        if (uniqueUserId == null) {
            throw new IllegalArgumentException("uniqueUserId is null");
        }
        if (uniqueUserId.isEmpty()) {
            throw new IllegalArgumentException("uniqueUserId is an empty String");
        }
        if (this.user.equals(uniqueUserId)) {
            return this.user;
        }
        throw new EntryNotFoundException(uniqueUserId + " does not exist");
    }

    public boolean isValidGroup(String groupSecurityName) throws RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        return false;
    }

    public SearchResult getGroups(String pattern, int limit) throws RegistryException {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("pattern is an empty String");
        }
        return new SearchResult();
    }

    public String getGroupDisplayName(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        throw new EntryNotFoundException("QuickStartSecurityRealm does not support groups");
    }

    public String getUniqueGroupId(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        throw new EntryNotFoundException("QuickStartSecurityRealm does not support groups");
    }

    public String getGroupSecurityName(String uniqueGroupId) throws EntryNotFoundException, RegistryException {
        if (uniqueGroupId == null) {
            throw new IllegalArgumentException("uniqueGroupId is null");
        }
        if (uniqueGroupId.isEmpty()) {
            throw new IllegalArgumentException("uniqueGroupId is an empty String");
        }
        throw new EntryNotFoundException("QuickStartSecurityRealm does not support groups");
    }

    public List<String> getUniqueGroupIdsForUser(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        if (uniqueUserId == null) {
            throw new IllegalArgumentException("uniqueUserId is null");
        }
        if (uniqueUserId.isEmpty()) {
            throw new IllegalArgumentException("uniqueUserId is an empty String");
        }
        if (this.user.equals(uniqueUserId)) {
            return new ArrayList<String>();
        }
        throw new EntryNotFoundException("QuickStartSecurityRealm does not support groups");
    }

    public List<String> getGroupsForUser(String userSecurityName) throws EntryNotFoundException, RegistryException {
        if (userSecurityName == null) {
            throw new IllegalArgumentException("userSecurityName is null");
        }
        if (userSecurityName.isEmpty()) {
            throw new IllegalArgumentException("uniqueGroupId is an empty String");
        }
        if (this.user.equals(userSecurityName)) {
            return new ArrayList<String>();
        }
        throw new EntryNotFoundException("QuickStartSecurityRealm does not support groups");
    }

    public SearchResult getUsersForGroup(String groupSecurityName, int limit) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException, RegistryException {
        if (groupSecurityName == null) {
            throw new IllegalArgumentException("groupSecurityName is null");
        }
        if (groupSecurityName.isEmpty()) {
            throw new IllegalArgumentException("groupSecurityName is an empty String");
        }
        return new SearchResult();
    }

    public String getType() {
        return "QuickStartSecurityRegistry";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(QuickStartSecurityRegistry.class, (String)"QuickStartSecurity", (String)"com.ibm.ws.security.quickstart.internal.resources.LoggingMessages");
    }
}

