/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.collector.Formatter;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.internal.impl.BaseTraceFormatter;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.JsonLogHandler;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import java.util.List;

public class ConsoleLogHandler
extends JsonLogHandler
implements SynchronousHandler,
Formatter {
    public static final String COMPONENT_NAME = "com.ibm.ws.logging.internal.impl.ConsoleLogHandler";
    private BaseTraceService.SystemLogHolder sysErrHolder;
    private BaseTraceService.SystemLogHolder sysOutHolder;
    private boolean isTraceStdout = false;
    private String format = "basic";
    private BaseTraceFormatter basicFormatter = null;
    private Integer consoleLogLevel = null;
    private static boolean copySystemStreams = false;
    private BaseTraceService baseTraceService = null;

    public ConsoleLogHandler(String serverName, String wlpUserDir, List<String> sourcesList) {
        super(serverName, wlpUserDir, sourcesList);
    }

    @Override
    public String getHandlerName() {
        return COMPONENT_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void synchronousWrite(Object event) {
        if (this.sysOutHolder == null) {
            return;
        }
        String messageOutput = null;
        boolean isStderr = false;
        GenericData genData = null;
        Integer levelVal = null;
        if (event instanceof LogTraceData) {
            genData = (LogTraceData)event;
            levelVal = ((LogTraceData)event).getLevelValue();
        } else {
            if (!(event instanceof GenericData)) throw new IllegalArgumentException("event not an instance of GenericData");
            genData = (GenericData)event;
        }
        String eventSourceName = this.getSourceNameFromDataObject(genData);
        if (!(!this.format.equals("json") && eventSourceName.equals("com.ibm.ws.logging.source.message") || this.format.equals("basic") && eventSourceName.equals("com.ibm.ws.logging.source.trace") && this.isTraceStdout)) {
            if (genData.getJsonMessage() == null) {
                genData.setJsonMessage((String)this.formatEvent(eventSourceName, "memory", event, null, -1));
            }
            messageOutput = genData.getJsonMessage();
            if (eventSourceName.equals("com.ibm.ws.logging.source.message") && levelVal != null) {
                if (levelVal < this.consoleLogLevel && (!copySystemStreams || levelVal.intValue() != WsLevel.CONFIG.intValue())) return;
                if (messageOutput == null) {
                    messageOutput = (String)this.formatEvent(eventSourceName, "memory", genData, null, -1);
                }
            } else if (messageOutput == null) {
                messageOutput = (String)this.formatEvent(eventSourceName, "memory", genData, null, -1);
            }
        } else if (this.format.equals("basic") && this.basicFormatter != null) {
            String logLevel = ((LogTraceData)event).getLoglevel();
            if (this.isTraceStdout) {
                if (levelVal.intValue() == WsLevel.ERROR.intValue() || levelVal.intValue() == WsLevel.FATAL.intValue()) {
                    isStderr = true;
                }
                messageOutput = this.basicFormatter.traceFormatGenData(genData);
            } else if (copySystemStreams && levelVal.intValue() == WsLevel.CONFIG.intValue()) {
                if (logLevel != null && logLevel.equals("SystemErr")) {
                    isStderr = true;
                }
                if ((messageOutput = this.basicFormatter.formatStreamOutput(genData)) == null) {
                    return;
                }
            } else if (levelVal >= this.consoleLogLevel) {
                if (levelVal.intValue() == WsLevel.ERROR.intValue() || levelVal.intValue() == WsLevel.FATAL.intValue()) {
                    isStderr = true;
                }
                messageOutput = this.basicFormatter.consoleLogFormat(genData);
            }
        }
        if (isStderr) {
            this.baseTraceService.writeStreamOutput(this.sysErrHolder, messageOutput, false);
            return;
        } else {
            if (messageOutput == null) return;
            this.baseTraceService.writeStreamOutput(this.sysOutHolder, messageOutput, false);
        }
    }

    @Override
    public void setWriter(Object writer) {
        this.sysOutHolder = (BaseTraceService.SystemLogHolder)writer;
    }

    public void setWriter(Object sysLogHolder, Object sysErrHolder) {
        this.sysOutHolder = (BaseTraceService.SystemLogHolder)sysLogHolder;
        this.sysErrHolder = (BaseTraceService.SystemLogHolder)sysErrHolder;
    }

    public void setCopySystemStreams(boolean copySystemStreams) {
        ConsoleLogHandler.copySystemStreams = copySystemStreams;
    }

    public void setBasicFormatter(BaseTraceFormatter formatter) {
        this.basicFormatter = formatter;
    }

    public void setConsoleLogLevel(Integer consoleLogLevel) {
        this.consoleLogLevel = consoleLogLevel;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSysErrHolder(BaseTraceService.SystemLogHolder sysErrHolder) {
        this.sysErrHolder = sysErrHolder;
    }

    public void setTraceStdout(boolean isTraceStdout) {
        this.isTraceStdout = isTraceStdout;
    }

    public void setBaseTraceService(BaseTraceService BTS) {
        this.baseTraceService = BTS;
    }
}

