/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.rest.client.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.rest.client.component.RestClientBuildListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true)
public class RestClientNotifier {
    private static RestClientNotifier instance;
    private final List<RestClientBuildListener> listeners = new CopyOnWriteArrayList<RestClientBuildListener>();
    static final long serialVersionUID = 7994594087048610825L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static RestClientNotifier getInstance() {
        return instance;
    }

    public void newRestClientProxy(MicroProfileClientProxyImpl clientProxy) {
        for (RestClientBuildListener listener : this.listeners) {
            listener.onNewRestClient(clientProxy);
        }
    }

    @Activate
    protected void activate() {
        instance = this;
    }

    @Deactivate
    protected void deactivate() {
        instance = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    protected void addListener(RestClientBuildListener newListener) {
        this.listeners.add(newListener);
    }

    protected void removeListener(RestClientBuildListener newListener) {
        this.listeners.remove(newListener);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RestClientNotifier.class, null, null);
    }
}

