/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl;

public interface CDIInterceptorWrapper {
    public static final Logger LOG = LogUtils.getL7dLogger(CDIInterceptorWrapper.class);

    public static CDIInterceptorWrapper createWrapper(Class<?> restClient) {
        try {
            return AccessController.doPrivileged(() -> {
                Class<?> cdiClass = Class.forName("javax.enterprise.inject.spi.CDI", false, restClient.getClassLoader());
                Method currentMethod = cdiClass.getMethod("current", new Class[0]);
                Object cdiCurrent = currentMethod.invoke(null, new Object[0]);
                Method getBeanMgrMethod = cdiClass.getMethod("getBeanManager", new Class[0]);
                Object beanMgr = getBeanMgrMethod.invoke(cdiCurrent, new Object[0]);
                return new CDIInterceptorWrapperImpl(restClient, beanMgr);
            });
        }
        catch (Exception pae) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Unable to load CDI SPI classes, assuming no CDI is available", pae);
            }
            return new BasicCDIInterceptorWrapper();
        }
    }

    public Object invoke(Object var1, Method var2, Object[] var3, Callable<Object> var4) throws Exception;

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class BasicCDIInterceptorWrapper
    implements CDIInterceptorWrapper {
        static final long serialVersionUID = -5612445575961708022L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BasicCDIInterceptorWrapper() {
        }

        @Trivial
        public Object invoke(Object restClient, Method m, Object[] params, Callable callable) throws Exception {
            return callable.call();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BasicCDIInterceptorWrapper.class, null, null);
        }
    }
}

