/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapper;
import org.apache.cxf.microprofile.client.cdi.InterceptorInvoker;
import org.apache.cxf.microprofile.client.cdi.MPRestClientInvocationContextImpl;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
class CDIInterceptorWrapperImpl
implements CDIInterceptorWrapper {
    private static final Logger LOG = LogUtils.getL7dLogger(CDIInterceptorWrapperImpl.class);
    private static final Class<?> FT_ANNO_CLASS = CDIInterceptorWrapperImpl.getFTAnnotationClass();
    private final CreationalContext<?> creationalContext;
    private final Map<Method, List<InterceptorInvoker>> interceptorInvokers;
    static final long serialVersionUID = 7907028769781215286L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    CDIInterceptorWrapperImpl(Class<?> restClient, Object beanManagerObject) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "<init>", new Object[]{restClient, beanManagerObject});
        }
        BeanManager beanManager = (BeanManager)beanManagerObject;
        this.creationalContext = beanManager != null ? beanManager.createCreationalContext(null) : null;
        this.interceptorInvokers = CDIInterceptorWrapperImpl.initInterceptorInvokers(beanManager, this.creationalContext, restClient);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={PrivilegedActionException.class})
    private static Class<?> getFTAnnotationClass() {
        Class clazz;
        block5: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getFTAnnotationClass", new Object[0]);
            }
            try {
                clazz = AccessController.doPrivileged(() -> Class.forName("com.ibm.ws.microprofile.faulttolerance.cdi.FaultTolerance"));
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
            }
            catch (PrivilegedActionException pae) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Exception checking for MP Fault Tolerance class - expected if FT feature isnot enabled", pae);
                }
                Class<?> clazz2 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    clazz2 = clazz2;
                    LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getFTAnnotationClass", clazz2);
                }
                return clazz2;
            }
            clazz = clazz;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getFTAnnotationClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Annotation getFTAnnotation() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getFTAnnotation", new Object[0]);
        }
        Annotation annotation = new Annotation(){
            static final long serialVersionUID = -969923796201736089L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Class<? extends Annotation> annotationType() {
                return FT_ANNO_CLASS;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        };
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            annotation = annotation;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getFTAnnotation", annotation);
        }
        return annotation;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean containsFTannotation(List<Annotation> interceptorBindings) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "containsFTannotation", new Object[]{interceptorBindings});
        }
        for (Annotation anno : interceptorBindings) {
            String className = anno.annotationType().getName();
            if (!className.startsWith("org.eclipse.microprofile.faulttolerance")) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "containsFTannotation", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "containsFTannotation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<Interceptor<?>> getFTInterceptor(BeanManager beanManager) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getFTInterceptor", new Object[]{beanManager});
        }
        Annotation ftAnno = CDIInterceptorWrapperImpl.getFTAnnotation();
        List list = beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{ftAnno});
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getFTInterceptor", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Map<Method, List<InterceptorInvoker>> initInterceptorInvokers(BeanManager beanManager, CreationalContext<?> creationalContext, Class<?> restClient) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "initInterceptorInvokers", new Object[]{beanManager, creationalContext, restClient});
        }
        HashMap invokers = new HashMap();
        HashMap<Interceptor, Object> interceptorInstances = new HashMap<Interceptor, Object>();
        AnnotatedType restClientType = beanManager.createAnnotatedType(restClient);
        List<Annotation> classBindings = CDIInterceptorWrapperImpl.getBindings(restClientType.getAnnotations(), beanManager);
        for (AnnotatedMethod method : restClientType.getMethods()) {
            Method javaMethod = method.getJavaMember();
            if (javaMethod.isDefault() || method.isStatic()) continue;
            List<Annotation> methodBindings = CDIInterceptorWrapperImpl.getBindings(method.getAnnotations(), beanManager);
            if (classBindings.isEmpty() && methodBindings.isEmpty()) continue;
            if (FT_ANNO_CLASS != null && CDIInterceptorWrapperImpl.containsFTannotation(methodBindings)) {
                methodBindings.add(CDIInterceptorWrapperImpl.getFTAnnotation());
            }
            Annotation[] interceptorBindings = CDIInterceptorWrapperImpl.merge(methodBindings, classBindings);
            ArrayList interceptors = new ArrayList(beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, interceptorBindings));
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Resolved interceptors from beanManager, " + beanManager + ":" + interceptors);
            }
            if (interceptors.isEmpty()) continue;
            ArrayList<InterceptorInvoker> chain = new ArrayList<InterceptorInvoker>();
            for (Interceptor interceptor : interceptors) {
                chain.add(new InterceptorInvoker(interceptor, interceptorInstances.computeIfAbsent(interceptor, i -> beanManager.getReference((Bean)i, (Type)i.getBeanClass(), creationalContext))));
            }
            invokers.put(javaMethod, chain);
        }
        Map<Method, List<InterceptorInvoker>> map = invokers.isEmpty() ? Collections.emptyMap() : invokers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "initInterceptorInvokers", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Annotation[] merge(List<Annotation> methodBindings, List<Annotation> classBindings) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "merge", new Object[]{methodBindings, classBindings});
        }
        Set types = methodBindings.stream().map(a -> a.annotationType()).collect(Collectors.toSet());
        ArrayList<Annotation> merged = new ArrayList<Annotation>(methodBindings);
        for (Annotation annotation : classBindings) {
            if (types.contains(annotation.annotationType())) continue;
            merged.add(annotation);
        }
        Annotation[] annotationArray = merged.toArray(new Annotation[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            annotationArray = annotationArray;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "merge", annotationArray);
        }
        return annotationArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<Annotation> getBindings(Set<Annotation> annotations, BeanManager beanManager) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getBindings", new Object[]{annotations, beanManager});
        }
        if (annotations == null || annotations.isEmpty()) {
            List<Annotation> list = Collections.emptyList();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getBindings", list);
            }
            return list;
        }
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            bindings.add(annotation);
        }
        ArrayList<Annotation> arrayList = bindings;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapperImpl", "getBindings", arrayList);
        }
        return arrayList;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object invoke(Object restClient, Method method, Object[] params, Callable<Object> callable) throws Exception {
        List<InterceptorInvoker> invokers = this.interceptorInvokers.get(method);
        if (invokers == null || invokers.isEmpty()) {
            return callable.call();
        }
        return new MPRestClientInvocationContextImpl(restClient, method, params, invokers, callable).proceed();
    }
}

