/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.context.service.serializable.ContextualCallable;
import com.ibm.ws.context.service.serializable.ContextualInvocationHandler;
import com.ibm.ws.context.service.serializable.ContextualObject;
import com.ibm.ws.context.service.serializable.ContextualRunnable;
import com.ibm.ws.context.service.serializable.ThreadContextManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.enterprise.concurrent.ContextService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.context.service", configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceFactory.class, ContextService.class, WSContextService.class, ApplicationRecycleComponent.class}, property={"creates.objectClass=javax.enterprise.concurrent.ContextService"})
public class ContextServiceImpl
implements ContextService,
ResourceFactory,
WSContextService,
ApplicationRecycleComponent {
    private static final TraceComponent tc = Tr.register(ContextServiceImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private static final String BASE_INSTANCE = "baseInstance";
    private static final String THREAD_CONTEXT_MANAGER = "threadContextManager";
    private static final String CONFIG_ID = "config.displayId";
    private static final String BASE_CONTEXT_REF = "baseContextRef";
    private static final String ID = "id";
    private static final String JNDI_NAME = "jndiName";
    private static final List<String> SUPPORTED_PROPERTIES = Arrays.asList("baseContextRef", "creates.objectClass", "id", "jndiName", "objectClass", "onError");
    private ComponentContext componentContext;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<ContextServiceImpl> modificationListeners = new LinkedList<ContextServiceImpl>();
    protected String name;
    private Dictionary<String, ?> properties;
    private Map<String, Map<String, ?>> threadContextConfigurations;
    private ThreadContextManager threadContextMgr;
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    static final long serialVersionUID = -3388488850061360647L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @ManualTrace
    @Activate
    protected void activate(ComponentContext context) {
        String contextSvcName;
        Dictionary props = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{props});
        }
        if ((contextSvcName = (String)props.get(JNDI_NAME)) == null) {
            contextSvcName = (String)props.get(CONFIG_ID);
        }
        this.lock.writeLock().lock();
        try {
            this.componentContext = context;
            this.properties = props;
            this.name = contextSvcName;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    private void baseInstanceModified() {
        ContextServiceImpl[] listeners;
        this.lock.writeLock().lock();
        try {
            listeners = this.modificationListeners.toArray(new ContextServiceImpl[this.modificationListeners.size()]);
            this.modificationListeners.clear();
            this.threadContextConfigurations = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (ContextServiceImpl listener : listeners) {
            listener.baseInstanceModified();
        }
    }

    @Trivial
    public ThreadContextDescriptor captureThreadContext(Map<String, String> executionProperties, Map<String, ?> ... additionalThreadContextConfig) {
        return this.captureThreadContext(executionProperties, (Object)null, null, additionalThreadContextConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadContextDescriptor captureThreadContext(Map<String, String> execProps, Object task, Set<String> internalNames, Map<String, ?> ... additionalThreadContextConfig) {
        Map<String, String> map = execProps = execProps == null ? new TreeMap<String, String>() : new TreeMap<String, String>(execProps);
        if (internalNames == null || !execProps.containsKey("com.ibm.ws.concurrent.TASK_OWNER")) {
            execProps.put("com.ibm.ws.concurrent.TASK_OWNER", this.name);
            if (internalNames != null) {
                internalNames.add("com.ibm.ws.concurrent.TASK_OWNER");
            }
        }
        if (!(task == null || internalNames != null && execProps.containsKey("javax.enterprise.concurrent.IDENTITY_NAME"))) {
            execProps.put("javax.enterprise.concurrent.IDENTITY_NAME", task.getClass().getName());
            if (internalNames != null) {
                internalNames.add("javax.enterprise.concurrent.IDENTITY_NAME");
            }
        }
        this.lock.readLock().lock();
        try {
            if (this.threadContextConfigurations == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    if (this.threadContextConfigurations == null) {
                        this.init();
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            Map<String, Map<String, ?>> threadContextConfig = this.threadContextConfigurations;
            if (additionalThreadContextConfig != null && additionalThreadContextConfig.length > 0) {
                threadContextConfig = new HashMap();
                threadContextConfig.putAll(this.threadContextConfigurations);
                for (Map<String, ?> config : additionalThreadContextConfig) {
                    String providerName = (String)config.get("threadContextProvider");
                    if (providerName == null) {
                        throw new IllegalArgumentException("additionalThreadContextConfig: " + config.toString());
                    }
                    threadContextConfig.put(providerName, config);
                }
            }
            Map<String, ?>[] mapArray = this.threadContextMgr.captureThreadContext(threadContextConfig, execProps);
            return mapArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T> T createContextualProxy(ThreadContextDescriptor threadContextDescriptor, T instance, Class<T> intf) {
        return (T)this.threadContextMgr.createContextualProxy(threadContextDescriptor, instance, intf);
    }

    @Trivial
    public Object createContextualProxy(Object instance, Class<?> ... interfaces) {
        return this.createContextualProxy(instance, (Map<String, String>)null, interfaces);
    }

    public Object createContextualProxy(final Object instance, Map<String, String> executionProperties, final Class<?> ... interfaces) {
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException(interfaces == null ? null : Arrays.asList(interfaces).toString());
        }
        for (Class<?> intf : interfaces) {
            if (intf != null && intf.isInstance(instance)) continue;
            throw new IllegalArgumentException(instance + ", " + (intf == null ? null : intf.getName()));
        }
        HashSet<String> internalPropNames = executionProperties == null ? null : new HashSet<String>();
        ThreadContextDescriptor threadContextDescriptor = this.captureThreadContext(executionProperties, instance, internalPropNames, new Map[0]);
        Object proxy = null;
        if (interfaces.length == 1) {
            if (Callable.class.equals(interfaces[0])) {
                proxy = new ContextualCallable(threadContextDescriptor, (Callable)instance, internalPropNames);
            } else if (Runnable.class.equals(interfaces[0])) {
                proxy = new ContextualRunnable(threadContextDescriptor, (Runnable)instance, internalPropNames);
            }
        }
        if (proxy == null) {
            ContextualInvocationHandler handler = new ContextualInvocationHandler(threadContextDescriptor, instance, internalPropNames);
            proxy = AccessController.doPrivileged(new PrivilegedAction<Object>((InvocationHandler)handler){
                final /* synthetic */ InvocationHandler val$handler;
                static final long serialVersionUID = -4054904372710508315L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    this.val$handler = invocationHandler;
                }

                @Override
                public Object run() {
                    return Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, this.val$handler);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
                }
            });
        }
        return proxy;
    }

    public <T> T createContextualProxy(T instance, Class<T> intf) {
        ThreadContextDescriptor threadContextDescriptor = this.captureThreadContext(null, instance, null, new Map[0]);
        return (T)this.threadContextMgr.createContextualProxy(threadContextDescriptor, instance, intf);
    }

    public <T> T createContextualProxy(T instance, Map<String, String> executionProperties, final Class<T> intf) {
        T proxy;
        HashSet<String> internalPropNames = executionProperties == null ? null : new HashSet<String>();
        ThreadContextDescriptor threadContextDescriptor = this.captureThreadContext(executionProperties, instance, internalPropNames, new Map[0]);
        if (intf == null || !intf.isInstance(instance)) {
            throw new IllegalArgumentException(instance + ", " + (intf == null ? null : intf.getName()));
        }
        if (Callable.class.equals(intf)) {
            Callable callable = (Callable)instance;
            proxy = intf.cast(new ContextualCallable(threadContextDescriptor, callable, internalPropNames));
        } else if (Runnable.class.equals(intf)) {
            proxy = intf.cast(new ContextualRunnable(threadContextDescriptor, (Runnable)instance, internalPropNames));
        } else {
            ContextualInvocationHandler handler = new ContextualInvocationHandler(threadContextDescriptor, instance, internalPropNames);
            proxy = AccessController.doPrivileged(new PrivilegedAction<T>((InvocationHandler)handler){
                final /* synthetic */ InvocationHandler val$handler;
                static final long serialVersionUID = 4843387472293121237L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;
                {
                    this.val$handler = invocationHandler;
                }

                @Override
                public T run() {
                    return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, this.val$handler));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
                }
            });
        }
        return proxy;
    }

    public Object createResource(ResourceInfo ref) throws Exception {
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return this;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.lock.writeLock().lock();
        try {
            this.componentContext = null;
            this.properties = null;
            this.threadContextConfigurations = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComplementaryThreadContextConfigurationsTo(ContextServiceImpl contextSvc) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.lock.writeLock().lock();
        try {
            if (this.lock.getWriteHoldCount() > 1) {
                IllegalArgumentException x = this.ignoreWarnOrFail(null, IllegalArgumentException.class, "CWWKC1020.baseContextRef.infinite", this.name);
                if (x == null) {
                    return;
                }
                throw x;
            }
            if (this.threadContextConfigurations == null) {
                this.init();
            }
            this.modificationListeners.add(contextSvc);
            for (Map.Entry<String, Map<String, ?>> threadContextConfig : this.threadContextConfigurations.entrySet()) {
                String name = threadContextConfig.getKey();
                if (contextSvc.threadContextConfigurations.containsKey(name)) continue;
                contextSvc.threadContextConfigurations.put(name, threadContextConfig.getValue());
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("adding " + name), (Object[])new Object[]{threadContextConfig.getValue()});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Trivial
    Collection<String> getContextualMethods() {
        this.lock.readLock().lock();
        try {
            Collection contextualMethods;
            Collection collection = contextualMethods = (Collection)this.properties.get("com.ibm.ws.concurrent.CONTEXTUAL_METHODS");
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, String> getExecutionProperties(final Object contextualProxy) {
        ContextualObject contextualObject = null;
        if (contextualProxy != null && Proxy.isProxyClass(contextualProxy.getClass())) {
            InvocationHandler handler = AccessController.doPrivileged(new PrivilegedAction<InvocationHandler>(){
                static final long serialVersionUID = -7781087509793839734L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public InvocationHandler run() {
                    return Proxy.getInvocationHandler(contextualProxy);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
                }
            });
            if (handler instanceof ContextualObject) {
                contextualObject = (ContextualObject)handler;
            }
        } else if (contextualProxy instanceof ContextualObject) {
            contextualObject = (ContextualObject)contextualProxy;
        }
        if (contextualObject == null) {
            throw new IllegalArgumentException(contextualProxy == null ? null : contextualProxy.getClass().getName());
        }
        return contextualObject.getExecutionProperties();
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Throwable> T ignoreWarnOrFail(Throwable throwable, final Class<T> exceptionClassToRaise, String msgKey, Object ... objs) {
        switch ((OnErrorUtil.OnError)this.properties.get("onError")) {
            case IGNORE: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ignoring error: " + msgKey), (Object[])objs);
                }
                return null;
            }
            case WARN: {
                Tr.warning((TraceComponent)tc, (String)msgKey, (Object[])objs);
                return null;
            }
            case FAIL: {
                try {
                    if (throwable != null && exceptionClassToRaise.isInstance(throwable)) {
                        return (T)((Throwable)exceptionClassToRaise.cast(throwable));
                    }
                    Constructor con = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){
                        static final long serialVersionUID = -4483886788101743920L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Constructor<T> run() throws NoSuchMethodException {
                            return exceptionClassToRaise.getConstructor(String.class);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(4.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
                        }
                    });
                    String message = msgKey == null ? throwable.getMessage() : Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])objs);
                    Throwable failure = (Throwable)con.newInstance(message);
                    failure.initCause(throwable);
                    return (T)failure;
                }
                catch (PrivilegedActionException con) {
                    void e;
                    FFDCFilter.processException((Throwable)con, (String)"com.ibm.ws.concurrent.internal.ContextServiceImpl", (String)"526", (Object)this, (Object[])new Object[]{throwable, exceptionClassToRaise, msgKey, objs});
                    throw new RuntimeException(e.getCause());
                }
                catch (RuntimeException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.concurrent.internal.ContextServiceImpl", (String)"528", (Object)this, (Object[])new Object[]{throwable, exceptionClassToRaise, msgKey, objs});
                    throw e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.concurrent.internal.ContextServiceImpl", (String)"530", (Object)this, (Object[])new Object[]{throwable, exceptionClassToRaise, msgKey, objs});
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    private void init() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        HashMap threadContextConfigs = new HashMap();
        Enumeration<String> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.length() > 25 && key.charAt(22) == '.') {
                int dot = key.indexOf(46, 23);
                if (dot <= 0) continue;
                String group = key.substring(23, dot);
                TreeMap config = (TreeMap)threadContextConfigs.get(group);
                if (config == null) {
                    config = new TreeMap();
                    threadContextConfigs.put(group, config);
                }
                config.put(key.substring(dot + 1), this.properties.get(key));
                continue;
            }
            if (!trace || !tc.isDebugEnabled() || SUPPORTED_PROPERTIES.contains(key) || key.indexOf(46) >= 0) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("unrecognized attribute: " + key), (Object[])new Object[0]);
        }
        this.threadContextConfigurations = new TreeMap();
        for (Map threadContextConfig : threadContextConfigs.values()) {
            Map previous;
            String provider = (String)threadContextConfig.get("threadContextProvider");
            if (provider == null) {
                provider = (String)threadContextConfig.get("config.referenceType") + ".provider";
            }
            if ((previous = this.threadContextConfigurations.put(provider, threadContextConfig)) == null) continue;
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1002.provider.cardinality.violation", (Object[])new Object[]{this.name, previous.get("config.referenceType")}));
        }
        ContextServiceImpl baseInstance = AccessController.doPrivileged(new PrivilegedAction<ContextServiceImpl>(){
            static final long serialVersionUID = -3372072671383893376L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ContextServiceImpl run() {
                return (ContextServiceImpl)ContextServiceImpl.this.componentContext.locateService(ContextServiceImpl.BASE_INSTANCE);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(5.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
            }
        });
        if (baseInstance != null) {
            baseInstance.addComplementaryThreadContextConfigurationsTo(this);
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"context configuration", (Object[])new Object[]{this.threadContextConfigurations});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @ManualTrace
    @Modified
    protected void modified(ComponentContext context) {
        ContextServiceImpl[] listeners;
        String contextSvcName;
        Dictionary props = context.getProperties();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"modified", (Object[])new Object[]{props});
        }
        if ((contextSvcName = (String)props.get(JNDI_NAME)) == null) {
            contextSvcName = (String)props.get(CONFIG_ID);
        }
        this.lock.writeLock().lock();
        try {
            listeners = this.modificationListeners.toArray(new ContextServiceImpl[this.modificationListeners.size()]);
            this.modificationListeners.clear();
            this.componentContext = context;
            this.properties = props;
            this.name = contextSvcName;
            this.threadContextConfigurations = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (ContextServiceImpl listener : listeners) {
            listener.baseInstanceModified();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"modified");
        }
    }

    @Reference(name="baseInstance", service=ContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(id=unbound)")
    protected void setBaseInstance(ServiceReference<ContextService> ref) {
        this.lock.writeLock().lock();
        try {
            this.threadContextConfigurations = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Reference(name="threadContextManager", service=WSContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, target="(component.name=com.ibm.ws.context.manager)")
    protected void setThreadContextManager(WSContextService svc) {
        this.threadContextMgr = (ThreadContextManager)svc;
    }

    protected void unsetBaseInstance(ServiceReference<ContextService> ref) {
        this.lock.writeLock().lock();
        try {
            this.threadContextConfigurations = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void unsetThreadContextManager(WSContextService svc) {
        this.threadContextMgr = null;
    }
}

