/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrency.policy.ConcurrencyPolicy;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.concurrent.internal.TaskLifeCycleCallback;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.PolicyTaskCallback;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.concurrent.managedExecutorService"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ExecutorService.class, ManagedExecutorService.class, ResourceFactory.class, ApplicationRecycleComponent.class}, reference={@Reference(name="ApplicationRecycleCoordinator", service=ApplicationRecycleCoordinator.class)}, property={"creates.objectClass=java.util.concurrent.ExecutorService", "creates.objectClass=javax.enterprise.concurrent.ManagedExecutorService"})
public class ManagedExecutorServiceImpl
implements ExecutorService,
ManagedExecutorService,
ResourceFactory,
ApplicationRecycleComponent,
WSManagedExecutorService {
    private static final TraceComponent tc = Tr.register(ManagedExecutorServiceImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    static final String APP_RECYCLE_SERVICE = "ApplicationRecycleCoordinator";
    private static final Map<String, String> XPROPS_SUSPEND_TRAN = Collections.singletonMap("javax.enterprise.concurrent.TRANSACTION", "SUSPEND");
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PrivilegedAction<WSContextService> contextSvcAccessor = new PrivilegedAction<WSContextService>(){
        static final long serialVersionUID = -1311597716763976334L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - void declaration
         */
        @Override
        @Trivial
        public WSContextService run() {
            try {
                return (WSContextService)ManagedExecutorServiceImpl.this.contextSvcRef.getServiceWithException();
            }
            catch (IllegalStateException illegalStateException) {
                void x;
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl$1", (String)"110", (Object)this, (Object[])new Object[0]);
                throw new RejectedExecutionException((Throwable)x);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        }
    };
    private final AtomicServiceReference<WSContextService> contextSvcRef = new AtomicServiceReference("ContextService");
    private final AtomicReference<Map<String, String>> defaultExecutionProperties = new AtomicReference();
    private final AtomicReference<String> jndiNameRef = new AtomicReference();
    final AtomicReference<PolicyExecutor> longRunningPolicyExecutorRef = new AtomicReference();
    private final WSContextService mpContextService;
    final AtomicReference<String> name = new AtomicReference();
    volatile PolicyExecutor policyExecutor;
    private final PrivilegedAction<ThreadContextProvider> tranContextProviderAccessor = new PrivilegedAction<ThreadContextProvider>(){
        static final long serialVersionUID = -220575604455718022L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public ThreadContextProvider run() {
            return (ThreadContextProvider)ManagedExecutorServiceImpl.this.tranContextProviderRef.getService();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
        }
    };
    private AtomicServiceReference<ThreadContextProvider> tranContextProviderRef = new AtomicServiceReference("TransactionContextProvider");
    static final long serialVersionUID = 7195414696466342700L;

    @Trivial
    public ManagedExecutorServiceImpl() {
        this.mpContextService = null;
    }

    @Trivial
    public ManagedExecutorServiceImpl(String name, PolicyExecutor policyExecutor, WSContextService mpThreadContext, AtomicServiceReference<ThreadContextProvider> tranContextProviderRef) {
        this.name.set(name);
        this.policyExecutor = policyExecutor;
        this.longRunningPolicyExecutorRef.set(policyExecutor);
        this.mpContextService = mpThreadContext;
        this.tranContextProviderRef = tranContextProviderRef;
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.contextSvcRef.activate(context);
        this.tranContextProviderRef.activate(context);
        String jndiName = (String)properties.get("jndiName");
        this.jndiNameRef.set(jndiName);
        String xsvcName = jndiName == null ? (String)properties.get("config.displayId") : jndiName;
        this.name.set(xsvcName);
        TreeMap<String, String> execProps = new TreeMap<String, String>();
        execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", xsvcName);
        this.defaultExecutionProperties.set(execProps);
    }

    @Modified
    protected void modified(final ComponentContext context, Map<String, Object> properties) {
        String jndiName = (String)properties.get("jndiName");
        String oldJNDIName = this.jndiNameRef.getAndSet(jndiName);
        String xsvcName = jndiName == null ? (String)properties.get("config.displayId") : jndiName;
        this.name.set(xsvcName);
        TreeMap<String, String> execProps = new TreeMap<String, String>();
        execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", xsvcName);
        this.defaultExecutionProperties.set(execProps);
        if ((jndiName == null ? oldJNDIName != null : !jndiName.equals(oldJNDIName)) && !this.applications.isEmpty()) {
            ApplicationRecycleCoordinator appCoord = AccessController.doPrivileged(new PrivilegedAction<ApplicationRecycleCoordinator>(){
                static final long serialVersionUID = 222475267909177380L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ApplicationRecycleCoordinator run() {
                    return (ApplicationRecycleCoordinator)context.locateService(ManagedExecutorServiceImpl.APP_RECYCLE_SERVICE);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
                }
            });
            HashSet<String> members = new HashSet<String>(this.applications);
            this.applications.removeAll(members);
            appCoord.recycleApplications(members);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        int count = this.policyExecutor.cancel(this.getIdentifier(this.policyExecutor.getIdentifier()), true);
        PolicyExecutor longRunningExecutor = this.longRunningPolicyExecutorRef.get();
        if (longRunningExecutor != null) {
            count += longRunningExecutor.cancel(this.getIdentifier(longRunningExecutor.getIdentifier()), true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(count + " submitted tasks canceled"), (Object[])new Object[0]);
        }
        this.contextSvcRef.deactivate(context);
        this.tranContextProviderRef.deactivate(context);
    }

    @Override
    @Trivial
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new IllegalStateException(new UnsupportedOperationException("awaitTermination"));
    }

    private <T> Map.Entry<Collection<? extends Callable<T>>, TaskLifeCycleCallback[]> createCallbacks(Collection<? extends Callable<T>> tasks) {
        int numTasks = tasks.size();
        TaskLifeCycleCallback[] callbacks = new TaskLifeCycleCallback[numTasks];
        ArrayList<Callable<T>> taskUpdates = null;
        if (numTasks == 1) {
            ThreadContextDescriptor contextDescriptor;
            Callable task = tasks.iterator().next();
            if (task instanceof ContextualAction) {
                ContextualAction a = (ContextualAction)((Object)task);
                contextDescriptor = a.getContextDescriptor();
                task = (Callable)a.getAction();
                taskUpdates = Arrays.asList(task);
            } else {
                contextDescriptor = this.getContextService().captureThreadContext(this.getExecutionProperties(task), new Map[0]);
            }
            callbacks[0] = new TaskLifeCycleCallback(this, contextDescriptor);
        } else {
            HashMap<Map<String, String>, TaskLifeCycleCallback> execPropsToCallback = new HashMap<Map<String, String>, TaskLifeCycleCallback>();
            WSContextService contextSvc = null;
            int t = 0;
            for (Callable<T> task : tasks) {
                if (task instanceof ContextualAction) {
                    ContextualAction a = (ContextualAction)((Object)task);
                    taskUpdates = taskUpdates == null ? new ArrayList<Callable<T>>(tasks) : taskUpdates;
                    taskUpdates.set(t, (Callable<T>)a.getAction());
                    callbacks[t++] = new TaskLifeCycleCallback(this, a.getContextDescriptor());
                    continue;
                }
                Map<String, String> execProps = this.getExecutionProperties(task);
                TaskLifeCycleCallback callback = (TaskLifeCycleCallback)((Object)execPropsToCallback.get(execProps));
                if (callback == null) {
                    contextSvc = contextSvc == null ? this.getContextService() : contextSvc;
                    callback = new TaskLifeCycleCallback(this, contextSvc.captureThreadContext(execProps, new Map[0]));
                    execPropsToCallback.put(execProps, callback);
                }
                callbacks[t++] = callback;
            }
        }
        return new AbstractMap.SimpleEntry<Collection<? extends Callable<T>>, TaskLifeCycleCallback[]>(taskUpdates == null ? tasks : taskUpdates, callbacks);
    }

    public Object createResource(ResourceInfo ref) throws Exception {
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return this;
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    @Override
    public WSContextService getContextService() {
        return this.mpContextService == null ? AccessController.doPrivileged(this.contextSvcAccessor) : this.mpContextService;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    @Override
    public PolicyExecutor getNormalPolicyExecutor() {
        return this.policyExecutor;
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command, null);
    }

    final Map<String, String> getExecutionProperties(Object task) {
        Map<String, String> execProps;
        if (task == null) {
            throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1111.task.invalid", (Object[])new Object[]{null}));
        }
        Map<String, String> map = execProps = task instanceof ManagedTask ? ((ManagedTask)task).getExecutionProperties() : null;
        if (execProps == null) {
            execProps = this.defaultExecutionProperties.get();
        } else {
            String tranProp = (execProps = new TreeMap<String, String>(execProps)).remove("javax.enterprise.concurrent.TRANSACTION");
            if (tranProp != null && !"SUSPEND".equals(tranProp)) {
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1130.xprop.value.invalid", (Object[])new Object[]{this.name, "javax.enterprise.concurrent.TRANSACTION", tranProp}));
            }
            if (!execProps.containsKey("com.ibm.ws.concurrent.DEFAULT_CONTEXT")) {
                execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
            }
            if (!execProps.containsKey("com.ibm.ws.concurrent.TASK_OWNER")) {
                execProps.put("com.ibm.ws.concurrent.TASK_OWNER", this.name.get());
            }
        }
        return execProps;
    }

    @Trivial
    final String getIdentifier(String policyExecutorIdentifier) {
        return policyExecutorIdentifier.startsWith("managed") ? policyExecutorIdentifier : this.name.get() + " (" + policyExecutorIdentifier + ')';
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[callbacks.length - 1].policyExecutor : this.policyExecutor;
        return executor.invokeAll(tasks, callbacks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[0].policyExecutor : this.policyExecutor;
        return executor.invokeAll(tasks, callbacks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[0].policyExecutor : this.policyExecutor;
        return (T)executor.invokeAny(tasks, callbacks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Map.Entry<Collection<Callable<T>>, TaskLifeCycleCallback[]> entry = this.createCallbacks(tasks);
        tasks = entry.getKey();
        PolicyTaskCallback[] callbacks = entry.getValue();
        PolicyExecutor executor = callbacks.length > 0 ? callbacks[0].policyExecutor : this.policyExecutor;
        return (T)executor.invokeAny(tasks, callbacks, timeout, unit);
    }

    @Override
    @Trivial
    public boolean isShutdown() {
        throw new IllegalStateException(new UnsupportedOperationException("isShutdown"));
    }

    @Override
    @Trivial
    public boolean isTerminated() {
        throw new IllegalStateException(new UnsupportedOperationException("isTerminated"));
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setConcurrencyPolicy(ConcurrencyPolicy svc) {
        this.policyExecutor = svc.getExecutor();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, target="(id=unbound)")
    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.setReference(ref);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(id=unbound)")
    protected void setLongRunningPolicy(ConcurrencyPolicy svc) {
        this.longRunningPolicyExecutorRef.set(svc.getExecutor());
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, target="(component.name=com.ibm.ws.transaction.context.provider)")
    protected void setTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.tranContextProviderRef.setReference(ref);
    }

    @Override
    @Trivial
    public void shutdown() {
        throw new IllegalStateException(new UnsupportedOperationException("shutdown"));
    }

    @Override
    @Trivial
    public List<Runnable> shutdownNow() {
        throw new IllegalStateException(new UnsupportedOperationException("shutdownNow"));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        ThreadContextDescriptor contextDescriptor;
        Map<String, String> execProps = this.getExecutionProperties(task);
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)((Object)task);
            contextDescriptor = a.getContextDescriptor();
            task = (Callable)a.getAction();
        } else {
            WSContextService contextSvc = this.getContextService();
            contextDescriptor = contextSvc.captureThreadContext(execProps, new Map[0]);
        }
        TaskLifeCycleCallback callback = new TaskLifeCycleCallback(this, contextDescriptor);
        return callback.policyExecutor.submit(task, (PolicyTaskCallback)callback);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        ThreadContextDescriptor contextDescriptor;
        Map<String, String> execProps = this.getExecutionProperties(task);
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)((Object)task);
            contextDescriptor = a.getContextDescriptor();
            task = (Runnable)a.getAction();
        } else {
            WSContextService contextSvc = this.getContextService();
            contextDescriptor = contextSvc.captureThreadContext(execProps, new Map[0]);
        }
        TaskLifeCycleCallback callback = new TaskLifeCycleCallback(this, contextDescriptor);
        return callback.policyExecutor.submit(task, result, (PolicyTaskCallback)callback);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    ThreadContext suspendTransaction() {
        ThreadContext suspendedTranSnapshot;
        ThreadContextProvider tranContextProvider = AccessController.doPrivileged(this.tranContextProviderAccessor);
        ThreadContext threadContext = suspendedTranSnapshot = tranContextProvider == null ? null : tranContextProvider.captureThreadContext(XPROPS_SUSPEND_TRAN, null);
        if (suspendedTranSnapshot != null) {
            suspendedTranSnapshot.taskStarting();
        }
        return suspendedTranSnapshot;
    }

    protected void unsetConcurrencyPolicy(ConcurrencyPolicy svc) {
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef.unsetReference(ref);
    }

    protected void unsetLongRunningPolicy(ConcurrencyPolicy svc) {
        this.longRunningPolicyExecutorRef.compareAndSet(svc.getExecutor(), null);
    }

    protected void unsetTransactionContextProvider(ServiceReference<ThreadContextProvider> ref) {
        this.tranContextProviderRef.unsetReference(ref);
    }
}

