/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter;

import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaConsumer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaProducer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;

public abstract class KafkaAdapterFactory {
    private static final String KAFKA_CONSUMER_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.KafkaConsumerImpl";
    private static final Class<?>[] KAFKA_CONSUMER_ARG_TYPES = new Class[]{Map.class};
    private static final String KAFKA_PRODUCER_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.KafkaProducerImpl";
    private static final Class<?>[] KAFKA_PRODUCER_ARG_TYPES = new Class[]{Map.class};
    private static final String TOPIC_PARTITION_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.TopicPartitionImpl";
    private static final Class<?>[] TOPIC_PARTITION_ARG_TYPES = new Class[]{String.class, Integer.TYPE};
    private static final String OFFSET_AND_METADATA_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.OffsetAndMetadataImpl";
    private static final Class<?>[] OFFSET_AND_METADATA_ARG_TYPES = new Class[]{Long.TYPE, Optional.class, String.class};
    private static final String COMMIT_FAILED_EXCEPTION = "org.apache.kafka.clients.consumer.CommitFailedException";
    private static final Class<?>[] COMMIT_FAILED_EXCEPTION_ARG_TYPES = new Class[0];

    protected abstract ClassLoader getClassLoader();

    public <K, V> KafkaConsumer<K, V> newKafkaConsumer(Map<String, Object> consumerConfig) {
        KafkaConsumer kafkaConsumer = KafkaAdapterFactory.getInstance(this.getClassLoader(), KafkaConsumer.class, KAFKA_CONSUMER_IMPL, KAFKA_CONSUMER_ARG_TYPES, consumerConfig);
        return kafkaConsumer;
    }

    public <K, V> KafkaProducer<K, V> newKafkaProducer(Map<String, Object> producerConfig) {
        KafkaProducer kafkaProducer = KafkaAdapterFactory.getInstance(this.getClassLoader(), KafkaProducer.class, KAFKA_PRODUCER_IMPL, KAFKA_PRODUCER_ARG_TYPES, producerConfig);
        return kafkaProducer;
    }

    public TopicPartition newTopicPartition(String topic, int partition) {
        TopicPartition topicPartition = KafkaAdapterFactory.getInstance(this.getClassLoader(), TopicPartition.class, TOPIC_PARTITION_IMPL, TOPIC_PARTITION_ARG_TYPES, topic, partition);
        return topicPartition;
    }

    public OffsetAndMetadata newOffsetAndMetadata(long commitOffset, Optional<Integer> leaderEpoch, String metadata) {
        OffsetAndMetadata offsetAndMetadata = KafkaAdapterFactory.getInstance(this.getClassLoader(), OffsetAndMetadata.class, OFFSET_AND_METADATA_IMPL, OFFSET_AND_METADATA_ARG_TYPES, commitOffset, leaderEpoch, metadata);
        return offsetAndMetadata;
    }

    public Exception newCommitFailedException() {
        Exception e = KafkaAdapterFactory.getInstance(this.getClassLoader(), Exception.class, COMMIT_FAILED_EXCEPTION, COMMIT_FAILED_EXCEPTION_ARG_TYPES, new Object[0]);
        return e;
    }

    protected static final <T> T getInstance(ClassLoader classloader, Class<T> interfaceClass, String implClassName, Class<?>[] parameterTypes, Object ... parameters) {
        Class<T> implClass = KafkaAdapterFactory.getImplClass(classloader, interfaceClass, implClassName);
        T instance = KafkaAdapterFactory.getInstance(implClass, parameterTypes, parameters);
        return instance;
    }

    protected static final <T> T getInstance(Class<T> implClass, Class<?>[] parameterTypes, Object[] parameters) {
        Constructor<T> xtor = KafkaAdapterFactory.getConstructor(implClass, parameterTypes);
        T instance = null;
        try {
            instance = xtor.newInstance(parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new KafkaAdapterException(e);
        }
        return instance;
    }

    protected static final <T> Constructor<T> getConstructor(Class<T> implClass, Class<?> ... parameterTypes) {
        Constructor<T> xtor = null;
        try {
            xtor = implClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new KafkaAdapterException(e);
        }
        return xtor;
    }

    protected static final <T> Class<? extends T> getImplClass(ClassLoader classloader, Class<T> interfaceClass, String implClassName) {
        Class<?> implClass = null;
        try {
            implClass = classloader.loadClass(implClassName);
        }
        catch (ClassNotFoundException e) {
            throw new KafkaAdapterException(e);
        }
        return implClass;
    }
}

