/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.ProductRelatedParser;
import com.ibm.ws.repository.resources.writeable.ProductResourceWritable;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProductZipParser
extends ProductRelatedParser<ProductResourceWritable> {
    private static final String PROP_GENERIC_REQUIREMENTS = "genericRequirements";
    private static final String PROP_PACKAGED_JAVA = "packagedJava";
    static final long serialVersionUID = -8829904649462153797L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProductRelatedParser.AssetInformation extractInformationFromAsset(final File archive, ParserBase.ArtifactMetadata metadata) throws PrivilegedActionException, ProductInfoParseException, IOException {
        ProductRelatedParser.AssetInformation assetInformtion = new ProductRelatedParser.AssetInformation();
        try (ZipFile zipFile = null;){
            zipFile = AccessController.doPrivileged(new PrivilegedExceptionAction<ZipFile>(){
                static final long serialVersionUID = -1345888713946695725L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ZipFile run() throws IOException {
                    return new ZipFile(archive);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, null, null);
                }
            });
            assetInformtion.addProductInfos(zipFile, "wlp/", archive);
            assetInformtion.type = ResourceType.INSTALL;
            assetInformtion.provideFeature = metadata.getProperty("provideFeature");
            assetInformtion.laLocation = "wlp/lafiles/LA";
            assetInformtion.liLocation = "wlp/lafiles/LI";
            assetInformtion.fileWithLicensesIn = archive;
            assetInformtion.genericRequirements = metadata.getProperty(PROP_GENERIC_REQUIREMENTS);
            assetInformtion.packagedJava = metadata.getProperty(PROP_PACKAGED_JAVA);
        }
        return assetInformtion;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ProductZipParser.class, null, null);
    }
}

