/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.extended.SSOCookieHelperImplExtended;
import com.ibm.ws.webcontainer.security.internal.BasicAuthAuthenticator;
import com.ibm.ws.webcontainer.security.internal.CertificateLoginAuthenticator;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebAuthenticatorProxyExtended
extends WebAuthenticatorProxy {
    private static final TraceComponent tc = Tr.register(WebAuthenticatorProxyExtended.class, null, null);
    private final AtomicServiceReference<OidcServer> oidcServerRef;
    static final long serialVersionUID = -6484703206286851753L;

    public WebAuthenticatorProxyExtended(WebAppSecurityConfig webAppSecurityConfig, PostParameterHelper postParameterHelper, AtomicServiceReference<SecurityService> securityServiceRef, WebProviderAuthenticatorProxy providerAuthenticatorProxy, AtomicServiceReference<OidcServer> oidcServerRef) {
        super(webAppSecurityConfig, postParameterHelper, securityServiceRef, providerAuthenticatorProxy);
        this.oidcServerRef = oidcServerRef;
    }

    protected BasicAuthAuthenticator createBasicAuthenticator() throws RegistryException {
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        UserRegistryService userRegistryService = securityService.getUserRegistryService();
        UserRegistry userRegistry = null;
        if (userRegistryService.isUserRegistryConfigured()) {
            userRegistry = userRegistryService.getUserRegistry();
        }
        SSOCookieHelperImplExtended sSOCookieHelper = new SSOCookieHelperImplExtended(this.webAppSecurityConfig, this.oidcServerRef);
        return new BasicAuthAuthenticator(securityService.getAuthenticationService(), userRegistry, (SSOCookieHelper)sSOCookieHelper, this.webAppSecurityConfig);
    }

    public CertificateLoginAuthenticator createCertificateLoginAuthenticator() {
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        return new CertificateLoginAuthenticator(securityService.getAuthenticationService(), (SSOCookieHelper)new SSOCookieHelperImplExtended(this.webAppSecurityConfig, this.oidcServerRef));
    }
}

