/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal.extended;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.extended.ReferrerURLCookieHandlerExtended;
import com.ibm.ws.webcontainer.security.extended.SSOCookieHelperImplExtended;
import com.ibm.ws.webcontainer.security.extended.WebAppSecurityConfigExtended;
import com.ibm.ws.webcontainer.security.extended.WebAuthenticatorProxyExtended;
import com.ibm.ws.webcontainer.security.internal.WebAppSecurityConfigImpl;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServer;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebAppSecurityConfigImplExtended
extends WebAppSecurityConfigImpl
implements WebAppSecurityConfigExtended {
    private static final TraceComponent tc = Tr.register(WebAppSecurityConfigImplExtended.class, null, null);
    protected final AtomicServiceReference<OidcServer> oidcServerRef;
    protected final AtomicServiceReference<OidcClient> oidcClientRef;
    static final long serialVersionUID = -720314228807838986L;

    public WebAppSecurityConfigImplExtended(Map<String, Object> newProperties, AtomicServiceReference<WsLocationAdmin> locationAdminRef, AtomicServiceReference<SecurityService> securityServiceRef, AtomicServiceReference<OidcServer> oidcServerRef, AtomicServiceReference<OidcClient> oidcClientRef) {
        super(newProperties, locationAdminRef, securityServiceRef);
        this.oidcServerRef = oidcServerRef;
        this.oidcClientRef = oidcClientRef;
        this.setSsoCookieName(oidcServerRef, oidcClientRef);
    }

    @Override
    public void setSsoCookieName(AtomicServiceReference<OidcServer> oidcServerRef, AtomicServiceReference<OidcClient> oidcClientRef) {
        String genCookieName;
        if ("LtpaToken2".equalsIgnoreCase(this.ssoCookieName) && this.isRunTimeAutoGenSsoCookieName() && (genCookieName = this.generateSsoCookieName()) != null) {
            this.ssoCookieName = genCookieName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"auto generate ssoCookieName: ", (Object[])new Object[]{this.ssoCookieName});
            }
        }
    }

    protected String resolveSsoCookieName(Map<String, Object> newProperties) {
        String genCookieName = null;
        String cookieName = (String)newProperties.get("ssoCookieName");
        if ("LtpaToken2".equalsIgnoreCase(cookieName) && (this.autoGenSsoCookieName.booleanValue() || this.isRunTimeAutoGenSsoCookieName())) {
            genCookieName = this.generateSsoCookieName();
        }
        if (genCookieName != null) {
            return genCookieName;
        }
        return cookieName;
    }

    private boolean isRunTimeAutoGenSsoCookieName() {
        return this.oidcClientRef != null && this.oidcClientRef.getService() != null || this.oidcServerRef != null && this.oidcServerRef.getService() != null && !((OidcServer)this.oidcServerRef.getService()).allowDefaultSsoCookieName();
    }

    public SSOCookieHelper createSSOCookieHelper() {
        return new SSOCookieHelperImplExtended(this);
    }

    public ReferrerURLCookieHandler createReferrerURLCookieHandler() {
        return new ReferrerURLCookieHandlerExtended(this);
    }

    public WebAuthenticatorProxy createWebAuthenticatorProxy() {
        return new WebAuthenticatorProxyExtended(this, null, (AtomicServiceReference<SecurityService>)this.securityServiceRef, null, this.oidcServerRef);
    }
}

