/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.osgi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.container.osgi.internal.OSGiJPAApplInfo;
import com.ibm.ws.jpa.container.osgi.internal.OSGiJPAPXml;
import com.ibm.ws.jpa.container.osgi.internal.url.WSJPAUrlUtils;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPAPXml;
import com.ibm.ws.jpa.management.JPAPuScope;
import com.ibm.ws.jpa.management.JPAScopeInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.ClassTransformer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OSGiJPAPUnitInfo
extends JPAPUnitInfo
implements ClassTransformer {
    private static final TraceComponent tc = Tr.register(OSGiJPAPUnitInfo.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private static boolean disableWsJpaUrlProcessing = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
        static final long serialVersionUID = 7636302199370575086L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.ibm.websphere.persistence.DisableJpaFormatUrlProtocol");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
        }
    });
    private static final String ECLIPSELINK_TARGET_SERVER = "WebSphere_Liberty";
    private final JPAScopeInfo scopeInfo;
    static final long serialVersionUID = -898488667409903028L;

    /*
     * WARNING - void declaration
     */
    private static URL convertURLToJPAURL(URL url) {
        URL returnURL;
        block8: {
            String urlStr;
            returnURL = url;
            if (url != null && (urlStr = url.toString()) != null && urlStr.startsWith("wsjar:file:")) {
                try {
                    if (disableWsJpaUrlProcessing) {
                        urlStr = urlStr.substring(2);
                        returnURL = new URL(urlStr);
                        break block8;
                    }
                    try {
                        returnURL = WSJPAUrlUtils.createWSJPAURL(url);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.jpa.container.osgi.internal.OSGiJPAPUnitInfo", (String)"67", null, (Object[])new Object[]{url});
                        urlStr = urlStr.substring(2);
                        returnURL = new URL(urlStr);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"OSGiJPAPUnitInfo.convertURLToJPAURL() failed, falling back to URL", (Object[])new Object[]{returnURL});
                        }
                    }
                }
                catch (MalformedURLException iae) {
                    void e;
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.jpa.container.osgi.internal.OSGiJPAPUnitInfo", (String)"76", null, (Object[])new Object[]{url});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"Failed to convert URL.", (Object[])new Object[]{e});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OSGiJPAPUnitInfo.convertURLToJPAURL() converted URL (old,new)", (Object[])new Object[]{url, returnURL});
        }
        return returnURL;
    }

    OSGiJPAPUnitInfo(OSGiJPAApplInfo applInfo, JPAPuId puId, ClassLoader classLoader, JPAScopeInfo scopeInfo) {
        super(applInfo, puId, classLoader);
        this.scopeInfo = scopeInfo;
    }

    @Override
    protected void setPersistenceUnitRootUrl(URL newValue) {
        super.setPersistenceUnitRootUrl(OSGiJPAPUnitInfo.convertURLToJPAURL(newValue));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean addJarFileUrls(String jarPath, JPAPXml xml) {
        OSGiJPAPXml osgiPXml = (OSGiJPAPXml)xml;
        Container puBase = osgiPXml.getPuRootContainer();
        if (this.scopeInfo.getScopeType() == JPAPuScope.Web_Scope) {
            OSGiJPAApplInfo osgiApplInfo;
            String puRootURLString = this.getPersistenceUnitRootUrl().toExternalForm();
            if (puRootURLString.endsWith("/WEB-INF/classes/")) {
                if (jarPath.startsWith("../../")) {
                    osgiApplInfo = (OSGiJPAApplInfo)this.ivApplInfo;
                    puBase = osgiApplInfo.getContainer();
                    jarPath = jarPath.substring(6);
                } else {
                    puBase = this.getContainerLocation(puBase, "WEB-INF");
                }
            } else if (puRootURLString.contains("/WEB-INF/lib/")) {
                if (jarPath.startsWith("../../../")) {
                    osgiApplInfo = (OSGiJPAApplInfo)this.ivApplInfo;
                    puBase = osgiApplInfo.getContainer();
                    jarPath = jarPath.substring(9);
                } else {
                    puBase = this.getContainerRootParent(puBase);
                }
            }
        } else {
            puBase = this.getContainerRootParent(puBase);
        }
        Entry path = puBase.getEntry(jarPath);
        if (path == null) {
            return false;
        }
        Container jarContainer = null;
        try {
            jarContainer = (Container)path.adapt(Container.class);
            this.addContainerUrls(jarContainer);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jpa.container.osgi.internal.OSGiJPAPUnitInfo", (String)"202", (Object)this, (Object[])new Object[]{jarPath, xml});
            e.getClass();
            return false;
        }
        return true;
    }

    private Container getContainerLocation(Container base, String location) {
        Container puBase;
        for (puBase = base; puBase != null && !location.equals(puBase.getName()); puBase = puBase.getEnclosingContainer()) {
        }
        return puBase;
    }

    private Container getContainerRootParent(Container base) {
        Container parent;
        Container puBase;
        for (puBase = base.getEnclosingContainer(); puBase != null && !puBase.isRoot(); puBase = puBase.getEnclosingContainer()) {
        }
        if (puBase != null && puBase.isRoot() && (parent = puBase.getEnclosingContainer()) != null) {
            puBase = parent;
        }
        return puBase;
    }

    private void addContainerUrls(Container container) throws MalformedURLException {
        if (container != null) {
            for (URL cUrl : container.getURLs()) {
                this.addJarFileUrl(OSGiJPAPUnitInfo.convertURLToJPAURL(cUrl));
            }
        }
    }

    @Override
    protected boolean registerClassFileTransformer(ClassLoader classLoader) {
        ClassLoadingService service;
        boolean transformerRegistered = false;
        BundleContext ctx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference reference = ctx.getServiceReference(ClassLoadingService.class);
        if (reference != null && (service = (ClassLoadingService)ctx.getService(reference)) != null) {
            transformerRegistered = service.registerTransformer((ClassTransformer)this, classLoader);
            ctx.ungetService(reference);
        }
        return transformerRegistered;
    }

    @Override
    protected void unregisterClassFileTransformer(ClassLoader classLoader) {
        ClassLoadingService service;
        BundleContext ctx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference reference = ctx.getServiceReference(ClassLoadingService.class);
        if (reference != null && (service = (ClassLoadingService)ctx.getService(reference)) != null) {
            boolean transformerUnregistered = service.unregisterTransformer((ClassTransformer)this, classLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && transformerUnregistered) {
                Tr.debug((TraceComponent)tc, (String)("transformer unregistered from " + this.ivClassLoader), (Object[])new Object[0]);
            }
            ctx.ungetService(reference);
        }
    }

    @Override
    protected ClassLoader createTempClassLoader(ClassLoader classLoader) {
        ClassLoadingService service;
        BundleContext ctx = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference reference = ctx.getServiceReference(ClassLoadingService.class);
        if (reference != null && (service = (ClassLoadingService)ctx.getService(reference)) != null) {
            ClassLoader loader = service.getShadowClassLoader(classLoader);
            ctx.ungetService(reference);
            return loader;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getNewTempClassLoader : Could not get a service reference for the classloading service.", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    protected DataSource lookupDataSource(String dsName) throws NamingException {
        return (DataSource)new InitialContext().lookup(dsName);
    }

    protected String getEclipseLinkTargetServer() {
        return ECLIPSELINK_TARGET_SERVER;
    }
}

