/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.j2c.CommonFunction;
import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.MCWrapperList;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.j2c.ThreadSupportedCleanupAndDestroy;
import com.ibm.websphere.ce.j2c.ConnectionWaitTimeoutException;
import com.ibm.websphere.jca.pmi.JCAPMIHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.adapter.WSManagedConnection;
import com.ibm.ws.jca.cm.JcaServiceUtilities;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAllocationException;
import javax.security.auth.Subject;

public final class FreePool
implements JCAPMIHelper {
    private static final TraceComponent tc = Tr.register(FreePool.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    protected final MCWrapperList mcWrapperList;
    private final String nl = CommonFunction.nl;
    protected final Integer freeConnectionLockObject = new Integer(0);
    private PoolManager pm = null;
    protected int numberOfConnectionsInFreePool = 0;
    protected int numberOfConnectionsAssignedToThisFreePool = 0;
    ClassLoader raClassLoader;
    private int fatalErrorNotificationTime = 0;
    private static final boolean _mcWrapperDoesNotExistInFreePool = false;
    private static final boolean _synchronizeInMethod = true;
    private static final boolean _notifyWaiter = false;
    private static final boolean _decrementTotalCounter = true;
    protected int fop_gets = 0;
    protected int fnop_gets = 0;
    protected int freePoolQueuedRequests = 0;
    protected int freePoolCreateManagedConnection = 0;
    protected int numberOfClaimedVictims = 0;
    protected int numberOfClaimedVictims_CRI_Only_Mismatch = 0;
    protected int numberOfClaimedVictims_Subject_Only_Mismatch = 0;
    protected int numberOfClaimedVictims_CRI_Subject_Mismatch = 0;
    protected int numberOfClaimedVictims_MM_Only_Mismatch = 0;
    protected int fop_get_notfound = 0;
    protected int fnop_get_notfound = 0;
    private J2CGlobalConfigProperties gConfigProps = null;

    public FreePool(int initialSize, PoolManager poolManager, J2CGlobalConfigProperties gConfigProps, ClassLoader raClassLoader) {
        if (initialSize < 1) {
            initialSize = 100;
        } else if (initialSize > 500) {
            initialSize = 500;
        }
        this.mcWrapperList = new MCWrapperList(initialSize);
        this.pm = poolManager;
        this.gConfigProps = gConfigProps;
        this.raClassLoader = raClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRequest(ManagedConnectionFactory managedConnectionFactory, long waitTimeout) throws ResourceAllocationException, ConnectionWaitTimeoutException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"queueRequest", (Object[])new Object[]{waitTimeout});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Current connection pool", (Object[])new Object[]{this.pm.toString()});
        }
        if (waitTimeout == 0L) {
            --this.pm.waiterCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Timeout.  Decremented waiterCount, which is now " + this.pm.waiterCount + " on datasource " + this.gConfigProps.cfName), (Object[])new Object[0]);
            }
            Object[] connWaitTimeoutparms = new Object[]{"queueRequest", this.gConfigProps.cfName, 0, this.pm.waiterCount, this.pm.totalConnectionCount.get()};
            Tr.error((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0001_J2CA0045", (Object[])connWaitTimeoutparms);
            String connWaitTimeoutMessage = Tr.formatMessage((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0001_J2CA0045", (Object[])connWaitTimeoutparms);
            ConnectionWaitTimeoutException cwte = new ConnectionWaitTimeoutException(connWaitTimeoutMessage);
            FFDCFilter.processException((Throwable)((Object)cwte), (String)"Max connections reached", (String)"192", (Object)this.pm);
            this.pm.activeRequest.decrementAndGet();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"queueRequest", (Object)((Object)cwte));
            }
            throw cwte;
        }
        if (tc.isDebugEnabled()) {
            ++this.freePoolQueuedRequests;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String poolStats = this.pm.gatherPoolStatisticalData();
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Queueing Waiter for pool <" + this.gConfigProps.getXpathId() + ">. Current Pool Stats are:"), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)poolStats, (Object[])new Object[0]);
            }
        }
        try {
            if (this.pm.displayInfiniteWaitMessage) {
                Tr.info((TraceComponent)tc, (String)"INFINITE_CONNECTION_WAIT_TIMEOUT_J2CA0127", (Object[])new Object[]{this.gConfigProps.getXpathId()});
                this.pm.displayInfiniteWaitMessage = false;
            }
            this.pm.activeRequest.decrementAndGet();
            if (waitTimeout < 0L) {
                this.pm.waiterFreePoolLock.wait(0L);
            } else {
                this.pm.waiterFreePoolLock.wait(waitTimeout);
            }
            this.pm.requestingAccessToPool();
        }
        catch (InterruptedException ie) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Interupted waiting for a connection", (Object[])new Object[0]);
            }
            Integer connWaitTimeoutMessage = this.pm.waiterFreePoolLock;
            synchronized (connWaitTimeoutMessage) {
                --this.pm.waiterCount;
            }
            if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                this.pm.waitersEndedTime = System.currentTimeMillis();
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime)), (Object[])new Object[0]);
            }
            ResourceAllocationException throwMe = new ResourceAllocationException(ie.getMessage());
            throwMe.initCause((Throwable)ie);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"queueRequest", (Object)throwMe);
            }
            throw throwMe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"queueRequest");
        }
    }

    protected void returnToFreePool(com.ibm.ws.j2c.MCWrapper mcWrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"returnToFreePool", (Object[])new Object[]{this.gConfigProps.cfName});
        }
        if (mcWrapper.shouldBeDestroyed() || mcWrapper.hasFatalErrorNotificationOccurred(this.fatalErrorNotificationTime) || this.pm.agedTimeout != -1 && mcWrapper.hasAgedTimedOut(this.pm.agedTimeoutMillis)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (mcWrapper.shouldBeDestroyed()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection destroy flag is set, removing connection " + mcWrapper), (Object[])new Object[0]);
                }
                if (mcWrapper.hasFatalErrorNotificationOccurred(this.fatalErrorNotificationTime)) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Fatal error occurred, removing connection " + mcWrapper), (Object[])new Object[0]);
                }
                if (this.pm.agedTimeout != -1 && mcWrapper.hasAgedTimedOut(this.pm.agedTimeoutMillis)) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Aged timeout exceeded, removing connection " + mcWrapper), (Object[])new Object[0]);
                }
                if (mcWrapper.isDestroyState()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Mbean method purgePoolContents with option immediate was used.  Connection cleanup and destroy is being processed.", (Object[])new Object[0]);
                }
            }
            if (mcWrapper.isDestroyState()) {
                FreePool tempFP = this;
                com.ibm.ws.j2c.MCWrapper tempMCWrapper = mcWrapper;
                ThreadSupportedCleanupAndDestroy tscd = new ThreadSupportedCleanupAndDestroy(this.pm.tscdList, tempFP, tempMCWrapper);
                this.pm.tscdList.add(tscd);
                ((ExecutorService)this.pm.connectorSvc.execSvcRef.getServiceWithException()).submit(tscd);
            } else {
                this.cleanupAndDestroyMCWrapper(mcWrapper);
                this.removeMCWrapperFromList(mcWrapper, false, true, false, true);
            }
        } else {
            this.returnToFreePoolDelegated(mcWrapper);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"returnToFreePool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnToFreePoolDelegated(com.ibm.ws.j2c.MCWrapper mcWrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"returnToFreePoolDelegated", (Object[])new Object[]{this.gConfigProps.cfName});
        }
        try {
            mcWrapper.cleanup();
        }
        catch (Exception exn1) {
            String localMessage = exn1.getLocalizedMessage();
            if (localMessage != null && localMessage.equals("Skip logging for this failing connection")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Connection failed, resource adapter requested skipping failure logging", (Object[])new Object[0]);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("MCWrapper cleanup failed, datasource: " + this.gConfigProps.cfName), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)exn1, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.returnToFreePool", (String)"190", (Object)this);
            }
            try {
                this.pm.removeMcToMCWMap(mcWrapper.getManagedConnectionWithoutStateCheck());
                mcWrapper.destroy();
            }
            catch (Exception exn2) {
                FFDCFilter.processException((Throwable)exn2, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.returnToFreePool", (String)"210", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("datasource " + this.gConfigProps.cfName + ": ResourceException"), (Object[])new Object[]{exn2});
                }
            }
            finally {
                Integer n = this.pm.waiterFreePoolLock;
                synchronized (n) {
                    this.pm.totalConnectionCount.decrementAndGet();
                    if (this.pm.waiterCount > 0) {
                        this.pm.waiterFreePoolLock.notify();
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"returnToFreePoolDelegated", (Object)exn1);
            }
            return;
        }
        Integer n = this.pm.waiterFreePoolLock;
        synchronized (n) {
            if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                this.pm.mcWrapperWaiterList.add(mcWrapper);
                mcWrapper.setPoolState(4);
                this.pm.waiterFreePoolLock.notify();
            } else {
                Integer n2 = this.freeConnectionLockObject;
                synchronized (n2) {
                    this.mcWrapperList.add(mcWrapper);
                    mcWrapper.setPoolState(1);
                }
            }
            ((MCWrapper)mcWrapper).setAlreadyBeingReleased(false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"returnToFreePoolDelegated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMCWrapperFromList(com.ibm.ws.j2c.MCWrapper mcWrapper, boolean removeFromFreePool, boolean synchronizationNeeded, boolean skipWaiterNotify, boolean decrementTotalCounter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeMCWrapperFromList", (Object[])new Object[0]);
        }
        if (synchronizationNeeded) {
            Integer n = this.pm.waiterFreePoolLock;
            synchronized (n) {
                Integer n2 = this.freeConnectionLockObject;
                synchronized (n2) {
                    if (removeFromFreePool) {
                        this.mcWrapperList.remove(mcWrapper);
                        mcWrapper.setPoolState(0);
                    }
                    --this.numberOfConnectionsAssignedToThisFreePool;
                    if (decrementTotalCounter) {
                        this.pm.totalConnectionCount.decrementAndGet();
                    }
                    if (!skipWaiterNotify) {
                        this.pm.waiterFreePoolLock.notify();
                    }
                }
            }
        }
        if (removeFromFreePool) {
            this.mcWrapperList.remove(mcWrapper);
            mcWrapper.setPoolState(0);
            --this.numberOfConnectionsAssignedToThisFreePool;
        }
        if (decrementTotalCounter) {
            this.pm.totalConnectionCount.decrementAndGet();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeMCWrapperFromList");
        }
    }

    protected boolean cleanupAndDestroyMCWrapper(com.ibm.ws.j2c.MCWrapper mcWrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"cleanupAndDestroyMCWrapper", (Object[])new Object[0]);
        }
        boolean errorOccurred = false;
        this.pm.removeMcToMCWMap(mcWrapper.getManagedConnectionWithoutStateCheck());
        try {
            mcWrapper.cleanup();
        }
        catch (Exception exn1) {
            errorOccurred = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("MCWrapper cleanup failed, datasource: " + this.gConfigProps.cfName), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)exn1, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.cleanupAndDestroyMCWrapper", (String)"1140", (Object)this);
        }
        try {
            mcWrapper.destroy();
        }
        catch (Exception exn2) {
            errorOccurred = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("MCWrapper destroy failed, datasource: " + this.gConfigProps.cfName), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)exn2, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.cleanupAndDestroyMCWrapper", (String)"300", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"cleanupAndDestroyMCWrapper");
        }
        return errorOccurred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeParkedConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeParkedConnection", (Object[])new Object[0]);
        }
        if (this.pm.parkedMCWrapper != null) {
            Integer n = this.pm.parkedConnectionLockObject;
            synchronized (n) {
                if (this.pm.parkedMCWrapper != null) {
                    this.cleanupAndDestroyMCWrapper(this.pm.parkedMCWrapper);
                    this.pm.parkedMCWrapper = null;
                    this.pm.createParkedConnection = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Reset the createParkedConnection flag to recreate a new parked connection", (Object[])new Object[0]);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeParkedConnection");
        }
    }

    protected int getTotalConnectionCount() {
        return this.pm.totalConnectionCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.ibm.ws.j2c.MCWrapper getFreeConnection(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo cri, int hashCode) throws ResourceAllocationException {
        boolean isTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getFreeConnection", (Object[])new Object[]{this.gConfigProps.cfName});
        }
        com.ibm.ws.j2c.MCWrapper mcWrapper = null;
        com.ibm.ws.j2c.MCWrapper mcWrapperTemp1 = null;
        com.ibm.ws.j2c.MCWrapper mcWrapperTemp2 = null;
        int mcwlSize = 0;
        int mcwlIndex = 0;
        Integer n = this.freeConnectionLockObject;
        synchronized (n) {
            mcwlSize = this.mcWrapperList.size();
            if (mcwlSize > 0) {
                mcwlIndex = mcwlSize - 1;
                mcWrapperTemp1 = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.remove(mcwlIndex);
                mcWrapperTemp1.setPoolState(0);
            }
        }
        if (mcWrapperTemp1 != null) {
            Integer n2;
            if (hashCode == mcWrapperTemp1.getSubjectCRIHashCode()) {
                mcWrapper = this.getMCWrapperFromMatch(subject, cri, managedConnectionFactory, mcWrapperTemp1);
                if (((MCWrapper)mcWrapperTemp1).do_not_reuse_mcw) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection error occurred for this mcw " + mcWrapperTemp1 + ", mcw will not be reuse"), (Object[])new Object[0]);
                    }
                    n = this.pm.waiterFreePoolLock;
                    synchronized (n) {
                        this.cleanupAndDestroyMCWrapper(mcWrapperTemp1);
                        n2 = this.freeConnectionLockObject;
                        synchronized (n2) {
                            --this.numberOfConnectionsAssignedToThisFreePool;
                        }
                        this.pm.totalConnectionCount.decrementAndGet();
                        if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                            this.pm.waiterFreePoolLock.notify();
                        }
                    }
                }
            }
            if (mcWrapper == null) {
                n = this.pm.waiterFreePoolLock;
                synchronized (n) {
                    n2 = this.freeConnectionLockObject;
                    synchronized (n2) {
                        mcwlSize = this.mcWrapperList.size();
                        if (mcwlSize > 0) {
                            for (int i = mcwlIndex = mcwlSize - 1; i >= 0; --i) {
                                mcWrapperTemp2 = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.get(i);
                                if (hashCode == mcWrapperTemp2.getSubjectCRIHashCode()) {
                                    mcWrapper = this.getMCWrapperFromMatch(subject, cri, managedConnectionFactory, mcWrapperTemp2);
                                    if (((MCWrapper)mcWrapperTemp2).do_not_reuse_mcw) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection error occurred for this mcw " + mcWrapperTemp2 + ", mcw will not be reuse"), (Object[])new Object[0]);
                                        }
                                        this.mcWrapperList.remove(i);
                                        this.cleanupAndDestroyMCWrapper(mcWrapperTemp2);
                                        Integer n3 = this.freeConnectionLockObject;
                                        synchronized (n3) {
                                            --this.numberOfConnectionsAssignedToThisFreePool;
                                        }
                                        this.pm.totalConnectionCount.decrementAndGet();
                                        if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                                            this.pm.waiterFreePoolLock.notify();
                                        }
                                    }
                                }
                                if (mcWrapper == null) continue;
                                this.mcWrapperList.remove(i);
                                mcWrapper.setPoolState(0);
                                break;
                            }
                        }
                    }
                    if (!((MCWrapper)mcWrapperTemp1).do_not_reuse_mcw) {
                        if (this.pm.waiterCount > 0 && this.pm.waiterCount > this.pm.mcWrapperWaiterList.size()) {
                            this.pm.mcWrapperWaiterList.add(mcWrapperTemp1);
                            this.pm.waiterFreePoolLock.notify();
                        } else {
                            n2 = this.freeConnectionLockObject;
                            synchronized (n2) {
                                this.mcWrapperList.add(mcWrapperTemp1);
                                mcWrapperTemp1.setPoolState(1);
                            }
                        }
                    }
                    if (isTracingEnabled && tc.isDebugEnabled() && mcWrapper != null) {
                        ++this.fnop_gets;
                    }
                }
            }
            if (isTracingEnabled && tc.isDebugEnabled()) {
                ++this.fop_gets;
            }
        }
        if (isTracingEnabled && tc.isDebugEnabled() && mcWrapper == null) {
            ++this.fnop_get_notfound;
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            if (isTracingEnabled && tc.isDebugEnabled()) {
                if (mcWrapper != null) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Returning mcWrapper " + mcWrapper), (Object[])new Object[0]);
                } else {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"MCWrapper was not found in Free Pool", (Object[])new Object[0]);
                }
            }
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getFreeConnection");
        }
        return mcWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected com.ibm.ws.j2c.MCWrapper createOrWaitForConnection(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo cri, int hashMapBucket, int maxFreePoolHashSize, boolean createAConnection, boolean connectionSharing, int hashCode) throws ResourceAllocationException, ConnectionWaitTimeoutException {
        com.ibm.ws.j2c.MCWrapper mcWrapper;
        block72: {
            long waitTimeout;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"createOrWaitForConnection", (Object[])new Object[0]);
            }
            mcWrapper = null;
            boolean addingAConnection = false;
            if (!createAConnection) {
                if (this.pm.maxConnections == 0 || this.pm.totalConnectionCount.get() < this.pm.maxConnections) {
                    Integer n = this.pm.pmCounterLock;
                    // MONITORENTER : n
                    if (this.pm.totalConnectionCount.get() < this.pm.maxConnections || this.pm.maxConnections == 0) {
                        this.pm.totalConnectionCount.incrementAndGet();
                        addingAConnection = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("TotalConnectionCount is " + this.pm.totalConnectionCount.get()), (Object[])new Object[0]);
                        }
                    }
                    // MONITOREXIT : n
                }
            } else {
                addingAConnection = true;
            }
            long waitStartTime = 0L;
            long waitEndTime = 0L;
            if (addingAConnection) break block72;
            long orig_waitTimeout = waitTimeout = (long)(this.pm.connectionTimeout * 1000);
            long totalTimeWaited = 0L;
            this.pm.activeRequest.decrementAndGet();
            Integer n = this.pm.waiterFreePoolLock;
            // MONITORENTER : n
            this.pm.requestingAccessToPool();
            while (true) {
                block73: {
                    block74: {
                        com.ibm.ws.j2c.MCWrapper mcWrapperTemp;
                        if (waitStartTime == 0L) {
                            mcWrapperTemp = null;
                            for (int j = 0; j < maxFreePoolHashSize; ++j) {
                                if (this.pm.freePool[j].mcWrapperList.size() <= 0) continue;
                                Integer n2 = this.pm.freePool[j].freeConnectionLockObject;
                                // MONITORENTER : n2
                                if (this.pm.freePool[j].mcWrapperList.size() > 0) {
                                    mcWrapperTemp = (com.ibm.ws.j2c.MCWrapper)this.pm.freePool[j].mcWrapperList.remove(0);
                                    mcWrapperTemp.setPoolState(0);
                                    mcWrapper = this.pm.freePool[j].getMCWrapperFromMatch(subject, cri, managedConnectionFactory, mcWrapperTemp);
                                    if (((MCWrapper)mcWrapperTemp).do_not_reuse_mcw && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection error occurred for this mcw " + mcWrapperTemp + ", mcw will not be reuse"), (Object[])new Object[0]);
                                    }
                                    if (mcWrapper == null) {
                                        ManagedConnection mc = mcWrapperTemp.getManagedConnection();
                                        if (this.gConfigProps.sendClaimedVictomToGetConnection && mc instanceof WSManagedConnection) {
                                            ((WSManagedConnection)mc).setClaimedVictim();
                                            mcWrapper = mcWrapperTemp;
                                        } else {
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Claiming victim " + mcWrapperTemp), (Object[])new Object[0]);
                                            }
                                            if (tc.isDebugEnabled()) {
                                                ++this.numberOfClaimedVictims;
                                                boolean subjectMismatch = false;
                                                boolean criMismatch = false;
                                                if (!cri.equals((Object)mcWrapperTemp.getCRI())) {
                                                    criMismatch = true;
                                                }
                                                Equals equalsHelper = new Equals();
                                                equalsHelper.setSubjects(subject, mcWrapperTemp.getSubject());
                                                if (!AccessController.doPrivileged(equalsHelper).booleanValue()) {
                                                    subjectMismatch = true;
                                                }
                                                if (criMismatch && subjectMismatch) {
                                                    ++this.numberOfClaimedVictims_CRI_Subject_Mismatch;
                                                } else if (criMismatch) {
                                                    ++this.numberOfClaimedVictims_CRI_Only_Mismatch;
                                                } else if (subjectMismatch) {
                                                    ++this.numberOfClaimedVictims_Subject_Only_Mismatch;
                                                } else {
                                                    ++this.numberOfClaimedVictims_MM_Only_Mismatch;
                                                }
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("A Victim has been claimed for connection pool: " + this.gConfigProps.cfName), (Object[])new Object[0]);
                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("  Total Victim count                                    =  " + Integer.toString(this.numberOfClaimedVictims)), (Object[])new Object[0]);
                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("    Victims due to both CRI and Subject Mismatch        =  " + Integer.toString(this.numberOfClaimedVictims_CRI_Subject_Mismatch)), (Object[])new Object[0]);
                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("    Victims due to CRI mismatch only                    =  " + Integer.toString(this.numberOfClaimedVictims_CRI_Only_Mismatch)), (Object[])new Object[0]);
                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("    Victims due to Subject mismatch only                =  " + Integer.toString(this.numberOfClaimedVictims_Subject_Only_Mismatch)), (Object[])new Object[0]);
                                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("    Victims due to failed matchManagedConnection() only =  " + Integer.toString(this.numberOfClaimedVictims_MM_Only_Mismatch)), (Object[])new Object[0]);
                                                }
                                            }
                                            this.pm.freePool[j].cleanupAndDestroyMCWrapper(mcWrapperTemp);
                                            --this.pm.freePool[j].numberOfConnectionsAssignedToThisFreePool;
                                        }
                                    }
                                    // MONITOREXIT : n2
                                    break;
                                }
                                // MONITOREXIT : n2
                            }
                            if (mcWrapperTemp != null || this.pm.isThreadLocalConnectionEnabled && waitTimeout != 0L && (mcWrapper = this.pm.searchTLSForMatchingConnection(managedConnectionFactory, subject, cri)) != null) break;
                            if (tc.isDebugEnabled()) {
                                if (this.pm.waiterCount == 0) {
                                    this.pm.waitersStartedTime = System.currentTimeMillis();
                                }
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: requests for connections are being queued. Start Time" + this.pm.waitersStartedTime), (Object[])new Object[0]);
                            }
                            ++this.pm.waiterCount;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("waitStartTime is zero.  waiterCount incremented to " + this.pm.waiterCount), (Object[])new Object[0]);
                            }
                            waitStartTime = System.currentTimeMillis();
                            this.queueRequest(managedConnectionFactory, waitTimeout);
                            waitEndTime = System.currentTimeMillis();
                        }
                        if (this.pm.mcWrapperWaiterList.size() <= 0) break block73;
                        mcWrapper = this.pm.getFreeWaiterConnection(managedConnectionFactory, subject, cri);
                        if (mcWrapper != null) break block74;
                        mcWrapperTemp = (com.ibm.ws.j2c.MCWrapper)this.pm.mcWrapperWaiterList.remove(0);
                        if (this.gConfigProps.sendClaimedVictomToGetConnection) {
                            ((WSManagedConnection)mcWrapperTemp.getManagedConnection()).setClaimedVictim();
                            mcWrapper = mcWrapperTemp;
                            break block73;
                        } else {
                            if (tc.isDebugEnabled()) {
                                ++this.numberOfClaimedVictims;
                                boolean subjectMismatch = false;
                                boolean criMismatch = false;
                                if (cri != null) {
                                    if (!cri.equals((Object)mcWrapperTemp.getCRI())) {
                                        criMismatch = true;
                                    }
                                } else if (mcWrapperTemp.getCRI() != null) {
                                    criMismatch = true;
                                }
                                Subject tempSubject = mcWrapperTemp.getSubject();
                                if (subject != null && tempSubject != null) {
                                    Equals equalsHelper = new Equals();
                                    equalsHelper.setSubjects(subject, tempSubject);
                                    if (!AccessController.doPrivileged(equalsHelper).booleanValue()) {
                                        subjectMismatch = true;
                                    }
                                } else if (subject != null || tempSubject != null) {
                                    subjectMismatch = true;
                                }
                                if (criMismatch && subjectMismatch) {
                                    ++this.numberOfClaimedVictims_CRI_Subject_Mismatch;
                                } else if (criMismatch) {
                                    ++this.numberOfClaimedVictims_CRI_Only_Mismatch;
                                } else if (subjectMismatch) {
                                    ++this.numberOfClaimedVictims_Subject_Only_Mismatch;
                                } else {
                                    ++this.numberOfClaimedVictims_MM_Only_Mismatch;
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)this.pm.gatherClaimVictimStatisticalData(), (Object[])new Object[0]);
                                }
                            }
                            mcWrapperTemp.setPoolState(0);
                            this.cleanupAndDestroyMCWrapper(mcWrapperTemp);
                            --this.pm.waiterCount;
                            if (!tc.isDebugEnabled() || this.pm.waiterCount != 0) break;
                            this.pm.waitersEndedTime = System.currentTimeMillis();
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime), (Object[])new Object[0]);
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime)), (Object[])new Object[0]);
                            break;
                        }
                    }
                    if (((MCWrapper)mcWrapper).do_not_reuse_mcw) {
                        mcWrapper = null;
                        --this.pm.waiterCount;
                        if (!tc.isDebugEnabled()) break;
                        if (this.pm.waiterCount == 0) {
                            this.pm.waitersEndedTime = System.currentTimeMillis();
                        }
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime), (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime)), (Object[])new Object[0]);
                        break;
                    }
                }
                if (mcWrapper != null) {
                    --this.pm.waiterCount;
                    if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                        this.pm.waitersEndedTime = System.currentTimeMillis();
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime), (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime)), (Object[])new Object[0]);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    long diff = waitEndTime - waitStartTime;
                    Tr.debug((TraceComponent)tc, (String)("Time waited was " + diff + " (milliseconds).  waiterCount decremented to " + this.pm.waiterCount), (Object[])new Object[0]);
                    break;
                }
                Integer diff = this.pm.pmCounterLock;
                // MONITORENTER : diff
                if (this.pm.totalConnectionCount.get() < this.pm.maxConnections) {
                    this.pm.totalConnectionCount.incrementAndGet();
                    addingAConnection = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Total connection count is " + this.pm.totalConnectionCount.get()), (Object[])new Object[0]);
                    }
                }
                // MONITOREXIT : diff
                if (addingAConnection) {
                    --this.pm.waiterCount;
                    if (!tc.isDebugEnabled() || this.pm.waiterCount != 0) break;
                    this.pm.waitersEndedTime = System.currentTimeMillis();
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime), (Object[])new Object[0]);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime)), (Object[])new Object[0]);
                    break;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"We didn't find or are not going to create a connection.", (Object[])new Object[0]);
                }
                if (waitStartTime == 0L) continue;
                long reloadedTime = this.pm.connectionTimeout * 1000;
                if (orig_waitTimeout != reloadedTime) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Changing connection timeout value from " + orig_waitTimeout + " to " + reloadedTime + " the (orig_waitTimeout - reloeadedTime) is " + (reloadedTime - orig_waitTimeout) + " waitTimeout + (orig_waitTimeout - reloeadedTime) is " + (waitTimeout + (reloadedTime - orig_waitTimeout))), (Object[])new Object[0]);
                    }
                    waitTimeout += reloadedTime - orig_waitTimeout;
                    orig_waitTimeout = reloadedTime;
                }
                long kludge = 10L;
                long timeWaited = waitEndTime - waitStartTime;
                totalTimeWaited += timeWaited;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("waitStartTime is " + waitStartTime + " and timeWaited is " + timeWaited + " waitTimeout is " + waitTimeout + " total time waited is " + totalTimeWaited), (Object[])new Object[0]);
                }
                if (waitTimeout - timeWaited <= kludge) {
                    --this.pm.waiterCount;
                    if (tc.isDebugEnabled() && this.pm.waiterCount == 0) {
                        this.pm.waitersEndedTime = System.currentTimeMillis();
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: requests for connections are no longer being queued. End Time:" + this.pm.waitersEndedTime), (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Waiters: total time waiter were in queue: " + (this.pm.waitersEndedTime - this.pm.waitersStartedTime)), (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Timeout.  Decremented waiterCount, which is now " + this.pm.waiterCount + " on datasource " + this.gConfigProps.cfName), (Object[])new Object[0]);
                    }
                    Object[] connWaitTimeoutparms = new Object[]{"createOrWaitForConnection", this.gConfigProps.cfName, totalTimeWaited, this.pm.waiterCount, this.pm.totalConnectionCount.get()};
                    Tr.error((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0001_J2CA0045", (Object[])connWaitTimeoutparms);
                    String connWaitTimeoutMessage = Tr.formatMessage((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0001_J2CA0045", (Object[])connWaitTimeoutparms);
                    ConnectionWaitTimeoutException cwte = new ConnectionWaitTimeoutException(connWaitTimeoutMessage);
                    FFDCFilter.processException((Throwable)((Object)cwte), (String)"Max connections reached", (String)"869", (Object)this.pm);
                    this.pm.activeRequest.decrementAndGet();
                    if (!TraceComponent.isAnyTracingEnabled()) throw cwte;
                    if (!tc.isEntryEnabled()) throw cwte;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"createOrWaitForConnection", (Object)((Object)cwte));
                    throw cwte;
                }
                waitTimeout -= waitEndTime - waitStartTime;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("not finished waiting yet.  New waitTimeout is " + waitTimeout), (Object[])new Object[0]);
                }
                waitStartTime = System.currentTimeMillis();
                this.queueRequest(managedConnectionFactory, waitTimeout);
                waitEndTime = System.currentTimeMillis();
            }
            // MONITOREXIT : n
        }
        if (mcWrapper == null) {
            mcWrapper = this.createManagedConnectionWithMCWrapper(managedConnectionFactory, subject, cri, connectionSharing, hashCode);
            if (mcWrapper == null) {
                Tr.error((TraceComponent)tc, (String)"FREEPOOL_GETFREECONNECTION_ERROR_J2CA1002", (Object[])new Object[]{mcWrapper, this.gConfigProps.cfName});
                ResourceAllocationException re = new ResourceAllocationException("getFreeConnection: MCWrapper is null.");
                FFDCFilter.processException((Throwable)re, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.createOrWaitForConnection", (String)"674", (Object[])new Object[]{this, this.pm});
                this.pm.activeRequest.decrementAndGet();
                throw re;
            }
            mcWrapper.setHashMapBucket(hashMapBucket);
            mcWrapper.setMCWrapperList(this.mcWrapperList);
            ++this.numberOfConnectionsAssignedToThisFreePool;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Returning mcWrapper", (Object[])new Object[0]);
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return mcWrapper;
        if (!tc.isEntryEnabled()) return mcWrapper;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"createOrWaitForConnection", (Object)mcWrapper);
        return mcWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.ibm.ws.j2c.MCWrapper getMCWrapperFromMatch(Subject subject, ConnectionRequestInfo cri, ManagedConnectionFactory managedFactory, com.ibm.ws.j2c.MCWrapper mcWrapperTemp) throws ResourceAllocationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMCWrapperFromMatch", (Object[])new Object[]{mcWrapperTemp});
        }
        com.ibm.ws.j2c.MCWrapper mcWrapper = null;
        ManagedConnection mc = null;
        HashSet<ManagedConnection> freePoolMCSet = new HashSet<ManagedConnection>(1);
        try {
            freePoolMCSet.add(mcWrapperTemp.getManagedConnection());
        }
        catch (IllegalStateException e) {
            Integer n = this.freeConnectionLockObject;
            synchronized (n) {
                this.mcWrapperList.remove(mcWrapperTemp);
            }
            throw e;
        }
        try {
            int poolState = mcWrapperTemp.getPoolState();
            mcWrapperTemp.setPoolState(50);
            mc = managedFactory.matchManagedConnections(freePoolMCSet, subject, cri);
            mcWrapperTemp.setPoolState(poolState);
        }
        catch (ResourceException exn1) {
            FFDCFilter.processException((Throwable)exn1, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.getMCWrapperFromMatch", (String)"786", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("datasource " + this.gConfigProps.cfName + ": ResourceException " + (Object)((Object)exn1)), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Throwing ResourceAllocationException...", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("match(), Pool contents ==> " + this), (Object[])new Object[0]);
            }
            ResourceAllocationException throwMe = new ResourceAllocationException(exn1.getMessage(), exn1.getErrorCode());
            throwMe.initCause(exn1.getCause());
            this.pm.activeRequest.decrementAndGet();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMCWrapperFromMatch", (Object)throwMe);
            }
            throw throwMe;
        }
        if (mc != null) {
            mcWrapper = mcWrapperTemp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMCWrapperFromMatch", (Object)mcWrapper);
        }
        return mcWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.ibm.ws.j2c.MCWrapper createManagedConnectionWithMCWrapper(ManagedConnectionFactory managedConnectionFactory, Subject subject, ConnectionRequestInfo cri, boolean connectionSharing, int hashCode) throws ResourceAllocationException {
        MCWrapper mcWrapper;
        block53: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"createManagedConnectionWithMCWrapper", (Object[])new Object[0]);
            }
            ManagedConnection mc = null;
            mcWrapper = null;
            try {
                Object previousClassLoader;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"raClassLoader", (Object[])new Object[]{this.raClassLoader});
                }
                JcaServiceUtilities jcasu = new JcaServiceUtilities();
                if (this.raClassLoader == null) {
                    mc = managedConnectionFactory.createManagedConnection(subject, cri);
                } else {
                    previousClassLoader = jcasu.beginContextClassLoader(this.raClassLoader);
                    try {
                        mc = managedConnectionFactory.createManagedConnection(subject, cri);
                    }
                    finally {
                        jcasu.endContextClassLoader(this.raClassLoader, (ClassLoader)previousClassLoader);
                    }
                }
                mcWrapper = new MCWrapper(this.pm, this.gConfigProps);
                mcWrapper.setManagedConnection(mc);
                if (this.pm.gConfigProps.checkManagedConnectionInstanceof) {
                    previousClassLoader = this.pm.gConfigProps.checkManagedConnectionInstanceofLock;
                    synchronized (previousClassLoader) {
                        if (this.pm.gConfigProps.checkManagedConnectionInstanceof) {
                            HashSet<ManagedConnection> s = new HashSet<ManagedConnection>();
                            s.add(mc);
                            try {
                                int poolState = mcWrapper.getPoolState();
                                mcWrapper.setPoolState(50);
                                managedConnectionFactory.matchManagedConnections(s, subject, cri);
                                mcWrapper.setPoolState(poolState);
                            }
                            catch (NotSupportedException e) {
                                this.gConfigProps.setConnectionPoolingEnabled(false);
                            }
                            if (mc instanceof DissociatableManagedConnection) {
                                this.pm.gConfigProps.setSmartHandleSupport(true);
                                this.pm.createParkedConnection = false;
                                this.pm.gConfigProps.setInstanceOfDissociatableManagedConnection(true);
                            }
                            if (mc instanceof DissociatableManagedConnection) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Managed connection is an instance of DissociatableManagedConnection", (Object[])new Object[0]);
                                }
                                this.pm.gConfigProps.setInstanceOfDissociatableManagedConnection(true);
                            }
                            if (mc instanceof LazyEnlistableManagedConnection) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Managed connection is an instance of LazyEnlistableManagedConnection", (Object[])new Object[0]);
                                }
                                this.pm.gConfigProps.setDynamicEnlistmentSupported(true);
                            }
                            this.pm.writer = new TraceWriter(mc.getClass().getName());
                            this.pm.traceWriter = (TraceWriter)this.pm.writer;
                            this.pm.printWriter = new PrintWriter(this.pm.writer);
                            this.pm.gConfigProps.setCheckManagedConnectionInstanceof(false);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    ++this.freePoolCreateManagedConnection;
                }
                mcWrapper.setFatalErrorValue(this.fatalErrorNotificationTime + 1);
                mcWrapper.setSubjectCRIHashCode(hashCode);
                mcWrapper.setSubject(subject);
                mcWrapper.set_managedConnectionFactory(managedConnectionFactory);
                mcWrapper.setCRI(cri);
                mcWrapper.setSupportsReAuth(this.gConfigProps.raSupportsReauthentication);
                mcWrapper.setConnectionSynchronizationProvider(this.gConfigProps.connectionSynchronizationProvider);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"pm = ", (Object[])new Object[]{this.pm});
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"traceWriter = ", (Object[])new Object[]{this.pm.traceWriter});
                }
                if (this.pm.traceWriter.isTraceEnabled()) {
                    mc.setLogWriter(this.pm.printWriter);
                    mcWrapper.setLogWriterSet(true);
                }
                if (!this.gConfigProps.isConnectionPoolingEnabled() || this.pm.reapTime <= 0 || this.pm.alarmThreadCounter.get() != 0) break block53;
                previousClassLoader = this.pm.amLockObject;
                synchronized (previousClassLoader) {
                    if (this.pm.alarmThreadCounter.get() == 0) {
                        if (this.pm.agedTimeout < 1) {
                            if (this.pm.totalConnectionCount.get() > this.pm.minConnections) {
                                if (this.pm.nonDeferredReaperAlarm) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating non-deferrable alarm for reaper", (Object[])new Object[0]);
                                    }
                                    this.pm.alarmThreadCounter.incrementAndGet();
                                    try {
                                        this.pm.am = ((ScheduledExecutorService)this.pm.connectorSvc.nonDeferrableSchedXSvcRef.getServiceWithException()).schedule(this.pm, (long)this.pm.reapTime, TimeUnit.SECONDS);
                                    }
                                    catch (Exception e) {
                                        this.pm.alarmThreadCounter.decrementAndGet();
                                        throw e;
                                    }
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating deferrable alarm for reaper", (Object[])new Object[0]);
                                    }
                                    this.pm.alarmThreadCounter.incrementAndGet();
                                    try {
                                        this.pm.am = ((ScheduledExecutorService)this.pm.connectorSvc.deferrableSchedXSvcRef.getServiceWithException()).schedule(this.pm, (long)this.pm.reapTime, TimeUnit.SECONDS);
                                    }
                                    catch (Exception e) {
                                        this.pm.alarmThreadCounter.decrementAndGet();
                                        throw e;
                                    }
                                }
                            }
                        } else if (this.pm.totalConnectionCount.get() > 0) {
                            if (this.pm.nonDeferredReaperAlarm) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating non-deferrable alarm for reaper", (Object[])new Object[0]);
                                }
                                this.pm.alarmThreadCounter.incrementAndGet();
                                try {
                                    this.pm.am = ((ScheduledExecutorService)this.pm.connectorSvc.nonDeferrableSchedXSvcRef.getServiceWithException()).schedule(this.pm, (long)this.pm.reapTime, TimeUnit.SECONDS);
                                }
                                catch (Exception e) {
                                    this.pm.alarmThreadCounter.decrementAndGet();
                                    throw e;
                                }
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating deferrable alarm for reaper", (Object[])new Object[0]);
                            }
                            this.pm.alarmThreadCounter.incrementAndGet();
                            try {
                                this.pm.am = ((ScheduledExecutorService)this.pm.connectorSvc.deferrableSchedXSvcRef.getServiceWithException()).schedule(this.pm, (long)this.pm.reapTime, TimeUnit.SECONDS);
                            }
                            catch (Exception e) {
                                this.pm.alarmThreadCounter.decrementAndGet();
                                throw e;
                            }
                        }
                    }
                }
            }
            catch (ResourceException exn) {
                FFDCFilter.processException((Throwable)exn, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.createManagedConnectionWithMCWrapper", (String)"199", (Object)this);
                Object[] parms = new Object[]{"createManagedConnectionWithMCWrapper", CommonFunction.exceptionList(exn), "ResourceAllocationException", this.gConfigProps.cfName};
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", (Object[])parms);
                }
                ResourceAllocationException throwMe = new ResourceAllocationException(exn.getMessage(), exn.getErrorCode());
                throwMe.initCause(exn.getCause());
                this.pm.activeRequest.decrementAndGet();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"createManagedConnectionWithMCWrapper", (Object)throwMe);
                }
                throw throwMe;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.poolmanager.FreePool.createManagedConnectionWithMCWrapper", (String)"545", (Object)this);
                Object[] parms = new Object[]{"createManagedConnectionWithMCWrapper", CommonFunction.exceptionList(e), "ResourceAllocationException", this.gConfigProps.cfName};
                Tr.error((TraceComponent)tc, (String)"POOL_MANAGER_EXCP_CCF2_0002_J2CA0046", (Object[])parms);
                ResourceAllocationException throwMe = new ResourceAllocationException(e.getMessage());
                throwMe.initCause((Throwable)e);
                this.pm.activeRequest.decrementAndGet();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"createManagedConnectionWithMCWrapper", (Object)throwMe);
                }
                throw throwMe;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createManagedConnectionWithMCWrapper", (Object)mcWrapper);
        }
        return mcWrapper;
    }

    protected int getNumberOfConnectionInFreePool() {
        return this.mcWrapperList.size();
    }

    protected void removeCleanupAndDestroyAllFreeConnections() {
        int mcWrapperListIndex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"removeCleanupAndDestroyAllFreeConnections", (Object[])new Object[0]);
        }
        for (int i = mcWrapperListIndex = this.mcWrapperList.size() - 1; i >= 0; --i) {
            com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.remove(i);
            mcw.setPoolState(0);
            --this.numberOfConnectionsAssignedToThisFreePool;
            this.cleanupAndDestroyMCWrapper(mcw);
            this.pm.totalConnectionCount.decrementAndGet();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"removeCleanupAndDestroyAllFreeConnections");
        }
    }

    protected void nullPMref() {
        this.pm = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"FreePool nulled PM ref", (Object[])new Object[0]);
        }
    }

    protected void cleanupAndDestroyAllFreeConnections() {
        int mcWrapperListIndex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"cleanupAndDestroyAllFreeConnections", (Object[])new Object[0]);
        }
        for (int i = mcWrapperListIndex = this.mcWrapperList.size() - 1; i >= 0; --i) {
            com.ibm.ws.j2c.MCWrapper mcw = (com.ibm.ws.j2c.MCWrapper)this.mcWrapperList.remove(i);
            mcw.setPoolState(0);
            this.pm.totalConnectionCount.decrementAndGet();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Calling cleanup and destroy on MCWrapper " + mcw), (Object[])new Object[0]);
            }
            this.cleanupAndDestroyMCWrapper(mcw);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"cleanupAndDestroyAllFreeConnections");
        }
    }

    protected int getSize() {
        return this.mcWrapperList.size();
    }

    protected MCWrapperList getMCWrapperList() {
        return this.mcWrapperList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append("FreePool object:");
        aBuffer.append("  Number of connection in free pool: ");
        Integer n = this.freeConnectionLockObject;
        synchronized (n) {
            aBuffer.append(this.getNumberOfConnectionInFreePool());
            aBuffer.append(this.nl);
            aBuffer.append(this.mcWrapperList);
        }
        return aBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeMCWrapperFromList(com.ibm.ws.j2c.MCWrapper mcw) {
        Integer n = this.freeConnectionLockObject;
        synchronized (n) {
            boolean removed = this.mcWrapperList.remove(mcw);
            if (removed) {
                mcw.setPoolState(0);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementFatalErrorValue(int value1) {
        if (this.fatalErrorNotificationTime == 0x7FFFFFFE) {
            this.fatalErrorNotificationTime = 0;
            if (value1 == 0) {
                this.pm.mcToMCWMapWrite.lock();
                try {
                    Collection<com.ibm.ws.j2c.MCWrapper> mcWrappers = this.pm.mcToMCWMap.values();
                    for (com.ibm.ws.j2c.MCWrapper mcw : mcWrappers) {
                        if (mcw.isParkedWrapper()) continue;
                        mcw.setFatalErrorValue(0);
                    }
                }
                finally {
                    this.pm.mcToMCWMapWrite.unlock();
                }
            }
        } else {
            ++this.fatalErrorNotificationTime;
        }
    }

    protected int getFatalErrorNotificationTime() {
        return this.fatalErrorNotificationTime;
    }

    protected void setFatalErrorNotificationTime(int value) {
        this.fatalErrorNotificationTime = value;
    }

    @Override
    public String getUniqueId() {
        return this.gConfigProps.getXpathId();
    }

    @Override
    public boolean getParkedValue() {
        return false;
    }

    @Override
    public String getJNDIName() {
        return this.gConfigProps.getJNDIName();
    }

    static class Equals
    implements PrivilegedAction<Boolean> {
        Subject _s1;
        Subject _s2;

        Equals() {
        }

        public final void setSubjects(Subject s1, Subject s2) {
            this._s1 = s1;
            this._s2 = s2;
        }

        @Override
        public Boolean run() {
            boolean subjectsMatch = false;
            if (this.checkCredentials(this._s1.getPrivateCredentials(), this._s2.getPrivateCredentials())) {
                subjectsMatch = this.checkCredentials(this._s1.getPublicCredentials(), this._s2.getPublicCredentials());
            }
            return subjectsMatch;
        }

        private boolean checkCredentials(Set<Object> s1Credentials, Set<Object> s2Credentials) {
            boolean rVal = false;
            if (s1Credentials != s2Credentials) {
                if (s1Credentials != null && s2Credentials != null) {
                    int it2size;
                    int it1size = s1Credentials.size();
                    if (it1size == (it2size = s2Credentials.size())) {
                        if (it1size == 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Processing credential sets, both are empty, They are equal", (Object[])new Object[0]);
                            }
                            return true;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Processing credential sets, sets do not contain the same number of elements. They are not equal", (Object[])new Object[0]);
                        }
                        return false;
                    }
                    if (it1size > 1) {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        int objectsEqual = 0;
                        block0: while (it1.hasNext()) {
                            Object s1Cred = it1.next();
                            for (Object s2Cred : s2Credentials) {
                                if (s1Cred != null ? !s1Cred.equals(s2Cred) : s2Cred != null) continue;
                                ++objectsEqual;
                                continue block0;
                            }
                        }
                        if (objectsEqual == it1size) {
                            rVal = true;
                        }
                    } else {
                        Iterator<Object> it1 = s1Credentials.iterator();
                        Iterator<Object> it2 = s2Credentials.iterator();
                        Object s1Cred = it1.next();
                        Object s2Cred = it2.next();
                        if (s1Cred != null) {
                            if (!s1Cred.equals(s2Cred)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal", (Object[])new Object[0]);
                                }
                                return false;
                            }
                        } else if (s2Cred != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"PK69110 - Objects are not equal, one objest is null", (Object[])new Object[0]);
                            }
                            return false;
                        }
                        rVal = true;
                    }
                }
            } else {
                rVal = true;
            }
            return rVal;
        }
    }
}

