/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.helpers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationRecord;
import com.ibm.ws.jmx.connector.converter.NotificationTargetInformation;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationFilter;
import com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.helper.RESTRoutingHelper;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={MBeanRoutedNotificationHelper.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class MBeanRoutedNotificationHelper {
    private static final TraceComponent tc = Tr.register(MBeanRoutedNotificationHelper.class, null, null);
    private static final String KEY_ROUTING_HELPER = "routingHelper";
    private static final String KEY_EVENT_ADMIN = "eventAdmin";
    private static final String REGISTER_JMX_NOTIFICATION_LISTENER_TOPIC = "com/ibm/ws/management/repository/TargetClientManager/registerJmxNotificationListener";
    private static final String HANDLE_NOTIFICATION_TOPIC = "com/ibm/ws/management/repository/InboxManager/handleNotification";
    private static final String OPERATION_PROP = "operation";
    private static final String OPERATION_PROP_VALUE_ADD = "add";
    private static final String OPERATION_PROP_VALUE_REMOVE = "remove";
    private static final String OPERATION_PROP_VALUE_ADD_SERVER_NOTIFICATION = "addServerSideNotificationListener";
    private static final String OPERATION_PROP_VALUE_REMOVE_SERVER_NOTIFICATION = "removeServerSideNotificationListener";
    private static final String OBJECT_NAME_PROP = "objectName";
    private static final String LISTENER_OBJECT_NAME_PROP = "listenerObjectName";
    private static final String NOTIFICATION_FILTER_PROP = "filter";
    private static final String HANDBACK_OBJECT_PROP = "handback";
    private static final String NOTIFICATION_PROP = "notification";
    private final Map<NotificationTargetInformation, Set<ClientNotificationListener>> listenerMap = new HashMap<NotificationTargetInformation, Set<ClientNotificationListener>>();
    private final AtomicServiceReference<RESTRoutingHelper> routingHelperRef = new AtomicServiceReference("routingHelper");
    private final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    private final AtomicReference<ServiceRegistration<EventHandler>> eventHandlerServiceRegRef = new AtomicReference();
    private static ComponentContext componentContext;
    static final long serialVersionUID = -596986256835724034L;

    @Activate
    protected void activate(ComponentContext cc) {
        this.routingHelperRef.activate(cc);
        this.eventAdminRef.activate(cc);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.vendor", "IBM");
        ((Dictionary)props).put("event.topics", HANDLE_NOTIFICATION_TOPIC);
        BundleContext bc = cc.getBundleContext();
        ServiceRegistration eventHandlerServiceReg = bc.registerService(EventHandler.class, (Object)new NotificationEventHandler(), props);
        this.eventHandlerServiceRegRef.set((ServiceRegistration<EventHandler>)eventHandlerServiceReg);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getClass().getSimpleName() + " has been activated."), (Object[])new Object[0]);
        }
        componentContext = cc;
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(this.getClass().getSimpleName() + " has been deactivated."), (Object[])new Object[0]);
        }
        this.routingHelperRef.deactivate(cc);
        this.eventAdminRef.deactivate(cc);
        ServiceRegistration<EventHandler> eventHandlerServiceReg = this.eventHandlerServiceRegRef.get();
        if (eventHandlerServiceReg != null) {
            this.eventHandlerServiceRegRef.set(null);
            eventHandlerServiceReg.unregister();
        }
        componentContext = null;
    }

    @Reference(name="eventAdmin", service=EventAdmin.class)
    protected void setEventAdminRef(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.setReference(ref);
    }

    protected void unsetEventAdminRef(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.unsetReference(ref);
    }

    @Reference(service=RESTRoutingHelper.class, name="routingHelper", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRoutingHelper(ServiceReference<RESTRoutingHelper> routingHelper) {
        this.routingHelperRef.setReference(routingHelper);
    }

    protected void unsetRoutingHelper(ServiceReference<RESTRoutingHelper> routingHelper) {
        this.routingHelperRef.unsetReference(routingHelper);
    }

    private RESTRoutingHelper getRoutingHelper() throws IOException {
        RESTRoutingHelper routingHelper = (RESTRoutingHelper)this.routingHelperRef.getService();
        if (routingHelper == null) {
            IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"RESTRoutingHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return routingHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addRoutedNotificationListener(NotificationTargetInformation nti, ClientNotificationListener listener, JSONConverter converter) {
        block7: {
            try {
                boolean modified;
                RESTRoutingHelper helper = this.getRoutingHelper();
                if (helper == null) break block7;
                Map<NotificationTargetInformation, Set<ClientNotificationListener>> map = this.listenerMap;
                synchronized (map) {
                    Set<ClientNotificationListener> listeners = this.listenerMap.get(nti);
                    if (listeners == null) {
                        listeners = new HashSet<ClientNotificationListener>();
                        this.listenerMap.put(nti, listeners);
                    }
                    modified = listeners.add(listener);
                }
                if (modified) {
                    this.postRoutedNotificationListenerRegistrationEvent(OPERATION_PROP_VALUE_ADD, nti);
                }
            }
            catch (Exception helper) {
                void e;
                FFDCFilter.processException((Throwable)helper, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRoutedNotificationHelper", (String)"196", (Object)this, (Object[])new Object[]{nti, listener, converter});
                throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeRoutedNotificationListener(NotificationTargetInformation nti, ClientNotificationListener listener) {
        try {
            boolean modified;
            Map<NotificationTargetInformation, Set<ClientNotificationListener>> map = this.listenerMap;
            synchronized (map) {
                Set<ClientNotificationListener> listeners = this.listenerMap.get(nti);
                if (listeners != null) {
                    modified = listeners.remove(listener);
                    if (listeners.isEmpty()) {
                        this.listenerMap.remove(nti);
                    }
                } else {
                    modified = false;
                }
            }
            if (modified) {
                this.postRoutedNotificationListenerRegistrationEvent(OPERATION_PROP_VALUE_REMOVE, nti);
            }
        }
        catch (Exception modified) {
            void e;
            FFDCFilter.processException((Throwable)modified, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRoutedNotificationHelper", (String)"223", (Object)this, (Object[])new Object[]{nti, listener});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
    }

    private void postRoutedNotificationListenerRegistrationEvent(String operation, NotificationTargetInformation nti) {
        Map<String, Object> props = this.createListenerRegistrationEvent(operation, nti);
        this.safePostEvent(new Event(REGISTER_JMX_NOTIFICATION_LISTENER_TOPIC, props));
    }

    /*
     * WARNING - void declaration
     */
    public void addRoutedServerNotificationListener(NotificationTargetInformation nti, ObjectName listener, NotificationFilter filter, Object handback, JSONConverter converter) {
        try {
            this.postRoutedServerNotificationListenerRegistrationEvent(OPERATION_PROP_VALUE_ADD_SERVER_NOTIFICATION, nti, listener, filter, handback);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRoutedNotificationHelper", (String)"240", (Object)this, (Object[])new Object[]{nti, listener, filter, handback, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeRoutedServerNotificationListener(NotificationTargetInformation nti, ObjectName listener, NotificationFilter filter, Object handback, JSONConverter converter) {
        try {
            this.postRoutedServerNotificationListenerRegistrationEvent(OPERATION_PROP_VALUE_REMOVE_SERVER_NOTIFICATION, nti, listener, filter, handback);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanRoutedNotificationHelper", (String)"249", (Object)this, (Object[])new Object[]{nti, listener, filter, handback, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 500);
        }
    }

    private void postRoutedServerNotificationListenerRegistrationEvent(String operation, NotificationTargetInformation nti, ObjectName listener, NotificationFilter filter, Object handback) {
        Map<String, Object> props = this.createServerListenerRegistrationEvent(operation, nti, listener, filter, handback);
        this.safePostEvent(new Event(REGISTER_JMX_NOTIFICATION_LISTENER_TOPIC, props));
    }

    private Map<String, Object> createListenerRegistrationEvent(String operation, NotificationTargetInformation nti) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(OPERATION_PROP, operation);
        props.put(OBJECT_NAME_PROP, nti.getNameAsString());
        Map routingInfo = nti.getRoutingInformation();
        assert (routingInfo != null) : "Routing information is required to be passed in by the caller.";
        props.put("com.ibm.websphere.jmx.connector.rest.routing.hostName", routingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.hostName"));
        props.put("com.ibm.websphere.jmx.connector.rest.routing.serverName", routingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.serverName"));
        props.put("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir", routingInfo.get("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir"));
        return props;
    }

    private Map<String, Object> createServerListenerRegistrationEvent(String operation, NotificationTargetInformation nti, ObjectName listener, NotificationFilter filter, Object handback) {
        Map<String, Object> props = this.createListenerRegistrationEvent(operation, nti);
        props.put(LISTENER_OBJECT_NAME_PROP, listener != null ? listener.getCanonicalName() : null);
        props.put(NOTIFICATION_FILTER_PROP, filter);
        props.put(HANDBACK_OBJECT_PROP, handback);
        return props;
    }

    private void safePostEvent(Event event) {
        EventAdmin ea = (EventAdmin)this.eventAdminRef.getService();
        if (ea != null) {
            ea.postEvent(event);
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("The EventAdmin service is unavailable. Unable to post the Event: " + event), (Object[])new Object[0]);
        }
    }

    public static MBeanRoutedNotificationHelper getMBeanRoutedNotificationHelper() {
        MBeanRoutedNotificationHelper mbeanRoutedNotificationHelper;
        BundleContext bc = componentContext.getBundleContext();
        ServiceReference mbeanRoutedNotificationHelperRef = bc.getServiceReference(MBeanRoutedNotificationHelper.class);
        MBeanRoutedNotificationHelper mBeanRoutedNotificationHelper = mbeanRoutedNotificationHelper = mbeanRoutedNotificationHelperRef != null ? (MBeanRoutedNotificationHelper)bc.getService(mbeanRoutedNotificationHelperRef) : null;
        if (mbeanRoutedNotificationHelper == null) {
            IOException ioe = new IOException("OSGi service is not available.");
            throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
        }
        return mbeanRoutedNotificationHelper;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class NotificationEventHandler
    implements EventHandler {
        static final long serialVersionUID = 5833002515888050175L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            if (event == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to complete handleEvent, Event is null.", (Object[])new Object[0]);
                }
                return;
            }
            String topic = event.getTopic();
            if (MBeanRoutedNotificationHelper.HANDLE_NOTIFICATION_TOPIC.equals(topic)) {
                String objectName = (String)event.getProperty(MBeanRoutedNotificationHelper.OBJECT_NAME_PROP);
                if (objectName != null) {
                    Notification n = (Notification)event.getProperty(MBeanRoutedNotificationHelper.NOTIFICATION_PROP);
                    if (n != null) {
                        String hostName = (String)event.getProperty("com.ibm.websphere.jmx.connector.rest.routing.hostName");
                        String serverName = (String)event.getProperty("com.ibm.websphere.jmx.connector.rest.routing.serverName");
                        String serverUserDir = (String)event.getProperty("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir");
                        if (hostName != null && serverName != null && serverUserDir != null) {
                            NotificationRecord record = new NotificationRecord(n, objectName, hostName, serverName, serverUserDir);
                            NotificationTargetInformation nti = record.getNotificationTargetInformation();
                            Map map = MBeanRoutedNotificationHelper.this.listenerMap;
                            synchronized (map) {
                                Set listeners = (Set)MBeanRoutedNotificationHelper.this.listenerMap.get(nti);
                                if (listeners != null) {
                                    for (ClientNotificationListener listener : listeners) {
                                        ClientNotificationFilter filter = listener.getClientWrapperFilter();
                                        if (!filter.isNotificationEnabled(n)) continue;
                                        listener.handleNotificationRecord(record);
                                    }
                                } else if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)("Ignoring received event. A notification Event was received for " + nti + " but no listeners were registered to receive it."), (Object[])new Object[0]);
                                }
                            }
                        } else if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Ignoring received event. A notification Event was received but was missing routing information.", (Object[])new Object[0]);
                        }
                    } else if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Ignoring received event. A notification Event was received but was missing the Notification.", (Object[])new Object[0]);
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Ignoring received event. A notification Event was received but was missing the ObjectName.", (Object[])new Object[0]);
                }
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Ignoring received event. Unrecognized topic '" + topic + "'"), (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NotificationEventHandler.class, null, null);
        }
    }
}

