/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.javaee.common.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.ws.PortComponent;
import com.ibm.ws.javaee.dd.ws.ServiceImplBean;
import com.ibm.ws.javaee.dd.ws.WebserviceDescription;
import com.ibm.ws.javaee.dd.ws.Webservices;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Adaptable;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxWsDDHelper {
    static final long serialVersionUID = -736761466824676479L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    static boolean isWebServicesXMLExisting(Adaptable containerToAdapt) throws UnableToAdaptException {
        return containerToAdapt.adapt(Webservices.class) != null;
    }

    static PortComponent getPortComponentByEJBLink(String ejbLink, Adaptable containerToAdapt) throws UnableToAdaptException {
        return JaxWsDDHelper.getHighLevelElementByServiceImplBean(ejbLink, containerToAdapt, PortComponent.class, LinkType.EJB);
    }

    static PortComponent getPortComponentByServletLink(String servletLink, Adaptable containerToAdapt) throws UnableToAdaptException {
        return JaxWsDDHelper.getHighLevelElementByServiceImplBean(servletLink, containerToAdapt, PortComponent.class, LinkType.SERVLET);
    }

    static WebserviceDescription getWebserviceDescriptionByEJBLink(String ejbLink, Adaptable containerToAdapt) throws UnableToAdaptException {
        return JaxWsDDHelper.getHighLevelElementByServiceImplBean(ejbLink, containerToAdapt, WebserviceDescription.class, LinkType.EJB);
    }

    static WebserviceDescription getWebserviceDescriptionByServletLink(String servletLink, Adaptable containerToAdapt) throws UnableToAdaptException {
        return JaxWsDDHelper.getHighLevelElementByServiceImplBean(servletLink, containerToAdapt, WebserviceDescription.class, LinkType.SERVLET);
    }

    private static <T> T getHighLevelElementByServiceImplBean(String portLink, Adaptable containerToAdapt, Class<T> clazz, LinkType linkType) throws UnableToAdaptException {
        if (null == portLink) {
            return null;
        }
        if (PortComponent.class.isAssignableFrom(clazz) || WebserviceDescription.class.isAssignableFrom(clazz)) {
            Webservices wsXml = (Webservices)containerToAdapt.adapt(Webservices.class);
            if (null == wsXml) {
                return null;
            }
            for (WebserviceDescription wsDes : wsXml.getWebServiceDescriptions()) {
                if (wsDes.getPortComponents().size() == 0) continue;
                for (PortComponent portCmpt : wsDes.getPortComponents()) {
                    ServiceImplBean servImplBean = portCmpt.getServiceImplBean();
                    String serviceLink = LinkType.SERVLET == linkType ? servImplBean.getServletLink() : servImplBean.getEJBLink();
                    if (serviceLink == null || !serviceLink.equals(portLink)) continue;
                    if (PortComponent.class.isAssignableFrom(clazz)) {
                        return (T)portCmpt;
                    }
                    return (T)wsDes;
                }
            }
            return null;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JaxWsDDHelper.class, (String)"com.ibm.ws.webservices.javaee.common.internal", (String)"com.ibm.ws.webservices.javaee.common.internal.resources.WsEECommonMessages");
    }

    private static enum LinkType {
        EJB,
        SERVLET;

    }
}

