/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.internal.ConfigEventDispatcher;
import com.ibm.ws.config.admin.internal.ConfigurationAdminImpl;
import com.ibm.ws.config.admin.internal.ConfigurationStore;
import com.ibm.ws.config.admin.internal.ExtendedConfigurationImpl;
import com.ibm.ws.config.admin.internal.ManagedServiceFactoryTracker;
import com.ibm.ws.config.admin.internal.ManagedServiceTracker;
import com.ibm.ws.config.admin.internal.PluginManager;
import com.ibm.ws.config.admin.internal.UpdateQueue;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import java.io.IOException;
import java.security.Permission;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigAdminServiceFactory
implements ServiceFactory<ConfigurationAdmin>,
BundleListener {
    private static final TraceComponent tc = Tr.register(ConfigAdminServiceFactory.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final Permission configurationPermission = new ConfigurationPermission("*", "configure");
    protected static final int INDEX_DICTIONARY = 0;
    protected static final int INDEX_LOCATION = 1;
    protected static final int INDEX_METATYPE_PROCESSED = 2;
    protected static final int INDEX_IN_OVERRIDES_FILE = 3;
    protected static final int INDEX_REFERENCES = 4;
    protected static final int INDEX_UNIQUES = 5;
    final BundleContext bundleContext;
    protected final ManagedServiceTracker msTracker;
    protected final ManagedServiceFactoryTracker msfTracker;
    private final PluginManager pluginManager;
    private final ConfigurationStore configurationStore;
    protected final UpdateQueue<String> updateQueue = new UpdateQueue();
    private final ConfigEventDispatcher ced;
    private final Map<ConfigID, ExtendedConfigurationImpl> idMap = Collections.synchronizedMap(new HashMap());
    private final Map<ConfigID, Set<ConfigID>> referenceMap = Collections.synchronizedMap(new HashMap());
    private ServiceTracker<VariableRegistry, VariableRegistry> variableRegistryTracker = null;
    private final VariableRegistry variableRegistry;
    private final ServiceRegistration<?> configurationAdminRef;
    static final long serialVersionUID = 6695202270027014725L;

    public ConfigAdminServiceFactory(BundleContext bc) {
        this.bundleContext = bc;
        this.variableRegistryTracker = new ServiceTracker(bc, VariableRegistry.class.getName(), null);
        this.variableRegistryTracker.open();
        this.variableRegistry = (VariableRegistry)this.variableRegistryTracker.getService();
        this.configurationStore = new ConfigurationStore(this, bc);
        this.pluginManager = new PluginManager(bc);
        this.pluginManager.start();
        this.ced = new ConfigEventDispatcher(this, bc);
        this.msTracker = new ManagedServiceTracker(this, bc);
        this.msfTracker = new ManagedServiceFactoryTracker(this, bc);
        this.bundleContext.addBundleListener((BundleListener)this);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "IBM");
        this.configurationAdminRef = bc.registerService(ConfigurationAdmin.class.getName(), (Object)this, properties);
    }

    public void openManagedServiceTrackers() {
        this.msTracker.open();
        this.msfTracker.open();
    }

    public void closeServices() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.configurationAdminRef.unregister();
        this.msfTracker.close();
        this.msTracker.close();
        try {
            this.configurationStore.saveConfigurationDatas(true);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory", (String)"132", (Object)this, (Object[])new Object[0]);
        }
        this.updateQueue.shutdown();
        this.ced.close();
        this.pluginManager.stop();
        if (null != this.variableRegistryTracker) {
            this.variableRegistryTracker.close();
            this.variableRegistryTracker = null;
        }
    }

    public ConfigurationAdmin getService(Bundle bundle, ServiceRegistration<ConfigurationAdmin> registration) {
        ServiceReference reference = registration.getReference();
        this.ced.setServiceReference((ServiceReference<ConfigurationAdmin>)reference);
        return new ConfigurationAdminImpl(this, bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ConfigurationAdmin> registration, ConfigurationAdmin service) {
    }

    public void registerConfiguration(ConfigID id, ExtendedConfigurationImpl config) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Registering configuration with config id " + id + " : " + config), (Object[])new Object[0]);
        }
        config.setFullId(id);
        this.idMap.put(id, config);
    }

    public void unregisterConfiguration(ConfigID id) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing configuration with config id " + id), (Object[])new Object[0]);
        }
        this.idMap.remove(id);
    }

    public ExtendedConfigurationImpl lookupConfiguration(ConfigID id) {
        return this.idMap.get(id);
    }

    public void addReferences(Set<ConfigID> references, ConfigID id) {
        if (references != null) {
            for (ConfigID reference : references) {
                this.addReference(reference, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReference(ConfigID reference, ConfigID id) {
        Set<ConfigID> referenceIds = null;
        Map<ConfigID, Set<ConfigID>> map = this.referenceMap;
        synchronized (map) {
            referenceIds = this.referenceMap.get(reference);
            if (referenceIds == null) {
                referenceIds = Collections.synchronizedSet(new HashSet());
                this.referenceMap.put(reference, referenceIds);
            }
        }
        referenceIds.add(id);
    }

    public void removeReferences(Set<ConfigID> references, ConfigID id) {
        if (references != null) {
            for (ConfigID reference : references) {
                this.removeReference(reference, id);
            }
        }
    }

    private void removeReference(ConfigID reference, ConfigID id) {
        Set<ConfigID> referenceIds = this.referenceMap.get(reference);
        if (referenceIds != null) {
            referenceIds.remove(id);
        }
    }

    public Set<ConfigID> getReferences(ConfigID id) {
        Set<ConfigID> references = this.referenceMap.get(id);
        return references == null ? Collections.emptySet() : references;
    }

    Future<?> dispatchEvent(int type, String factoryPid, String pid) {
        return this.ced.dispatch(type, factoryPid, pid);
    }

    Future<?> notifyConfigurationUpdated(ExtendedConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            return this.msfTracker.notifyUpdated(config);
        }
        return this.msTracker.notifyUpdated(config);
    }

    Future<?> notifyConfigurationDeleted(ExtendedConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            return this.msfTracker.notifyDeleted(config);
        }
        return this.msTracker.notifyDeleted(config);
    }

    void modifyConfiguration(ServiceReference<?> reference, Dictionary<String, Object> properties, Object service) {
        this.pluginManager.modifyConfiguration(reference, properties);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.configurationStore.unbindConfigurations(event.getBundle());
        }
    }

    public void checkConfigurationPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.configurationPermission);
        }
    }

    protected ConfigurationStore getConfigurationStore() {
        return this.configurationStore;
    }

    public VariableRegistry getVariableRegistry() {
        return this.variableRegistry;
    }

    public ExtendedConfiguration findConfiguration(String pid) {
        return this.configurationStore.findConfiguration(pid);
    }
}

