/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.config.ConfigValidationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.SystemConfigSupport;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.ConfigParserTolerableException;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.SystemConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSConfigXMLActivator
implements BundleActivator {
    private static final TraceComponent tc = Tr.register(WSConfigXMLActivator.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private MetaTypeRegistry metaTypeRegistry = null;
    private SystemConfiguration systemConfiguration = null;
    private ServiceTracker<WsLocationAdmin, WsLocationAdmin> locationTracker = null;
    private ServiceTracker<VariableRegistry, VariableRegistry> variableRegistryTracker = null;
    private ServiceTracker<SystemConfigSupport, SystemConfigSupport> caSupportTracker = null;
    static final long serialVersionUID = -6264589882340823151L;

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConfigParserTolerableException.class})
    public void start(BundleContext bc) {
        try {
            this.locationTracker = new ServiceTracker(bc, WsLocationAdmin.class.getName(), null);
            this.locationTracker.open();
            this.variableRegistryTracker = new ServiceTracker(bc, VariableRegistry.class.getName(), null);
            this.variableRegistryTracker.open();
            this.caSupportTracker = new ServiceTracker(bc, SystemConfigSupport.class.getName(), null);
            this.caSupportTracker.open();
            SystemConfigSupport systemConfigSupport = (SystemConfigSupport)this.caSupportTracker.getService();
            ServiceReference caAdminRef = bc.getServiceReference(ConfigurationAdmin.class);
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)bc.getService(caAdminRef);
            this.metaTypeRegistry = new MetaTypeRegistry();
            this.metaTypeRegistry.start(bc);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.vendor", "IBM");
            bc.registerService(MetaTypeRegistry.class.getName(), (Object)this.metaTypeRegistry, properties);
            this.systemConfiguration = new SystemConfiguration(bc, systemConfigSupport, configAdmin, this.getOnError());
            this.systemConfiguration.start();
            bc.registerService(SystemConfiguration.class.getName(), (Object)this.systemConfiguration, properties);
            systemConfigSupport.openManagedServiceTrackers();
        }
        catch (ConfigMergeException systemConfigSupport) {
            void e;
            FFDCFilter.processException((Throwable)systemConfigSupport, (String)"com.ibm.ws.config.xml.internal.WSConfigXMLActivator", (String)"106", (Object)this, (Object[])new Object[]{bc});
            this.quit(bc, (Exception)e);
        }
        catch (ConfigUpdateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.WSConfigXMLActivator", (String)"109", (Object)this, (Object[])new Object[]{bc});
            if (this.getOnError().equals((Object)OnErrorUtil.OnError.FAIL)) {
                this.quit(bc, e);
            }
        }
        catch (ConfigParserTolerableException e) {
            this.quit(bc, e);
        }
        catch (ConfigValidationException e) {
            void cve;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.WSConfigXMLActivator", (String)"116", (Object)this, (Object[])new Object[]{bc});
            if (!cve.docLocation.isEmpty()) {
                Tr.fatal((TraceComponent)tc, (String)"fatal.configValidator.documentNotValid", (Object[])new Object[]{cve.docLocation});
            }
            this.quit(bc, (Exception)cve);
        }
        catch (Exception cve) {
            FFDCFilter.processException((Throwable)cve, (String)"com.ibm.ws.config.xml.internal.WSConfigXMLActivator", (String)"120", (Object)this, (Object[])new Object[]{bc});
            this.quit(bc, (Exception)e);
        }
    }

    public void stop(BundleContext context) {
        if (this.systemConfiguration != null) {
            this.systemConfiguration.stop();
            this.systemConfiguration = null;
        }
        if (this.metaTypeRegistry != null) {
            this.metaTypeRegistry.stop(context);
            this.metaTypeRegistry = null;
        }
        if (null != this.caSupportTracker) {
            this.caSupportTracker.close();
            this.caSupportTracker = null;
        }
        if (null != this.locationTracker) {
            this.locationTracker.close();
            this.locationTracker = null;
        }
        if (null != this.variableRegistryTracker) {
            this.variableRegistryTracker.close();
            this.variableRegistryTracker = null;
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void quit(BundleContext bundleContext, Exception cause) {
        Tr.audit((TraceComponent)tc, (String)"frameworkShutdown", (Object[])new Object[]{((WsLocationAdmin)this.locationTracker.getService()).getServerName()});
        try {
            Bundle bundle = bundleContext.getBundle("System Bundle");
            if (bundle != null) {
                bundle.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private OnErrorUtil.OnError getOnError() {
        OnErrorUtil.OnError onError;
        String onErrorVar;
        VariableRegistry variableRegistry = (VariableRegistry)this.variableRegistryTracker.getService();
        String onErrorVal = variableRegistry.resolveString(onErrorVar = "${onError}");
        if (onErrorVal.equals(onErrorVar)) {
            onError = OnErrorUtil.OnError.WARN;
        } else {
            String onErrorFormatted = onErrorVal.trim().toUpperCase();
            try {
                onError = Enum.valueOf(OnErrorUtil.OnError.class, onErrorFormatted);
                if (!onErrorVal.equals(onErrorFormatted)) {
                    variableRegistry.replaceVariable("onError", onErrorFormatted);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.config.xml.internal.WSConfigXMLActivator", (String)"198", (Object)this, (Object[])new Object[0]);
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"warn.config.invalid.value", (Object[])new Object[]{"onError", onErrorVal, "[IGNORE][WARN][FAIL]"});
                }
                onError = OnErrorUtil.OnError.WARN;
                variableRegistry.replaceVariable("onError", OnErrorUtil.OnError.WARN.toString());
            }
        }
        return onError;
    }
}

