/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectManager.LinkedList;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.msgstore.persistence.objectManager.Anchor;
import com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyGeneratorImpl;
import com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager;
import com.ibm.ws.sib.utils.ras.SibTr;

public class UniqueKeyManager {
    private static TraceComponent tc = SibTr.register(UniqueKeyManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Token _uniqueKeyRootToken;
    private Thread _rangeManagerThread;
    private UniqueKeyRangeManager _rangeManager;

    public void start(Anchor anchor, ObjectManager objectManager, ObjectStore objectStore) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)"");
        }
        this._uniqueKeyRootToken = anchor.getUniqueKeyTableToken();
        if (this._uniqueKeyRootToken == null) {
            try {
                Transaction tran = objectManager.getTransaction();
                LinkedList uniqueKeyRootList = new LinkedList(tran, objectStore);
                this._uniqueKeyRootToken = uniqueKeyRootList.getToken();
                tran.lock(anchor);
                anchor.setUniqueKeyTableToken(this._uniqueKeyRootToken);
                tran.replace(anchor);
                tran.commit(false);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"UniqueKeyGenerator root list created.");
                }
            }
            catch (ObjectManagerException ome) {
                FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyManager.start", (String)"1:78:1.5", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Exception caught initializing root of unique key generator list!", (Object)ome);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"start");
                }
                throw new PersistenceException("Exception caught initializing root of unique key generator list!", (Throwable)ome);
            }
        }
        this._rangeManager = new UniqueKeyRangeManager(this._uniqueKeyRootToken, objectManager, objectStore);
        this._rangeManager.start();
        this._rangeManagerThread = new Thread(this._rangeManager);
        this._rangeManagerThread.setName("UniqueKeyRangeManager");
        this._rangeManagerThread.setDaemon(true);
        this._rangeManagerThread.start();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (this._rangeManager != null) {
            this._rangeManager.stop();
            this._rangeManager = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public UniqueKeyGenerator createUniqueKeyGenerator(String name, long range) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createUniqueKeyGenerator", (Object)("Name=" + name + ", Range=" + range));
        }
        if (this._rangeManager == null) {
            PersistenceException pe = new PersistenceException("Request to create new UniqueKeyGenerator failed. UniqueKeyManager not started!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Request to create new UniqueKeyGenerator failed. UniqueKeyManager not started!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createUniqueKeyGenerator");
            }
            throw pe;
        }
        UniqueKeyGeneratorImpl generator = new UniqueKeyGeneratorImpl(this._rangeManager, name, range);
        try {
            generator.initialize();
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyManager.createUniqueKeyGenerator", (String)"1:135:1.5", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught initializing unique key generator!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createUniqueKeyGenerator");
            }
            throw pe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createUniqueKeyGenerator", (Object)("return=" + generator));
        }
        return generator;
    }
}

