/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.KeyStoreException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpClientUtil {
    private static final TraceComponent tc = Tr.register(HttpClientUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    static final long serialVersionUID = 4156332294234774028L;

    protected JSSEHelper getJSSEHelper(SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException {
        if (sslSupport != null) {
            return sslSupport.getJSSEHelper();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected SSLSocketFactory getSSLSocketFactory(String requestUrl, String sslConfigurationName, SSLSupport sslSupport, String clientId) throws com.ibm.websphere.ssl.SSLException {
        SSLSocketFactory sslSocketFactory = null;
        if (sslSupport != null) {
            try {
                sslSocketFactory = sslSupport.getSSLSocketFactory(sslConfigurationName);
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.openidconnect.clients.common.HttpClientUtil", (String)"49", (Object)this, (Object[])new Object[]{requestUrl, sslConfigurationName, sslSupport, clientId});
                throw new com.ibm.websphere.ssl.SSLException(e.getMessage());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sslSocketFactory () get: " + sslSocketFactory), (Object[])new Object[0]);
            }
        }
        if (sslSocketFactory == null && requestUrl != null && requestUrl.startsWith("https")) {
            throw new com.ibm.websphere.ssl.SSLException(Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", clientId}));
        }
        return sslSocketFactory;
    }

    @FFDCIgnore(value={KeyStoreException.class})
    public String getHTTPRequestAsString(HttpClient httpClient, String url, String jwkClientId, @Sensitive String jwkClientSecret) throws Exception {
        String json;
        block7: {
            HttpResponse result;
            StatusLine statusLine;
            int iStatusCode;
            json = null;
            HttpGet request = new HttpGet(url);
            request.addHeader("content-type", "application/json");
            if (jwkClientId != null && jwkClientSecret != null) {
                String userpass = jwkClientId + ":" + jwkClientSecret;
                String basicAuth = "Basic " + Base64Coder.base64Encode(userpass);
                request.addHeader("Authorization", basicAuth);
            }
            if ((iStatusCode = (statusLine = (result = httpClient.execute((HttpUriRequest)request)).getStatusLine()).getStatusCode()) == 200) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Response: ", (Object[])new Object[]{json});
                }
                if (json == null || json.isEmpty()) {
                    String message = Tr.formatMessage((TraceComponent)tc, (String)"JWK_RETRIEVE_FAILED", (Object[])new Object[]{url, iStatusCode, json});
                    Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
                    throw new Exception(message);
                }
                break block7;
            }
            String errMsg = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("status:" + iStatusCode + " errorMsg:" + errMsg), (Object[])new Object[0]);
            }
            String message = Tr.formatMessage((TraceComponent)tc, (String)"JWK_RETRIEVE_FAILED", (Object[])new Object[]{url, iStatusCode, errMsg});
            Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            throw new Exception(message);
        }
        return json;
    }
}

