/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.token;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.token.CheckAudience;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWSHeader;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.security.openidconnect.token.Payload;
import com.ibm.ws.security.openidconnect.token.WSJsonToken;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWT {
    private static final TraceComponent tc = Tr.register(JWT.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    private JWSHeader header;
    private JWTPayload payload;
    @Sensitive
    private Object key;
    private String signedAndSerializedString;
    private String tokenString;
    private String baseString;
    private static final String ALGORITHM_HEADER = "alg";
    private long clockSkewInSeconds = 0L;
    private String clientId = null;
    private String issuers = null;
    private String signingAlgorithm = "none";
    static final long serialVersionUID = -4936895986284158662L;

    public JWT(JWSHeader header, JWTPayload payload, @Sensitive Object key) {
        this.header = header;
        this.payload = payload;
        this.setKey(key);
    }

    public JWT(JWSHeader header, JWTPayload payload) {
        this.header = header;
        this.payload = payload;
    }

    public JWT(String tokenString, @Sensitive Object key, String clientId, String issuers, String signingAlgorithm) {
        this.tokenString = tokenString;
        this.setKey(key);
        this.clientId = clientId;
        this.issuers = issuers;
        this.signingAlgorithm = signingAlgorithm;
        this.header = new JWSHeader();
        this.initializeHeader();
    }

    public JWT(String tokenString, String clientId, String issuers, String signingAlgorithm) {
        this.tokenString = tokenString;
        this.clientId = clientId;
        this.issuers = issuers;
        this.signingAlgorithm = signingAlgorithm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public JWTPayload getPayload() {
        return this.payload;
    }

    protected String createPlainTextJWT() {
        JsonObject header = this.createHeader();
        JsonObject payload = this.createPayload();
        String plainTextTokenString = this.computeBaseString(header, payload);
        StringBuffer sb = new StringBuffer(plainTextTokenString);
        sb.append(".").append("");
        return sb.toString();
    }

    protected JsonObject createHeader() {
        Set keySet;
        JsonObject jsonheader = new JsonObject();
        jsonheader.addProperty(ALGORITHM_HEADER, "none");
        List<String> critList = this.header.getCritical();
        if (critList != null) {
            JsonArray list = this.handleList(critList);
            jsonheader.add("crit", (JsonElement)list);
        }
        if (!(keySet = this.header.keySet()).isEmpty()) {
            for (String key : keySet) {
                Object value = this.header.get(key);
                if (value instanceof List) {
                    JsonArray list = this.handleList((List)value);
                    jsonheader.add(key, (JsonElement)list);
                    continue;
                }
                if (value instanceof String) {
                    jsonheader.addProperty(key, (String)value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                jsonheader.addProperty(key, (Number)value);
            }
        }
        return jsonheader;
    }

    protected JsonObject createPayload() {
        Set keySet;
        JsonObject jsonpayload = new JsonObject();
        List<String> audienceList = this.payload.getAudienceAsList();
        if (audienceList != null) {
            JsonArray list = this.handleList(audienceList);
            jsonpayload.add("aud", (JsonElement)list);
        }
        if (!(keySet = this.payload.keySet()).isEmpty()) {
            for (String key : keySet) {
                Object value = this.payload.get(key);
                if (value instanceof List) {
                    JsonArray list = this.handleList((List)value);
                    jsonpayload.add(key, (JsonElement)list);
                    continue;
                }
                if (value instanceof String) {
                    jsonpayload.addProperty(key, (String)value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                jsonpayload.addProperty(key, (Number)value);
            }
        }
        long now = System.currentTimeMillis();
        if (this.payload.getIssuedAtTimeSeconds() != null) {
            jsonpayload.addProperty("iat", (Number)this.payload.getIssuedAtTimeSeconds());
        } else {
            jsonpayload.addProperty("iat", (Number)(now / 1000L));
        }
        if (this.payload.getExpirationTimeSeconds() != null) {
            jsonpayload.addProperty("exp", (Number)this.payload.getExpirationTimeSeconds());
        } else {
            long expireAtSec = now / 1000L + 3600L;
            jsonpayload.addProperty("exp", (Number)expireAtSec);
        }
        return jsonpayload;
    }

    protected JsonArray handleList(List<String> strlist) {
        JsonArray list = null;
        if (strlist != null) {
            list = new JsonArray();
            for (String str : strlist) {
                JsonPrimitive jsonPrimitiveObj = new JsonPrimitive(str);
                list.add((JsonElement)jsonPrimitiveObj);
            }
        }
        return list;
    }

    protected String computeBaseString(JsonObject header, JsonObject payload) {
        if (this.baseString != null && !this.baseString.isEmpty()) {
            return this.baseString;
        }
        this.baseString = JsonTokenUtil.toDotFormat(JsonTokenUtil.toBase64(header), JsonTokenUtil.toBase64(payload));
        return this.baseString;
    }

    protected void createSignedJWT() throws SignatureException, InvalidKeyException {
        this.createJsonToken();
    }

    /*
     * WARNING - void declaration
     */
    protected WSJsonToken createJsonToken() throws SignatureException {
        JsonArray list;
        Object value;
        WSJsonToken token = new WSJsonToken();
        Set keySet = this.header.keySet();
        if (!keySet.isEmpty()) {
            JsonObject headerObj = token.getHeader();
            for (String key : keySet) {
                value = this.header.get(key);
                if (value instanceof List) {
                    list = this.handleList((List)value);
                    headerObj.add(key, (JsonElement)list);
                    continue;
                }
                if (value instanceof String) {
                    headerObj.addProperty(key, (String)value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                headerObj.addProperty(key, (Number)value);
            }
        }
        if (!(keySet = this.payload.keySet()).isEmpty()) {
            JsonObject payloadObj = token.getPayload();
            for (String key : keySet) {
                value = this.payload.get(key);
                if (value instanceof List) {
                    list = this.handleList((List)value);
                    payloadObj.add(key, (JsonElement)list);
                    continue;
                }
                if (value instanceof String) {
                    payloadObj.addProperty(key, (String)value);
                    continue;
                }
                if (!(value instanceof Number)) continue;
                payloadObj.addProperty(key, (Number)value);
            }
        }
        long nowSeconds = System.currentTimeMillis() / 1000L;
        if (this.payload.getIssuedAtTimeSeconds() != null) {
            token.setIssuedAt(this.payload.getIssuedAtTimeSeconds());
        } else {
            token.setIssuedAt(nowSeconds);
        }
        if (this.payload.getExpirationTimeSeconds() != null) {
            token.setExpiration(this.payload.getExpirationTimeSeconds());
        } else {
            token.setExpiration(nowSeconds + 3600L);
        }
        try {
            this.signedAndSerializedString = this.serializeAndSign(token);
        }
        catch (Exception key) {
            void e;
            FFDCFilter.processException((Throwable)key, (String)"com.ibm.ws.security.openidconnect.token.JWT", (String)"340", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createJsonToken", (Object[])new Object[]{this.header.getAlgorithm()});
            Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_ERR", (Object[])new Object[]{this.header.getAlgorithm(), e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName()});
            throw new SignatureException((Throwable)e);
        }
        return token;
    }

    private String serializeAndSign(WSJsonToken token) throws InvalidKeyException, UnsupportedEncodingException, JoseException {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(JsonTokenUtil.toJson(token.getPayload()));
        String alg = token.getHeader().get(ALGORITHM_HEADER).getAsString();
        jws.setAlgorithmHeaderValue(alg);
        JsonElement typ = token.getHeader().get("typ");
        if (typ != null) {
            jws.setHeader("typ", typ.getAsString());
        }
        jws.setKey(this.getKey(alg));
        return jws.getCompactSerialization();
    }

    public String getSignedJWTString() throws SignatureException, InvalidKeyException {
        if (this.signedAndSerializedString != null) {
            return this.signedAndSerializedString;
        }
        this.createSignedJWT();
        return this.signedAndSerializedString;
    }

    public String getJWTString() {
        if (this.baseString != null) {
            return this.baseString;
        }
        this.baseString = this.createPlainTextJWT();
        return this.baseString;
    }

    protected void fromJsonToken(WSJsonToken token) {
        this.payload = new JWTPayload();
        JsonTokenUtil.fromJsonToken(token, this.payload);
        this.header = new JWSHeader();
        JsonTokenUtil.fromJsonToken(token, this.header);
    }

    protected boolean verifyTokenIssueAndExpTime(WSJsonToken jsonToken) throws IDTokenValidationFailedException {
        boolean isValid = true;
        Instant issuedAt = new Instant(jsonToken.getIssuedAt() * 1000L);
        Instant expiration = new Instant(jsonToken.getExpiration() * 1000L);
        if (issuedAt != null && (issuedAt.isAfter((ReadableInstant)expiration) || !JsonTokenUtil.isCurrentTimeInInterval(this.clockSkewInSeconds, issuedAt.getMillis(), expiration.getMillis()))) {
            Object[] objects = new Object[]{this.clientId, "Token expired", System.currentTimeMillis(), expiration, issuedAt};
            Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_STATE_ERR", (Object[])objects);
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_STATE_ERR", (Object[])objects));
        }
        if (!JWT.checkIssuer(this.clientId, this.issuers, jsonToken.getIssuer())) {
            isValid = false;
        }
        return isValid;
    }

    public static boolean checkIssuer(String clientId, String issuers, String issuer) throws IDTokenValidationFailedException {
        boolean isIssuer = false;
        if (issuer != null) {
            if (issuer.equals(issuers)) {
                isIssuer = true;
            } else {
                StringTokenizer st = new StringTokenizer(issuers, " ,");
                while (st.hasMoreTokens()) {
                    String iss = st.nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Token:" + iss), (Object[])new Object[0]);
                    }
                    if (!issuer.equals(iss)) continue;
                    isIssuer = true;
                    break;
                }
            }
            if (!isIssuer) {
                Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_ISSUER_ERR", (Object[])new Object[]{clientId, issuer, issuers});
                throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_VERIFY_ISSUER_ERR", clientId, issuer, issuers);
            }
        }
        return isIssuer;
    }

    public boolean verify() throws IDTokenValidationFailedException {
        return this.verify(180L);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={InvalidKeyException.class, InvalidJwtException.class})
    public boolean verifySignatureOnly() throws IDTokenValidationFailedException {
        JsonParser parser;
        String jwtHeaderSegment;
        String[] jwtParts = JsonTokenUtil.splitTokenString(this.tokenString);
        boolean rpSpecifiedSignatureAlgorithm = true;
        if (this.signingAlgorithm.equals("none")) {
            rpSpecifiedSignatureAlgorithm = false;
        }
        String alg = null;
        JsonObject header = null;
        if (!rpSpecifiedSignatureAlgorithm) {
            jwtHeaderSegment = jwtParts[0];
            parser = new JsonParser();
            header = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtHeaderSegment)).getAsJsonObject();
            alg = header.get(ALGORITHM_HEADER).getAsString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Signing Algorithm from header: " + alg), (Object[])new Object[0]);
            }
        } else {
            parser = new JsonParser();
            jwtHeaderSegment = jwtParts[0];
            header = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtHeaderSegment)).getAsJsonObject();
            String algHeader = header.get(ALGORITHM_HEADER).getAsString();
            if (!this.signingAlgorithm.equals(algHeader)) {
                Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", (Object[])new Object[]{this.clientId, this.signingAlgorithm, algHeader});
                throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", this.clientId, this.signingAlgorithm, algHeader);
            }
            alg = this.signingAlgorithm;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RP specified Signing Algorithm : " + alg), (Object[])new Object[0]);
            }
        }
        String jwtPayloadSegment = jwtParts[1];
        parser = new JsonParser();
        JsonObject payload = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtPayloadSegment)).getAsJsonObject();
        WSJsonToken tempToken = new WSJsonToken(header, payload);
        this.fromJsonToken(tempToken);
        try {
            JsonTokenUtil.validateTokenString(this.tokenString, alg, this.getKey(alg), this.clockSkewInSeconds, true);
        }
        catch (InvalidKeyException e) {
            Object[] objs = new Object[]{this.clientId, e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage(), this.signingAlgorithm};
            Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_INVALIDKEY_ERR", (Object[])objs);
            throw new IDTokenValidationFailedException("InvalidKeyException Message:" + e.getMessage(), e);
        }
        catch (InvalidJwtException e) {
            Object[] objs = new Object[]{this.clientId, e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage(), this.signingAlgorithm};
            Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR", (Object[])objs);
            throw new IDTokenValidationFailedException("SignatureException Message:" + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            void ise;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.token.JWT", (String)"506", (Object)this, (Object[])new Object[0]);
            throw new IDTokenValidationFailedException("Exception Message:" + ise.getMessage(), (Exception)ise);
        }
        return true;
    }

    public boolean verify(long clockSkewInSeconds) throws IDTokenValidationFailedException {
        return this.verify(clockSkewInSeconds, this.getKey());
    }

    @FFDCIgnore(value={InvalidKeyException.class, IllegalStateException.class})
    public boolean verify(long clockSkewInSeconds, Object key) throws IDTokenValidationFailedException {
        boolean isValid = false;
        this.setKey(key);
        this.clockSkewInSeconds = clockSkewInSeconds;
        String[] jwtParts = JsonTokenUtil.splitTokenString(this.tokenString);
        boolean rpSpecifiedSignatureAlgorithm = true;
        if (this.signingAlgorithm.equals("none")) {
            rpSpecifiedSignatureAlgorithm = false;
        }
        if (jwtParts.length == 2) {
            if (rpSpecifiedSignatureAlgorithm) {
                Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_MISSING_SIGNATURE_ERR", (Object[])new Object[]{this.clientId, this.signingAlgorithm});
                throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_SIGNATURE_VERIFY_MISSING_SIGNATURE_ERR", this.clientId, this.signingAlgorithm);
            }
            WSJsonToken token = JsonTokenUtil.deserialize(jwtParts, this.tokenString);
            this.fromJsonToken(token);
            if (this.payload.get("aud") != null) {
                CheckAudience checkAudience = new CheckAudience(this.clientId, this.payload);
                checkAudience.check();
            }
            isValid = this.verifyTokenIssueAndExpTime(token);
            return isValid;
        }
        if (jwtParts.length > 2) {
            Object[] objs;
            JsonObject header;
            JsonParser parser;
            String jwtHeaderSegment;
            String alg = null;
            if (!rpSpecifiedSignatureAlgorithm) {
                jwtHeaderSegment = jwtParts[0];
                parser = new JsonParser();
                header = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtHeaderSegment)).getAsJsonObject();
                alg = header.get(ALGORITHM_HEADER).getAsString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Signing Algorithm from header: " + alg), (Object[])new Object[0]);
                }
            } else {
                parser = new JsonParser();
                jwtHeaderSegment = jwtParts[0];
                header = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtHeaderSegment)).getAsJsonObject();
                String algHeader = header.get(ALGORITHM_HEADER).getAsString();
                if (!this.signingAlgorithm.equals(algHeader)) {
                    Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", (Object[])new Object[]{this.clientId, this.signingAlgorithm, algHeader});
                    throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", this.clientId, this.signingAlgorithm, algHeader);
                }
                alg = this.signingAlgorithm;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RP specified Signing Algorithm : " + alg), (Object[])new Object[0]);
                }
            }
            try {
                JsonTokenUtil.validateTokenString(this.tokenString, alg, this.getKey(alg), this.clockSkewInSeconds, false);
                WSJsonToken token = JsonTokenUtil.deserialize(JsonTokenUtil.splitTokenString(this.tokenString), this.tokenString);
                this.fromJsonToken(token);
                if (token.getExpiration() > 0L && token.getIssuedAt() > 0L) {
                    this.verifyTokenIssueAndExpTime(token);
                }
                if (JWT.checkIssuer(this.clientId, this.issuers, token.getIssuer())) {
                    if (this.payload.get("aud") != null) {
                        CheckAudience checkAudience = new CheckAudience(this.clientId, this.payload);
                        checkAudience.check();
                    }
                    isValid = true;
                }
            }
            catch (InvalidKeyException e) {
                objs = new Object[]{this.clientId, e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage(), this.signingAlgorithm};
                Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_INVALIDKEY_ERR", (Object[])objs);
                throw new IDTokenValidationFailedException("InvalidKeyException Message:" + e.getMessage(), e);
            }
            catch (InvalidJwtException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.token.JWT", (String)"630", (Object)this, (Object[])new Object[]{clockSkewInSeconds, key});
                objs = new Object[]{this.clientId, e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage(), this.signingAlgorithm};
                Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR", (Object[])objs);
                throw new IDTokenValidationFailedException("SignatureException Message:" + e.getMessage(), (Exception)((Object)e));
            }
            catch (IllegalStateException e) {
                Throwable cause = e;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                WSJsonToken token = JsonTokenUtil.deserialize(jwtParts, this.tokenString);
                Object[] objs2 = new Object[]{this.clientId, cause.getMessage() == null ? e.getClass().getSimpleName() : cause.getMessage(), System.currentTimeMillis(), token.getExpiration(), token.getIssuedAt()};
                if (cause.getMessage().contains("No installed provider")) {
                    Tr.error((TraceComponent)tc, (String)"JWK_ENDPOINT_MISSING_ERR", (Object[])objs2);
                } else {
                    Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_VERIFY_STATE_ERR", (Object[])objs2);
                }
                throw new IDTokenValidationFailedException("IllegalStateException Message:" + e.getMessage(), e);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.token.JWT", (String)"647", (Object)this, (Object[])new Object[]{clockSkewInSeconds, key});
                Tr.error((TraceComponent)tc, (String)"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR", (Object[])new Object[]{this.clientId, e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage(), this.signingAlgorithm});
                throw new IDTokenValidationFailedException(e.getClass().getName() + " Message:" + e.getMessage() == null ? "" : e.getMessage(), e);
            }
        }
        return isValid;
    }

    private void initializeHeader() {
        String element;
        JsonElement idElement;
        String element2;
        JsonElement algElement;
        String[] jwtParts = JsonTokenUtil.splitTokenString(this.tokenString);
        String jwtHeaderSegment = jwtParts[0];
        JsonParser parser = new JsonParser();
        JsonObject jHeader = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtHeaderSegment)).getAsJsonObject();
        if (this.header == null) {
            this.header = new JWSHeader();
        }
        if ((algElement = jHeader.get(ALGORITHM_HEADER)) != null && (element2 = algElement.getAsString()) != null) {
            this.header.setAlgorithm(element2);
        }
        if ((idElement = jHeader.get("kid")) != null && (element = idElement.getAsString()) != null) {
            this.header.setKeyId(element);
        }
        if ((idElement = jHeader.get("x5t")) != null && (element = idElement.getAsString()) != null) {
            this.header.setX509Thumbprint(element);
        }
        if ((idElement = jHeader.get("x5c")) != null && (element = idElement.getAsString()) != null) {
            this.header.setX509Certificate(element);
        }
        if ((idElement = jHeader.get("x5u")) != null && (element = idElement.getAsString()) != null) {
            this.header.setX509Url(element);
        }
    }

    private Key getKey(String alg) throws UnsupportedEncodingException, InvalidKeyException {
        Key keyUsed = null;
        if ("RS256".equals(alg)) {
            keyUsed = (Key)this.getKey();
        } else if ("HS256".equals(alg)) {
            byte[] keyBytes = null;
            if (this.getKey() instanceof String) {
                keyBytes = ((String)this.getKey()).getBytes("UTF-8");
            } else if (this.getKey() instanceof byte[]) {
                keyBytes = (byte[])this.getKey();
            } else {
                throw new InvalidKeyException("Not a valid key");
            }
            keyUsed = new HmacKey(keyBytes);
        }
        return keyUsed;
    }

    public String parseAndVerify(JWT jwt) {
        return null;
    }

    public Payload createPayloadFromString(String payloadString) {
        return null;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }
}

