/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.overlay.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.overlay.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl;
import com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerRegistry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainerFactory;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Set;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OverlayContainerFactoryImpl
implements OverlayContainerFactory,
ContainerFactoryHolder {
    private ArtifactContainerFactory containerFactory = null;
    private final DirectoryBasedOverlayContainerRegistry registeredContainers = new DirectoryBasedOverlayContainerRegistry();
    static final long serialVersionUID = -6737526700663704564L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public <T extends OverlayContainer> T createOverlay(Class<T> overlayType, ArtifactContainer b) {
        if (overlayType.equals(OverlayContainer.class)) {
            DirectoryBasedOverlayContainerImpl tempReference = new DirectoryBasedOverlayContainerImpl(b, this);
            this.register(tempReference);
            return (T)tempReference;
        }
        return null;
    }

    protected synchronized void activate(ComponentContext ctx) {
    }

    protected synchronized void deactivate(ComponentContext ctx) {
        this.containerFactory = null;
    }

    protected synchronized void setContainerFactory(ArtifactContainerFactory cf) {
        this.containerFactory = cf;
    }

    protected synchronized void unsetContainerFactory(ArtifactContainerFactory cf) {
        if (this.containerFactory == cf) {
            this.containerFactory = null;
        }
    }

    @Override
    public synchronized ArtifactContainerFactory getContainerFactory() {
        if (this.containerFactory == null) {
            throw new IllegalStateException();
        }
        return this.containerFactory;
    }

    private void register(DirectoryBasedOverlayContainerImpl container) {
        this.registeredContainers.add(container);
    }

    public void introspect(PrintWriter outputWriter) {
        outputWriter.println("Active Containers:");
        if (this.registeredContainers.isEmpty()) {
            outputWriter.println("  ** NONE **");
        } else {
            Set<DirectoryBasedOverlayContainerImpl> snapshotSet = this.registeredContainers.getSnapshotSet();
            outputWriter.println(String.format("  Number of Registered Containers: [ %d ]", snapshotSet.size()));
            outputWriter.println();
            outputWriter.println("Containers in Set:");
            for (DirectoryBasedOverlayContainerImpl containerEntry : snapshotSet) {
                ArtifactEntry useEnclosingEntry = containerEntry.getEntryInEnclosingContainer();
                String enclosingEntryIntrospectFormat = "  [ %s ] [ %s ]";
                if (useEnclosingEntry == null) {
                    outputWriter.println(String.format(enclosingEntryIntrospectFormat, "ROOT", containerEntry.toString()));
                } else {
                    outputWriter.println(String.format(enclosingEntryIntrospectFormat, containerEntry.getFullPath(useEnclosingEntry), containerEntry.toString()));
                }
                ArtifactContainer baseContainer = containerEntry.getContainerBeingOverlaid();
                outputWriter.println(String.format("      Base [ %s ]", baseContainer.toString()));
                for (URL baseURL : baseContainer.getURLs()) {
                    outputWriter.println(String.format("        URL [ %s ]", baseURL.toString()));
                }
                ArtifactContainer fileContainer = containerEntry.getFileOverlay();
                outputWriter.println(String.format("      File [ %s ]", fileContainer.toString()));
                for (URL fileURL : fileContainer.getURLs()) {
                    outputWriter.println(String.format("        URL [ %s ]", fileURL.toString()));
                }
            }
            for (DirectoryBasedOverlayContainerImpl containerEntry : snapshotSet) {
                containerEntry.introspect(outputWriter);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OverlayContainerFactoryImpl.class, (String)"archive.overlay", null);
    }
}

